/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.OwCheckInDialog;
import com.wewebu.ow.server.plug.owdms.OwKeepContentDocumentImporter;
import com.wewebu.ow.server.plug.owdms.log.OwLog;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwDocumentFunctionCheckin
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwDocumentFunctionCheckin.class);
    protected OwObject m_checkinObject;
    protected OwObject m_parentObject;
    protected List m_documentImporters;
    private List m_propertyInfos;
    protected OwKeepContentDocumentImporter keepDocImporter;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_documentImporters = new ArrayList();
        List documentImporterConfigNodes = this.getConfigNode().getSafeNodeList("DocumentImporter");
        Iterator itDocumentImporterConfigNodes = documentImporterConfigNodes.iterator();
        while (itDocumentImporterConfigNodes.hasNext()) {
            OwStandardXMLUtil documentImporterConfig = new OwStandardXMLUtil((Node)itDocumentImporterConfigNodes.next());
            String className = documentImporterConfig.getSafeTextValue("ClassName", null);
            if (className == null) continue;
            try {
                Class<?> documentImporterClass = Class.forName(className);
                OwDocumentImporter documentImporter = (OwDocumentImporter)documentImporterClass.newInstance();
                documentImporter.init(this.getContext(), (OwXMLUtil)documentImporterConfig);
                this.m_documentImporters.add(documentImporter);
            }
            catch (ClassNotFoundException ex) {
                String msg = "Plugin initialization failed, Pluginid = " + this.getPluginID() + ". Documentimporter with classname = " + className + " not found, please check your owplugins.xml...";
                LOG.error((Object)msg, (Throwable)ex);
                throw new OwConfigurationException(msg, (Throwable)ex);
            }
        }
        Node subNode = null;
        try {
            subNode = this.getConfigNode().getSubNode("EditPropertyList");
        }
        catch (Exception e) {
            subNode = null;
        }
        if (subNode != null) {
            this.m_propertyInfos = new ArrayList();
            List propertyConfigNodes = this.getConfigNode().getSafeNodeList("EditPropertyList");
            Iterator it = propertyConfigNodes.iterator();
            while (it.hasNext()) {
                OwStandardXMLUtil propertyConfig = new OwStandardXMLUtil((Node)it.next());
                String propertyName = propertyConfig.getSafeTextValue(null);
                boolean fReadOnly = propertyConfig.getSafeBooleanAttributeValue("readonly", false);
                if (null == propertyName) continue;
                this.m_propertyInfos.add(new OwObjectPropertyView.OwPropertyInfo(propertyName, fReadOnly));
            }
        }
        this.keepDocImporter = new OwKeepContentDocumentImporter();
        this.keepDocImporter.init(context_p, node_p);
        if (this.m_documentImporters.size() <= 0) {
            throw new OwConfigurationException("There are no document importers configured for the Checkin Plugin. Do not know how to get the content.");
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdms/checkin.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdms/checkin_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        if (oObject_p.hasVersionSeries()) {
            return oObject_p.getVersion().canCheckin(iContext_p);
        }
        return false;
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            if (oObject_p.hasVersionSeries() && oObject_p.getVersion().isCheckedOut(2)) {
                boolean isMyCheckedOut = false;
                try {
                    isMyCheckedOut = oObject_p.getVersion().isMyCheckedOut(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!isMyCheckedOut) {
                    String checkedoutBy = null;
                    try {
                        checkedoutBy = oObject_p.getVersion().getCheckedOutUserID(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (checkedoutBy != null && !checkedoutBy.equals("")) {
                        checkedoutBy = this.getDisplayNameFromUserId(checkedoutBy);
                        throw new OwInvalidOperationException(this.getContext().localize1("plug.owdms.OwDocumentFunctionCheckin.documentCheckedOutbyOtherUser", "Cannot check in the document. The document was checked out by user (%1).", checkedoutBy));
                    }
                }
            }
            throw new OwInvalidOperationException(this.getContext().localize("plug.owdms.OwDocumentFunctionCheckin.documentNotCheckedOut", "Cannot check in the document. Did you check out the document before?"));
        }
        int iViewMask = 0;
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"MultipleFileUpload", (int)2);
        iViewMask |= oObject_p.canChangeClass() ? OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"ObjectClassView", (int)32) : 0;
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInModeOption", (int)128, (boolean)true);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInReleaseVersionOption", (int)256, (boolean)true);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInReleaseVersionDefault", (int)512, (boolean)true);
        if (oObject_p.hasContent(1)) {
            this.m_documentImporters.add(this.keepDocImporter);
        }
        OwCheckInDialog dlg = this.createCheckInDialog(oObject_p);
        this.m_checkinObject = oObject_p;
        this.m_parentObject = oParent_p;
        dlg.setViewMask(iViewMask);
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getDefaultLabel());
        dlg.setPropertiesInfo(this.m_propertyInfos);
        dlg.setInfoIcon(this.getBigIcon());
        dlg.setRefreshContext(refreshCtx_p);
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(oObject_p, oParent_p, 2, 1);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        int status = ((OwCheckInDialog)dialogView_p).getStatus();
        switch (status) {
            case 2: {
                this.addHistoryEvent(this.m_checkinObject, this.m_parentObject, 3, 2);
                break;
            }
            case 1: {
                this.addHistoryEvent(this.m_checkinObject, this.m_parentObject, 3, 1);
                ((OwCheckInDialog)dialogView_p).onClientRefreshContextUpdate(1, null);
                break;
            }
            default: {
                this.addHistoryEvent(this.m_checkinObject, this.m_parentObject, 3, 3);
            }
        }
        if (this.m_documentImporters.contains(this.keepDocImporter)) {
            this.m_documentImporters.remove(this.keepDocImporter);
        }
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    protected OwCheckInDialog createCheckInDialog(OwObject saveObject_p) throws Exception {
        return new OwCheckInDialog(saveObject_p, this.m_documentImporters);
    }
}

