/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.OwSaveDialog;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class OwDocumentFunctionSave
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    protected OwObject m_saveObject;
    protected OwObject m_parentObject;
    private List m_documentImporters;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_documentImporters = new ArrayList();
        List documentImporterConfigNodes = this.getConfigNode().getSafeNodeList("DocumentImporter");
        Iterator itDocumentImporterConfigNodes = documentImporterConfigNodes.iterator();
        while (itDocumentImporterConfigNodes.hasNext()) {
            OwStandardXMLUtil documentImporterConfig = new OwStandardXMLUtil((Node)itDocumentImporterConfigNodes.next());
            String className = documentImporterConfig.getSafeTextValue("ClassName", null);
            if (className == null) continue;
            Class<?> documentImporterClass = Class.forName(className);
            OwDocumentImporter documentImporter = (OwDocumentImporter)documentImporterClass.newInstance();
            documentImporter.init(this.getContext(), (OwXMLUtil)documentImporterConfig);
            this.m_documentImporters.add(documentImporter);
        }
        if (this.m_documentImporters.size() <= 0) {
            throw new OwConfigurationException("There are no document importers configured for the Save Plugin. Do not know how to get the content.");
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdms/save.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdms/save_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        if (oObject_p.hasVersionSeries()) {
            return oObject_p.getVersion().canSave(iContext_p);
        }
        return true;
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owdms.OwDocumentFunctionSave.invalidobject", "Item cannot be saved."));
        }
        int iViewMask = 0;
        OwSaveDialog dlg = new OwSaveDialog(oObject_p, this.m_documentImporters);
        this.m_saveObject = oObject_p;
        this.m_parentObject = oParent_p;
        dlg.setViewMask(iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"MultipleFileUpload", (int)2));
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getDefaultLabel());
        dlg.setInfoIcon(this.getBigIcon());
        dlg.setRefreshContext(refreshCtx_p);
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(oObject_p, oParent_p, 1, 1);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        int status = ((OwSaveDialog)dialogView_p).getStatus();
        switch (status) {
            case 2: {
                this.addHistoryEvent(this.m_saveObject, this.m_parentObject, 3, 2);
                break;
            }
            case 1: {
                this.addHistoryEvent(this.m_saveObject, this.m_parentObject, 3, 1);
                break;
            }
            default: {
                this.addHistoryEvent(this.m_saveObject, this.m_parentObject, 3, 3);
            }
        }
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }
}

