/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.alfresco;

import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.cmis.client.authentication.OAuthCMISAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Node;

public class OwCMISAlfrescoOAuthInterceptor
implements OwCMISAuthenticationInterceptor {
    private static final Logger LOG;
    public static final String EL_CLIENT_ID = "ClientId";
    public static final String EL_CLIENT_SECRETE = "ClientSecrete";
    public static final String EL_CALLBACK_URL = "CallbackUrl";
    public static final String EL_GRANT_URL = "GrantUrl";
    public static final String EL_ACCESS_URL = "AccessUrl";
    public static final String EL_REFRESH_URL = "RefreshUrl";
    public static final String EL_URL_ENCODING = "UrlEncoding";
    public static final String PARAM_CODE = "code";
    public static final String PARAM_REDIRECT_URI = "redirect_uri";
    public static final String PARAM_SCOPE = "scope";
    public static final String PARAM_RESPONSE_TYPE = "response_type";
    public static final String PARAM_CLIENT_ID = "client_id";
    private Map<String, String> conf;
    private String grantToken;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        OwCMISAlfrescoOAuthInterceptor.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAlfrescoOAuthInterceptor.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(OwXMLUtil owXMLUtil) throws OwException {
        OwXMLUtil owXMLUtil2 = owXMLUtil;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void configNode;
                this.conf = new HashMap<String, String>();
                for (Node n : configNode.getSafeNodeList()) {
                    this.conf.put(n.getNodeName(), n.getTextContent());
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)owXMLUtil2));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public synchronized AuthenticationProvider createAuthenticationProvider(Map<String, ?> map) throws OwException {
        Map<String, ?> map2 = map;
        try {
            OAuthCMISAuthenticationProvider oAuthCMISAuthenticationProvider;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.getConfigValue(EL_ACCESS_URL) == null) {
                    oAuthCMISAuthenticationProvider = OAuthCMISAuthenticationProvider.alfrescoOAuthProvider((String)this.getConfigValue(EL_CLIENT_ID), (String)this.getConfigValue(EL_CLIENT_SECRETE), (String)this.getConfigValue(EL_CALLBACK_URL), (String)this.getGrantToken());
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Creating OAuthCMISAuthenticationProvider with non-default configuration");
                        LOG.trace((Object)("Callback-/Redirect-URL = " + this.getConfigValue(EL_CALLBACK_URL)));
                        LOG.trace((Object)("AccessToken-URL = " + this.getConfigValue(EL_ACCESS_URL)));
                        LOG.trace((Object)("RefreshToken-URL = " + this.getConfigValue(EL_REFRESH_URL)));
                        LOG.trace((Object)("Grant = " + this.grantToken));
                    }
                    oAuthCMISAuthenticationProvider = new OAuthCMISAuthenticationProvider(this.getConfigValue(EL_CLIENT_ID), this.getConfigValue(EL_CLIENT_SECRETE), this.getConfigValue(EL_CALLBACK_URL), this.getConfigValue(EL_ACCESS_URL), this.getConfigValue(EL_REFRESH_URL), this.getGrantToken());
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return oAuthCMISAuthenticationProvider;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, map2));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws OwException, IOException {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void resp;
                void req;
                req.getRequestURI();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"OwCMISAlfrescoOAuthInterceptor.onRequest: request parameter:");
                    for (Map.Entry param : req.getParameterMap().entrySet()) {
                        String[] paramVals;
                        StringBuilder logTrace = new StringBuilder();
                        String[] stringArray = paramVals = (String[])param.getValue();
                        int n = paramVals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String value = stringArray[n2];
                            if (logTrace.length() > 0) {
                                logTrace.append(",");
                            }
                            logTrace.append(value);
                            ++n2;
                        }
                        logTrace.insert(0, " ");
                        logTrace.insert(0, param.getKey());
                        LOG.trace((Object)logTrace);
                    }
                }
                bl = req.getParameter(PARAM_CODE) != null ? this.stageTwo((HttpServletRequest)req, (HttpServletResponse)resp) : this.stageOne((HttpServletRequest)req, (HttpServletResponse)resp);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)httpServletRequest2, (Object)httpServletResponse2));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean stageOne(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws OwException, IOException {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                StringBuilder grantUrl = new StringBuilder(this.getConfigValue(EL_GRANT_URL));
                if (grantUrl.length() > 0) {
                    void resp;
                    this.appendParameter(grantUrl, PARAM_CLIENT_ID, this.getConfigValue(EL_CLIENT_ID));
                    this.appendParameter(grantUrl, PARAM_REDIRECT_URI, this.getConfigValue(EL_CALLBACK_URL));
                    this.appendParameter(grantUrl, PARAM_SCOPE, this.getConfigValue(PARAM_SCOPE));
                    this.appendParameter(grantUrl, PARAM_RESPONSE_TYPE, this.getConfigValue(PARAM_RESPONSE_TYPE, PARAM_CODE));
                    resp.sendRedirect(grantUrl.toString());
                    bl = false;
                } else {
                    bl = true;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)httpServletRequest2, (Object)httpServletResponse2));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean stageTwo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws OwException {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void req;
                this.grantToken = req.getParameter(PARAM_CODE);
                if (this.grantToken == null) {
                    throw new OwAccessDeniedException("Grant for cloud access denied");
                }
                bl = true;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)httpServletRequest2, (Object)httpServletResponse2));
            }
            throw cmisBaseException;
        }
    }

    protected String getConfigValue(String configName) {
        return this.conf.get(configName);
    }

    protected String getConfigValue(String configName, String defaultValue) {
        String val = this.getConfigValue(configName);
        return val == null ? defaultValue : val;
    }

    protected void appendParameter(StringBuilder url, String paramName, String paramVal) throws UnsupportedEncodingException {
        if (paramName != null && paramVal != null) {
            if (url.indexOf("?") < 0) {
                url.append("?");
            }
            if (url.charAt(url.length() - 1) != '?') {
                url.append("&");
            }
            url.append(paramName);
            url.append("=");
            url.append(URLEncoder.encode(paramVal, "UTF-8"));
        }
    }

    protected String getGrantToken() {
        return this.grantToken;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAlfrescoOAuthInterceptor.java", OwCMISAlfrescoOAuthInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoOAuthInterceptor", "com.wewebu.ow.server.util.OwXMLUtil", "configNode", "com.wewebu.ow.server.exceptions.OwException", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "createAuthenticationProvider", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoOAuthInterceptor", "java.util.Map", "information", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onRequest", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoOAuthInterceptor", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse", "req:resp", "com.wewebu.ow.server.exceptions.OwException:java.io.IOException", "boolean"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "stageOne", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoOAuthInterceptor", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse", "req:resp", "com.wewebu.ow.server.exceptions.OwException:java.io.IOException", "boolean"), 149);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "stageTwo", "com.wewebu.ow.server.ecmimpl.opencmis.alfresco.OwCMISAlfrescoOAuthInterceptor", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse", "req:resp", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 176);
    }
}

