/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticator;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISCredentialsAuthenticator
implements OwAuthenticator {
    private static final String ECM_ADAPTER = "EcmAdapter";
    private static final Logger LOG;
    public static final String CONF_NODE_SECURITY_HANDLER = "SecurityHandler";
    private OwBaseInitializer baseInitializer;
    private OwCMISNetwork network;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OwCMISCredentialsAuthenticator.ajc$preClinit();
        LOG = OwLogCore.getLogger(OwCMISCredentialsAuthenticator.class);
    }

    public OwCMISCredentialsAuthenticator(OwBaseInitializer initializer) {
        this.baseInitializer = initializer;
    }

    public OwCMISCredentialsAuthenticator(OwCMISNetwork network) {
        this.network = network;
    }

    public OwAuthentication authenticate(OwAuthentication authentication_p) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        String userName = authentication_p.getUserName();
        String password = authentication_p.getPassword();
        if (userName != null && password != null) {
            OwCMISCredentials credentials = null;
            try {
                SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
                Map<String, String> opencmisParameters = this.buildOpenCmisParameters(userName, password, null);
                OwCMISNetworkCfg cfg = this.getNetworkConfiguration();
                AuthenticationProvider authProv = null;
                if (cfg.getAuthenticationInterceptor() != null) {
                    authProv = this.retrieveAuthenticationProvider(opencmisParameters, cfg);
                    sessionFactory.getRepositories(opencmisParameters, null, authProv, null);
                } else {
                    sessionFactory.getRepositories(opencmisParameters);
                }
                credentials = this.createCredentials(userName, password, authProv);
            }
            catch (CmisPermissionDeniedException e) {
                LOG.debug((Object)"OwCMISCredentialsAuthenticator.authenticate(): Cmis exception unallowed!", (Throwable)e);
                throw new OwAuthenticationException(new OwString("opencmis.auth.OwCMISCredentialsAuthenticator.err.login.failed", "Login failed: Wrong username or password!"), (Throwable)e);
            }
            catch (OwException owe) {
                LOG.error((Object)"Could not create credentials !", (Throwable)owe);
                throw new OwServerException("Invalid configuration exception!", (Throwable)owe);
            }
            OwCredentialsAuthentication credentialsAuthentication = new OwCredentialsAuthentication((OwCredentials)credentials, userName, password);
            return credentialsAuthentication;
        }
        LOG.debug((Object)"OwCMISCredentialsAuthenticator.authenticate(): Login failed: Wrong username or password!");
        throw new OwAuthenticationException(new OwString("opencmis.auth.OwCMISCredentialsAuthenticator.err.login.failed", "Login failed: Wrong username or password!"));
    }

    protected OwCMISNetworkCfg getNetworkConfiguration() throws OwConfigurationException {
        if (this.network != null) {
            return this.network.getNetworkConfiguration();
        }
        OwXMLUtil bootstrapx = OwConfiguration.getBootstrap((OwBaseInitializer)this.baseInitializer);
        if (bootstrapx == null) {
            String msg = "No bootstrap.";
            LOG.error((Object)("OwCMISRepositoryAuthenticator.authenticate :" + msg));
            throw new OwConfigurationException(msg);
        }
        try {
            return new OwCMISNetworkCfg(bootstrapx.getSubUtil(ECM_ADAPTER));
        }
        catch (Exception e) {
            String msg = "Invalid bootstrap.";
            LOG.error((Object)("OwCMISRepositoryAuthenticator.authenticate :" + msg));
            throw new OwConfigurationException(msg, (Throwable)e);
        }
    }

    public Map<String, String> buildOpenCmisParameters(String user_p, String pwd_p, Locale currentLocale_p) throws OwConfigurationException {
        Map<String, String> opencmisParameters = this.getNetworkConfiguration().getBindingConfig();
        opencmisParameters.put("org.apache.chemistry.opencmis.user", user_p);
        opencmisParameters.put("org.apache.chemistry.opencmis.password", pwd_p);
        if (currentLocale_p != null && !"debugmode".equals(currentLocale_p.toString())) {
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.iso3166", currentLocale_p.getCountry());
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.iso639", currentLocale_p.getLanguage());
            opencmisParameters.put("org.apache.chemistry.opencmis.locale.variant", currentLocale_p.getVariant());
        }
        return opencmisParameters;
    }

    /*
     * WARNING - void declaration
     */
    protected OwCMISCredentials createCredentials(String string, String string2, AuthenticationProvider authenticationProvider) throws OwException {
        String string3 = string;
        String string4 = string2;
        AuthenticationProvider authenticationProvider2 = authenticationProvider;
        try {
            OwCMISCredentials owCMISCredentials;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void nativeAuthProvider;
                void password_p;
                void user_p;
                owCMISCredentials = new OwCMISCredentials((String)user_p, (String)password_p, (AuthenticationProvider)nativeAuthProvider);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISCredentials;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string3, string4, authenticationProvider2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISNetwork getNetwork() {
        return this.network;
    }

    protected OwBaseInitializer getBaseInitialzier() {
        return this.baseInitializer;
    }

    /*
     * WARNING - void declaration
     */
    protected AuthenticationProvider retrieveAuthenticationProvider(Map<String, String> map, OwCMISNetworkCfg owCMISNetworkCfg) throws OwException {
        Map<String, String> map2 = map;
        OwCMISNetworkCfg owCMISNetworkCfg2 = owCMISNetworkCfg;
        try {
            AuthenticationProvider authenticationProvider;
            block7: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    if (this.network != null) {
                        void openCmisParams;
                        authenticationProvider = this.network.getAuthInterceptor().createAuthenticationProvider((Map<String, ?>)openCmisParams);
                        break block7;
                    }
                    throw new OwNotSupportedException("Cannot get prepared org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider without valid Network instance.");
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return authenticationProvider;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, map2, (Object)((Object)owCMISNetworkCfg2)));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OwLdapConnector createLDAPConnector(OwAuthenticationConfiguration owAuthenticationConfiguration) throws OwException {
        OwAuthenticationConfiguration owAuthenticationConfiguration2 = owAuthenticationConfiguration;
        try {
            OwLdapConnector owLdapConnector;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void authenticationConf_p;
                owLdapConnector = new OwLdapConnector(authenticationConf_p.getConfiguration().getNode());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owLdapConnector;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)owAuthenticationConfiguration2));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCredentialsAuthenticator.java", OwCMISCredentialsAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCredentials", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator", "java.lang.String:java.lang.String:org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider", "user_p:password_p:nativeAuthProvider", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials"), 192);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "retrieveAuthenticationProvider", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator", "java.util.Map:com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg", "openCmisParams:netConfig", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider"), 225);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createLDAPConnector", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator", "com.wewebu.ow.server.util.OwAuthenticationConfiguration", "authenticationConf_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.util.ldap.OwLdapConnector"), 243);
    }
}

