/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISLDAPCredentialsAuthenticator
extends OwCMISCredentialsAuthenticator {
    private static final Logger LOG;
    private OwLdapConnector ldapCon;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        OwCMISLDAPCredentialsAuthenticator.ajc$preClinit();
        LOG = OwLogCore.getLogger(OwCMISLDAPCredentialsAuthenticator.class);
    }

    public OwCMISLDAPCredentialsAuthenticator(OwCMISNetwork network, OwLdapConnector ldapConnector) {
        super(network);
        this.ldapCon = ldapConnector;
    }

    public OwCMISLDAPCredentialsAuthenticator(OwBaseInitializer initializer) {
        super(initializer);
    }

    protected OwLdapConnector getLdapConnector() throws OwException {
        try {
            OwLdapConnector owLdapConnector;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.ldapCon != null) {
                    owLdapConnector = this.ldapCon;
                } else {
                    OwCMISNetworkCfg config = this.getNetworkConfiguration();
                    OwAuthenticationConfiguration authConf = config.getAuthenticationConfiguration();
                    if (authConf != null && "LDAP".equals(authConf.getMode())) {
                        this.ldapCon = this.createLDAPConnector(authConf);
                    }
                    owLdapConnector = this.ldapCon;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owLdapConnector;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected OwCMISCredentials createCredentials(String string, String string2, AuthenticationProvider authenticationProvider) throws OwException {
        String string3 = string;
        String string4 = string2;
        AuthenticationProvider authenticationProvider2 = authenticationProvider;
        try {
            OwCMISLDAPCredentials owCMISLDAPCredentials;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void nativeAuthProvider;
                void password_p;
                void user_p;
                owCMISLDAPCredentials = new OwCMISLDAPCredentials((String)user_p, (String)password_p, (AuthenticationProvider)nativeAuthProvider, this.getLdapConnector());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISLDAPCredentials;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string3, string4, authenticationProvider2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwAuthentication authenticate(OwAuthentication authentication_p) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        String userName = authentication_p.getUserName();
        String password = authentication_p.getPassword();
        if (userName != null && password != null) {
            this.authenticateOverLdap(userName, password);
        }
        return super.authenticate(authentication_p);
    }

    private void authenticateOverLdap(String userName, String password) throws OwServerException, OwConfigurationException, OwAuthenticationException {
        OwLdapConnector conLdap;
        try {
            conLdap = this.getLdapConnector();
        }
        catch (OwException e1) {
            LOG.debug((Object)"LDAP connection cannot be retrieved", (Throwable)e1);
            throw new OwServerException("Faild to create LDAP connection", (Throwable)e1);
        }
        if (conLdap != null) {
            try {
                conLdap.authenticate(userName, password);
            }
            catch (OwAuthenticationException owa) {
                LOG.debug((Object)"Authentication Exception: Cloud not verify login against LDAP", (Throwable)owa);
                throw new OwAuthenticationException(new OwString("ecmimpl.opencmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password"), (Throwable)owa);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISLDAPCredentialsAuthenticator.java", OwCMISLDAPCredentialsAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getLdapConnector", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPCredentialsAuthenticator", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.util.ldap.OwLdapConnector"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCredentials", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPCredentialsAuthenticator", "java.lang.String:java.lang.String:org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider", "user_p:password_p:nativeAuthProvider", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials"), 83);
    }
}

