/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.conf;

import com.wewebu.ow.server.ecm.OwManagedSemiVirtualRecordConfiguration;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimpleDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISIDDMSIDConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Node;

public class OwCMISNetworkCfg
extends OwNetworkConfiguration {
    private static final Logger LOG;
    public static final String EL_ATOM_PUB = "AtomPub";
    public static final String EL_WSDL_REPOSITORY = "WSDLRepository";
    public static final String EL_WSDL_NAVIGATION = "WSDLNavigation";
    public static final String EL_WSDL_OBJECT = "WSDLObject";
    public static final String EL_WSDL_MULTIFILING = "WSDLMultifiling";
    public static final String EL_WSDL_DISCOVERY = "WSDLDiscovery";
    public static final String EL_WSDL_VERSIONING = "WSDLVersioning";
    public static final String EL_WSDL_RELATIONSHIP = "WSDLRelationship";
    public static final String EL_WSDL_POLICY = "WSDLPolicy";
    public static final String EL_WSDL_ACL = "WSDLACL";
    public static final String EL_DEFAULTVERSIONHANDLING = "DefaultVersionHandling";
    public static final String EL_PROPERTY_ORDER = "PreferedPropertyOrder";
    public static final String EL_ID_DMSID_CONVERTER_CLASS = "IDDMSIDConverterClass";
    public static final String EL_DEFAULT_REPOSITORY = "DefaultObjectStore";
    public static final String EL_AUTH_INTERCEPTOR = "AuthInterceptor";
    public static final String AT_CLASS_NAME = "className";
    public static final String EL_ADAPTER_SESSION_CONF = "adapterSessionConf";
    public static final String EL_OPEN_CMIS_CONF = "openCmisConf";
    public static final String EL_OPEN_CMIS_ENTRY = "entry";
    public static final String AT_ENTRY_KEY = "key";
    public static final String EL_CONF_NONSERIALIZED_ID = "NonSerializedId";
    private static final String FOLDERCHILDREN_CONTEXT = "FolderChildren";
    private static final String NORMALIZE_VERSION = "normalize";
    private static final String PRESERVE_VERSION = "preserve";
    private static final List<String> NATIVE_ID_PROPERTIES;
    private Map<String, String> versionHandling;
    private Boolean preservVersion;
    private OwCMISPreferredPropertyTypeCfg preferredPropertyTypeCfg;
    private OwCMISDMSIDDecoder dmsidDecoder;
    private OwManagedSemiVirtualRecordConfiguration semiVirtualConfiguration;
    private Map<String, OwCMISIDDMSIDConverter> idDMSIDConverters = new HashMap<String, OwCMISIDDMSIDConverter>();
    private Collection<String> nonSerializedPropIds;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        OwCMISNetworkCfg.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISNetworkCfg.class);
        NATIVE_ID_PROPERTIES = Arrays.asList("cmis:objectId", "cmis:objectTypeId", "cmis:baseTypeId", "cmis:versionSeriesId", "cmis:parentId", "cmis:contentStreamId", "cmis:allowedChildObjectTypeIds", "IndexationId");
    }

    public OwCMISNetworkCfg(OwXMLUtil config_p) {
        super(config_p);
    }

    public synchronized Map<String, String> getDefaultVersionHandling() {
        if (this.versionHandling == null) {
            OwXMLUtil configNode = this.getConfigNode();
            this.versionHandling = new HashMap<String, String>();
            List contexts = configNode.getSafeNodeList(EL_DEFAULTVERSIONHANDLING);
            for (Node context : contexts) {
                this.versionHandling.put(context.getNodeName(), context.getTextContent());
            }
        }
        return this.versionHandling;
    }

    public String getDefaultVersionHandling(String context_p) {
        Map<String, String> versionHandligMap = this.getDefaultVersionHandling();
        return versionHandligMap.get(context_p);
    }

    public boolean isPreservedVersion() {
        if (this.preservVersion == null) {
            String folderChildrenVersionHandling = this.getDefaultVersionHandling(FOLDERCHILDREN_CONTEXT);
            if (LOG.isDebugEnabled()) {
                if (folderChildrenVersionHandling == null) {
                    LOG.debug((Object)"No default version hanling configured for FolderChildren");
                } else if (!NORMALIZE_VERSION.equalsIgnoreCase(folderChildrenVersionHandling) && !PRESERVE_VERSION.equals(folderChildrenVersionHandling)) {
                    LOG.debug((Object)("Invalid version hanling configured for FolderChildren : " + folderChildrenVersionHandling));
                }
            }
            this.preservVersion = NORMALIZE_VERSION.equalsIgnoreCase(folderChildrenVersionHandling) ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.preservVersion;
    }

    public OwXMLUtil getBpmNode() throws OwConfigurationException {
        OwXMLUtil result = null;
        try {
            result = this.getConfigNode().getSubUtil("BPM");
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not get the BPM configuration!", (Throwable)e);
        }
        if (result == null) {
            throw new OwConfigurationException("Could not get the BPM configuration!");
        }
        return result;
    }

    public OwCMISPreferredPropertyTypeCfg getPreferredPropertyTypeCfg() {
        if (this.preferredPropertyTypeCfg == null) {
            this.preferredPropertyTypeCfg = new OwCMISPreferredPropertyTypeCfg(this.getConfigNode());
        }
        return this.preferredPropertyTypeCfg;
    }

    public List<String> getPreferedPropertyOrder() throws OwException {
        try {
            LinkedList<String> linkedList;
            block11: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    Node preferedOrderNode = null;
                    try {
                        preferedOrderNode = this.getConfigNode().getSubNode(EL_PROPERTY_ORDER);
                    }
                    catch (Exception exception) {
                        LOG.warn((Object)"OwCMISNetworkConfig.getPerferedPropertyOrder: Configuration \"PreferedPropertyOrder\" could not be read.");
                    }
                    if (preferedOrderNode == null) {
                        linkedList = new LinkedList();
                        break block11;
                    }
                    try {
                        linkedList = new OwStandardXMLUtil(preferedOrderNode).getSafeStringList();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Parsing of PreferedPropertyOrder node failed", (Throwable)e);
                        throw new OwServerException("Could not parse configuration of PreferedPropertyOrder", (Throwable)e);
                    }
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this)));
            }
            throw cmisBaseException;
        }
    }

    public synchronized OwCMISDMSIDDecoder getDMSIDDecoder() {
        if (this.dmsidDecoder == null) {
            this.dmsidDecoder = new OwCMISSimpleDMSIDDecoder();
        }
        return this.dmsidDecoder;
    }

    public Map<String, String> getSessionParametersConfig() throws OwConfigurationException {
        return this.addConfigurationProperties(EL_ADAPTER_SESSION_CONF, EL_OPEN_CMIS_ENTRY, AT_ENTRY_KEY, new HashMap<String, String>());
    }

    public Map<String, String> getBindingConfig() throws OwConfigurationException {
        String url = this.getConfigNode().getSafeTextValue(EL_ATOM_PUB, null);
        HashMap<String, String> connection = new HashMap<String, String>();
        if (url != null) {
            connection.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            connection.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"OwCMISNetworkCfg.getBinidngConfig: AtomPub binding is configured.");
            }
        } else {
            url = this.getConfigNode().getSafeTextValue(EL_WSDL_REPOSITORY, null);
            if (url != null) {
                connection.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
                connection.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
                connection.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.getConfigNode().getSafeTextValue(EL_WSDL_NAVIGATION, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.getConfigNode().getSafeTextValue(EL_WSDL_OBJECT, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.getConfigNode().getSafeTextValue(EL_WSDL_VERSIONING, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.getConfigNode().getSafeTextValue(EL_WSDL_DISCOVERY, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.getConfigNode().getSafeTextValue(EL_WSDL_RELATIONSHIP, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.getConfigNode().getSafeTextValue(EL_WSDL_MULTIFILING, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.getConfigNode().getSafeTextValue(EL_WSDL_POLICY, null));
                connection.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.getConfigNode().getSafeTextValue(EL_WSDL_ACL, null));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"OwCMISNetworkCfg.getBinidngConfig: WebService (SOAP) binding is configured.");
                }
            } else {
                connection.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.LOCAL.value());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"OwCMISNetworkCfg.getBinidngConfig: LOCAL binding is configured.");
                }
            }
        }
        return this.setAdditionalConnectionInformation(connection);
    }

    protected Map<String, String> setAdditionalConnectionInformation(Map<String, String> map) {
        return this.addConfigurationProperties(EL_OPEN_CMIS_CONF, EL_OPEN_CMIS_ENTRY, AT_ENTRY_KEY, map);
    }

    protected Map<String, String> addConfigurationProperties(String listNodeName, String itemName, String keyAttributeName, Map<String, String> map) {
        List extConfLst = this.getConfigNode().getSafeUtilList(listNodeName, itemName);
        if (extConfLst != null && !extConfLst.isEmpty()) {
            for (OwXMLUtil util : extConfLst) {
                String key = util.getSafeStringAttributeValue(keyAttributeName, null);
                String val = util.getSafeTextValue(null);
                if (key != null && val != null) {
                    map.put(key, val);
                    continue;
                }
                LOG.warn((Object)("Invalid extended OpenCMIS found @key = " + key + " value = " + val));
            }
        }
        return map;
    }

    public String getDefaultRepository() {
        return this.getConfigNode().getSafeTextValue(EL_DEFAULT_REPOSITORY, null);
    }

    public OwManagedSemiVirtualRecordConfiguration getSemiVirtualConfiguration() throws OwConfigurationException {
        if (this.semiVirtualConfiguration == null) {
            this.semiVirtualConfiguration = new OwManagedSemiVirtualRecordConfiguration(this.getConfigNode());
        }
        return this.semiVirtualConfiguration;
    }

    public OwCMISAuthenticationInterceptor getAuthenticationInterceptor() throws OwException {
        try {
            OwCMISAuthenticationInterceptor owCMISAuthenticationInterceptor;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwXMLUtil conf;
                String className = null;
                try {
                    conf = this.getConfigNode().getSubUtil(EL_AUTH_INTERCEPTOR);
                    if (conf != null) {
                        className = conf.getSafeStringAttributeValue(AT_CLASS_NAME, null);
                    }
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not read \"AuthInterceptor\" configuration", (Throwable)e);
                    throw new OwConfigurationException("Could not read configuration", (Throwable)e);
                }
                OwCMISAuthenticationInterceptor interceptor = null;
                if (className != null) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        Constructor<?> cons = clazz.getConstructor(new Class[0]);
                        interceptor = (OwCMISAuthenticationInterceptor)cons.newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new OwConfigurationException("Invalid class of type = " + className, (Throwable)e);
                    }
                    catch (SecurityException e) {
                        throw new OwServerException("Environment Restriction to access class for \"AuthInterceptor\".", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new OwServerException("Missing default constructor for \"AuthInterceptor\".", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new OwServerException("Invalid Argument for AuthInterceptor instantiation", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new OwServerException("Could not create instance for defined AuthInterceptor", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new OwConfigurationException("Access to default consturctor is illegal, class loading problem!", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new OwServerException("Could not invoke default constructor for AuthInterceptor", (Throwable)e);
                    }
                    interceptor.init(conf);
                }
                owCMISAuthenticationInterceptor = interceptor;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISAuthenticationInterceptor;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this)));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized OwCMISValueConverter<String, String> getIdDMSIDConverter(String string) throws OwException {
        String string2 = string;
        try {
            OwCMISIDDMSIDConverter owCMISIDDMSIDConverter;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void resourceID_p;
                OwCMISIDDMSIDConverter idDMSIDConverter = this.idDMSIDConverters.get(resourceID_p);
                if (idDMSIDConverter == null) {
                    try {
                        String javaClassName = this.getConfigNode().getSafeTextValue(EL_ID_DMSID_CONVERTER_CLASS, OwCMISIDDMSIDConverter.class.getName());
                        Class<?> javaClass = Class.forName(javaClassName);
                        Constructor<?> constructor = javaClass.getConstructor(OwCMISDMSIDDecoder.class, String.class);
                        idDMSIDConverter = (OwCMISIDDMSIDConverter)constructor.newInstance(this.getDMSIDDecoder(), resourceID_p);
                        this.idDMSIDConverters.put((String)resourceID_p, idDMSIDConverter);
                    }
                    catch (Exception e) {
                        throw new OwConfigurationException("Error accessing the ID to DMSID converter configuration!", (Throwable)e);
                    }
                }
                owCMISIDDMSIDConverter = idDMSIDConverter;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISIDDMSIDConverter;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public Collection<String> getNonSerializedPropertyIds() throws OwException {
        try {
            Collection<String> collection;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.nonSerializedPropIds == null) {
                    try {
                        List nonSerLst = this.getConfigNode().getSafeStringList(EL_CONF_NONSERIALIZED_ID);
                        this.nonSerializedPropIds = nonSerLst != null && !nonSerLst.isEmpty() ? Collections.unmodifiableCollection(nonSerLst) : Collections.unmodifiableCollection(NATIVE_ID_PROPERTIES);
                    }
                    catch (Exception e) {
                        throw new OwConfigurationException("Error accessing node NonSerializedId from configuration!", (Throwable)e);
                    }
                }
                collection = this.nonSerializedPropIds;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this)));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISNetworkCfg.java", OwCMISNetworkCfg.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPreferedPropertyOrder", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 214);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthenticationInterceptor", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor"), 394);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getIdDMSIDConverter", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg", "java.lang.String", "resourceID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter"), 459);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonSerializedPropertyIds", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 491);
    }
}

