/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.content;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.opencmis.content.OwCMISContentElement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.TransientDocument;
import org.apache.log4j.Logger;

public class OwCMISContentCollection
implements OwContentCollection {
    private static final Logger LOG = OwLog.getLogger(OwCMISContentCollection.class);
    private static final List<Integer> CONTENT_TYPES = new LinkedList<Integer>();
    private TransientDocument doc;

    static {
        CONTENT_TYPES.add(1);
    }

    public OwCMISContentCollection(TransientDocument document) {
        this.doc = document;
    }

    public OwContentElement getContentElement(int iContentType_p, int iPage_p) throws Exception {
        if (iPage_p > this.getPageCount()) {
            throw new OwInvalidOperationException((OwString)new OwString2("opencmis.OwCMISContentCollection.err.invalidIdx", "The provided page index %1 is larger than current page count %2", Integer.toString(iPage_p), Integer.toString(this.getPageCount())));
        }
        if (this.getContentTypes().contains(iContentType_p)) {
            return new OwCMISContentElement(this.doc.getContentStream());
        }
        LOG.warn((Object)("OwCMISContentCollection.getContentElement: Request of unsupported/non-contained content type, id = " + iContentType_p));
        throw new OwInvalidOperationException(new OwString("opencmis.OwCMISContentCollection.err.invalidContentType", "The requested content type is not available."));
    }

    public int getPageCount() throws Exception {
        if (this.doc.getContentStream() == null) {
            return 0;
        }
        return 1;
    }

    public Collection<Integer> getContentTypes() throws Exception {
        return CONTENT_TYPES;
    }

    protected TransientDocument getNativeObject() {
        return this.doc;
    }
}

