/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.converter;

import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISDateTime;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class OwCMISDateConverter
implements OwCMISValueConverter<GregorianCalendar, Date> {
    private TimeZone timeZone;

    public OwCMISDateConverter(TimeZone timezone) {
        this.timeZone = timezone;
    }

    private GregorianCalendar toGregorianCalendar(Date date_p) throws OwInvalidOperationException {
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(date_p, this.getTimeZone());
        GregorianCalendar calendar = cmisDateTime.getCalendar();
        return calendar;
    }

    private Date toDate(GregorianCalendar calendar_p) {
        if (calendar_p == null) {
            return null;
        }
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(calendar_p);
        TimeZone tzServer = calendar_p.getTimeZone();
        return OwDateTimeUtil.convert((Date)cmisDateTime.getDate(true), (TimeZone)tzServer, (TimeZone)this.getTimeZone());
    }

    @Override
    public List<GregorianCalendar> fromArrayValue(Object[] owdValue_p) throws OwInvalidOperationException {
        LinkedList<GregorianCalendar> calendarList = new LinkedList<GregorianCalendar>();
        if (owdValue_p != null) {
            int i = 0;
            while (i < owdValue_p.length) {
                if (owdValue_p[i] != null) {
                    GregorianCalendar calendar = this.toGregorianCalendar((Date)owdValue_p[i]);
                    calendarList.add(calendar);
                } else {
                    calendarList.add(null);
                }
                ++i;
            }
        }
        return calendarList;
    }

    @Override
    public List<GregorianCalendar> fromValue(Date owdValue_p) throws OwInvalidOperationException {
        LinkedList<GregorianCalendar> calendarList = new LinkedList<GregorianCalendar>();
        if (owdValue_p != null) {
            calendarList.add(this.toGregorianCalendar(owdValue_p));
        }
        return calendarList;
    }

    public Date[] toArrayValue(List<GregorianCalendar> cmisValue_p) {
        return this.toStaticArrayValue(cmisValue_p);
    }

    @Override
    public Date toValue(List<GregorianCalendar> cmisValue_p) {
        return this.toStaticValue(cmisValue_p);
    }

    public Class<Date> getOClass() {
        return Date.class;
    }

    public Date[] toStaticArrayValue(List<GregorianCalendar> cmisValue_p) {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        Date[] dateValues = new Date[cmisValue_p.size()];
        int i = 0;
        while (i < dateValues.length) {
            GregorianCalendar calendarValue = cmisValue_p.get(i);
            dateValues[i] = this.toDate(calendarValue);
            ++i;
        }
        return dateValues;
    }

    public Date toStaticValue(List<GregorianCalendar> cmisValue_p) {
        if (cmisValue_p == null || cmisValue_p.isEmpty()) {
            return null;
        }
        return this.toDate(cmisValue_p.get(0));
    }

    protected TimeZone getTimeZone() {
        return this.timeZone;
    }
}

