/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.converter;

import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwStandardUnresolvedReference;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSession;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISIdObjectConverter
implements OwCMISValueConverter<String, OwObjectReference> {
    private static final Logger LOG = OwLog.getLogger(OwCMISIdObjectConverter.class);
    private OwCMISValueConverter<String, String> dmsidConverter;
    private OwCMISSession session;

    public OwCMISIdObjectConverter(OwCMISSession session_p, OwCMISValueConverter<String, String> dmsidConverter_p) {
        this.dmsidConverter = dmsidConverter_p;
        this.session = session_p;
    }

    @Override
    public List<String> fromArrayValue(Object[] owdValue_p) throws OwInvalidOperationException {
        try {
            Object[] owdDmsidValues = null;
            if (owdValue_p != null) {
                owdDmsidValues = new String[owdValue_p.length];
                int i = 0;
                while (i < owdDmsidValues.length) {
                    if (owdValue_p[i] != null) {
                        OwObjectReference referenceValue = (OwObjectReference)owdValue_p[i];
                        owdDmsidValues[i] = referenceValue.getDMSID();
                    } else {
                        owdDmsidValues[i] = null;
                    }
                    ++i;
                }
            }
            return this.dmsidConverter.fromArrayValue(owdDmsidValues);
        }
        catch (OwInvalidOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISIdObjectConverter.fromArrayValue(): Could not retrieve DMSID!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("opencmis.OwCMISIdObjectConverter.err.invalid.object", "Invalid object!"), (Throwable)e);
        }
    }

    @Override
    public List<String> fromValue(OwObjectReference owdValue_p) throws OwInvalidOperationException {
        try {
            String owdDmsidValue = null;
            if (owdValue_p != null && (owdDmsidValue = owdValue_p.getDMSID()).contains(";")) {
                owdDmsidValue = owdDmsidValue.split(";")[0];
            }
            return this.dmsidConverter.fromValue(owdDmsidValue);
        }
        catch (OwInvalidOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISIdObjectConverter.fromArrayValue(): Could not retrieve DMSID!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("opencmis.OwCMISIdObjectConverter.err.invalid.object", "Invalid object!"), (Throwable)e);
        }
    }

    public OwObjectReference[] toArrayValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        String[] owdDmsidValues = this.dmsidConverter.toArrayValue(cmisValue_p);
        if (owdDmsidValues != null) {
            OwObjectReference[] objects = new OwObjectReference[owdDmsidValues.length];
            int i = 0;
            while (i < owdDmsidValues.length) {
                objects[i] = owdDmsidValues[i] != null ? this.toObjectReference(owdDmsidValues[i], true) : null;
                ++i;
            }
            return objects;
        }
        return null;
    }

    @Override
    public OwObjectReference toValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        String owdDmsidValue = this.dmsidConverter.toValue(cmisValue_p);
        return this.toObjectReference(owdDmsidValue, true);
    }

    protected OwObjectReference toObjectReference(String dmsid, boolean refresh) {
        if (dmsid == null) {
            return null;
        }
        try {
            return this.session.getObject(dmsid, refresh);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Could not create object from DMSID = " + dmsid), (Throwable)e);
            } else {
                LOG.warn((Object)("OwCMISIdObjectConverter.toObjectReference(): Could not create object from DMSID = " + dmsid));
            }
            return new OwStandardUnresolvedReference(e, e.getMessage(), dmsid, null, null, 0);
        }
    }
}

