/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class OwCMISBigIntegerTextFormat
extends Format {
    private static final long serialVersionUID = 7124849733436615011L;
    private DecimalFormat decimalFormat;

    public OwCMISBigIntegerTextFormat() {
        this(new DecimalFormat());
    }

    public OwCMISBigIntegerTextFormat(String pattern_p) {
        this(new DecimalFormat(pattern_p));
    }

    public OwCMISBigIntegerTextFormat(String pattern_p, DecimalFormatSymbols symbols_p) {
        this(new DecimalFormat(pattern_p, symbols_p));
    }

    private OwCMISBigIntegerTextFormat(DecimalFormat decimalFormat_p) {
        this.decimalFormat = decimalFormat_p;
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setParseIntegerOnly(true);
    }

    @Override
    public StringBuffer format(Object obj_p, StringBuffer toAppendTo_p, FieldPosition pos_p) {
        return this.decimalFormat.format(obj_p, toAppendTo_p, pos_p);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj_p) {
        return this.decimalFormat.formatToCharacterIterator(obj_p);
    }

    public int hashCode() {
        return this.decimalFormat.hashCode();
    }

    @Override
    public Object parseObject(String source_p, ParsePosition pos_p) {
        BigDecimal decimalObject = (BigDecimal)this.decimalFormat.parseObject(source_p, pos_p);
        return new BigInteger(decimalObject.toString());
    }

    @Override
    public Object parseObject(String source_p) throws ParseException {
        BigDecimal decimalObject = (BigDecimal)this.decimalFormat.parseObject(source_p);
        return new BigInteger(decimalObject.toString());
    }

    public String toString() {
        return this.decimalFormat.toString();
    }
}

