/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.object;

import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISAbstractTransientObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISContextBoundObject;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.log4j.Logger;

public class OwCMISBulkTransientObject<N extends TransientCmisObject>
extends OwCMISAbstractTransientObject<N> {
    private static final Logger LOG = OwLog.getLogger(OwCMISBulkTransientObject.class);

    public OwCMISBulkTransientObject(N transientCmisObject, OperationContext creationContext, Session session) {
        super(transientCmisObject, creationContext, session);
    }

    @Override
    protected OwCMISContextBoundObject<N> retrieveProperties(Set<String> nativePropertyFilter) {
        LOG.info((Object)"Fetching bulk-object-properties from content repository!");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("OwCMISCachedObject.fetchProperties: Fetched bulk-object-properties = %s", nativePropertyFilter.toString()));
        }
        return this.fetchObject(nativePropertyFilter);
    }

    protected OwCMISContextBoundObject<N> fetchObject(Set<String> nativePropertyFilter) {
        String nativeId = this.contextBoundObject.object.getId();
        OperationContext newContext = this.addFilter(this.contextBoundObject.context, nativePropertyFilter);
        CmisObject newObject = this.session.getObject(nativeId, newContext);
        TransientCmisObject newTransientObject = newObject.getTransientObject();
        return new OwCMISContextBoundObject<TransientCmisObject>(newTransientObject, newContext);
    }
}

