/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.permission;

import com.wewebu.ow.server.ecm.OwPolicy;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwReason;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.OwStandardReason;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.exception.OwCMISRuntimeException;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISAclDiff;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISAclDiffImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPrivilege;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPrivilegeSet;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwRuntimeException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISPermissionCollectionImpl
implements OwCMISPermissionCollection {
    private static final Logger LOG;
    private Acl acl;
    private boolean setPrivileges;
    private OwCMISAclDiffImpl diff;
    private CmisObject nativeObject;
    private Session session;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        OwCMISPermissionCollectionImpl.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISPermissionCollectionImpl.class);
    }

    public OwCMISPermissionCollectionImpl(CmisObject natObj, Session session) {
        this.setPrivileges = natObj.getAllowableActions().getAllowableActions().contains(Action.CAN_APPLY_ACL);
        this.nativeObject = natObj;
        this.session = session;
        if (this.getNativeObject().getAcl() == null) {
            this.reset(session.getAcl((ObjectId)this.getNativeObject(), false));
        } else {
            this.reset(this.getNativeObject().getAcl());
        }
    }

    public OwCMISPermissionCollectionImpl(Acl acl, Session session) {
        this.setPrivileges = true;
        this.session = session;
        this.acl = acl;
    }

    public boolean canGetPrivileges() {
        return true;
    }

    public boolean canSetPrivileges() {
        return this.setPrivileges;
    }

    public boolean canDenyPrivileges() {
        return false;
    }

    public Collection getAvailablePrivileges(OwUserInfo principal_p) {
        LinkedList<OwCMISPrivilege> privileges = new LinkedList<OwCMISPrivilege>();
        LinkedList filter = new LinkedList();
        if (principal_p != null) {
            String principalId = this.extractId(principal_p);
            for (Ace ace : this.getAcl().getAces()) {
                if (!ace.getPrincipalId().equals(principalId)) continue;
                filter.addAll(ace.getPermissions());
            }
        }
        for (PermissionDefinition def : this.session.getRepositoryInfo().getAclCapabilities().getPermissions()) {
            if (filter.contains(def.getId())) continue;
            privileges.add(new OwCMISPrivilege(null, def.getId()));
        }
        return privileges;
    }

    public Map getAvailableInheritanceDepths() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public OwPrivilegeSet addPrivilegeSet(OwUserInfo owUserInfo, Collection collection, boolean bl, int n) throws OwException {
        OwUserInfo owUserInfo2 = owUserInfo;
        Collection collection2 = collection;
        boolean bl2 = bl;
        int n2 = n;
        try {
            OwCMISPrivilegeSet owCMISPrivilegeSet;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void principal_p;
                void privileges_p;
                LinkedList<String> permissions = new LinkedList<String>();
                Iterator it = privileges_p.iterator();
                while (it.hasNext()) {
                    permissions.add(((OwPrivilege)it.next()).getName());
                }
                Ace added = this.getSession().getObjectFactory().createAce(this.extractId((OwUserInfo)principal_p), permissions);
                this.getDiff().add(added);
                owCMISPrivilegeSet = new OwCMISPrivilegeSet((OwUserInfo)principal_p, added);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISPrivilegeSet;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{owUserInfo2, collection2, Conversions.booleanObject((boolean)bl2), Conversions.intObject((int)n2)};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    public Collection getAppliedPrivilegeSets() {
        Acl defLst = this.getAcl();
        LinkedList<OwCMISPrivilegeSet> sets = new LinkedList<OwCMISPrivilegeSet>();
        LinkedList<Ace> base = new LinkedList<Ace>(defLst.getAces());
        if (this.diff != null) {
            if (this.diff.getDeleted() != null) {
                Iterator it = base.iterator();
                while (it.hasNext()) {
                    Ace in = (Ace)it.next();
                    if (!in.isDirect()) continue;
                    for (Ace del : this.diff.getDeleted()) {
                        if (!in.getPrincipalId().equals(del.getPrincipalId())) continue;
                        List inLst = in.getPermissions();
                        List delLst = del.getPermissions();
                        if (inLst.size() != delLst.size()) continue;
                        Collections.sort(inLst);
                        Collections.sort(delLst);
                        if (!inLst.equals(delLst)) continue;
                        it.remove();
                    }
                }
            }
            if (this.diff.getAdded() != null) {
                base.addAll(this.diff.getAdded());
            }
        }
        for (Ace ace : base) {
            OwCMISUserInfo usr = new OwCMISUserInfo(ace.getPrincipalId(), null);
            OwCMISPrivilegeSet set = new OwCMISPrivilegeSet(usr, ace);
            sets.add(set);
        }
        return sets;
    }

    /*
     * WARNING - void declaration
     */
    public void removePrivilegeSet(OwPrivilegeSet owPrivilegeSet) throws OwException {
        OwPrivilegeSet owPrivilegeSet2 = owPrivilegeSet;
        try {
            block8: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    void privilegeSet_p;
                    if (privilegeSet_p instanceof OwCMISPrivilegeSet) {
                        Ace delete = ((OwCMISPrivilegeSet)privilegeSet_p).nativeObject();
                        this.getDiff().remove(delete);
                        break block8;
                    }
                    if (privilegeSet_p == null) {
                        throw new OwInvalidOperationException("The to be deleted PrivilegeSet cannot be null");
                    }
                    throw new OwInvalidOperationException("The provided PrivilegeSet is not supported, type = " + privilegeSet_p);
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)owPrivilegeSet2));
            }
            throw cmisBaseException;
        }
    }

    public boolean canGetPolicies() {
        return false;
    }

    public boolean canSetPolicies() {
        return false;
    }

    public boolean canAddMultiPolicy() {
        return false;
    }

    public Collection getAvailablePolicies(OwUserInfo principal_p) {
        return null;
    }

    public void addPolicy(OwPolicy owPolicy) throws OwException {
        OwPolicy owPolicy2 = owPolicy;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)owPolicy2));
            }
            throw cmisBaseException;
        }
    }

    public Collection getAppliedPolicies() {
        return null;
    }

    public void removePolicy(OwPolicy owPolicy) throws OwException {
        OwPolicy owPolicy2 = owPolicy;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)owPolicy2));
            }
            throw cmisBaseException;
        }
    }

    public OwReason canEditPermissions() {
        return OwStandardReason.ALLOWED;
    }

    @Override
    public CmisObject getNativeObject() {
        return this.nativeObject;
    }

    @Override
    public OwCMISAclDiff getDiff() {
        if (this.diff == null) {
            this.diff = new OwCMISAclDiffImpl();
        }
        return this.diff;
    }

    @Override
    public void reset(Acl newAcl_p) {
        this.acl = newAcl_p;
        if (this.diff != null) {
            if (this.diff.getAdded() != null) {
                this.diff.getAdded().clear();
            }
            if (this.diff.getDeleted() != null) {
                this.diff.getDeleted().clear();
            }
        }
        this.diff = null;
    }

    public Acl getAcl() {
        return this.acl;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    protected String extractId(OwUserInfo usr) throws OwRuntimeException {
        try {
            return usr.getUserName();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot extract Id for current user info object", (Throwable)e);
            throw new OwCMISRuntimeException("Unable to extract Id from UserInfo", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISPermissionCollectionImpl.java", OwCMISPermissionCollectionImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPrivilegeSet", "com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollectionImpl", "com.wewebu.ow.server.ecm.OwUserInfo:java.util.Collection:boolean:int", "principal_p:privileges_p:deny_p:inheritancedepth_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwPrivilegeSet"), 134);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removePrivilegeSet", "com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollectionImpl", "com.wewebu.ow.server.ecm.OwPrivilegeSet", "privilegeSet_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 204);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPolicy", "com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollectionImpl", "com.wewebu.ow.server.ecm.OwPolicy", "policy_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 249);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removePolicy", "com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollectionImpl", "com.wewebu.ow.server.ecm.OwPolicy", "policy_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 261);
    }
}

