/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.search;

import com.wewebu.ow.csqlc.OwCSQLCException;
import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwFolderPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwFunctionFolderFormat;
import com.wewebu.ow.csqlc.ast.OwPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwSQLDateTimeLiteral;
import com.wewebu.ow.csqlc.ast.OwTextSearchPredicate;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISSQLDateTimeLiteral;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISCSQLCProcessor
extends OwCSQLCProcessor {
    private static final Logger LOG;
    private static final OwFolderPredicateFormat FOLDER_FORMAT;
    private static final OwPredicateFormat IN_FORMAT;
    private static final OwPredicateFormat QUANTIIFED_IN_FORMAT;
    private static final OwPredicateFormat QUANTIIFED_COPMARISON_FORMAT;
    private static final OwPredicateFormat LIKE_FORMAT;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OwCMISCSQLCProcessor.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISCSQLCProcessor.class);
        FOLDER_FORMAT = new OwFunctionFolderFormat("IN_FOLDER", "IN_TREE");
        IN_FORMAT = new OwPredicateFormat(null, null, "IN", "NOT IN", null, null);
        QUANTIIFED_IN_FORMAT = new OwPredicateFormat("ANY", "ANY", "IN", "NOT IN", null, null);
        QUANTIIFED_COPMARISON_FORMAT = new OwPredicateFormat(null, "NOT", "= ANY", "= ANY", null, null);
        LIKE_FORMAT = new OwPredicateFormat(null, null, "LIKE", "NOT LIKE", null, null);
    }

    public OwCMISCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        super(entitiesResolver_p);
    }

    protected OwColumnQualifier createFromTableQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    /*
     * WARNING - void declaration
     */
    protected OwColumnQualifier createColumnQualifier(String string, String string2) throws OwException {
        String string3 = string;
        String string4 = string2;
        try {
            OwColumnQualifier owColumnQualifier;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void repositoryID_p;
                void propertyName_p;
                int dotIndex = propertyName_p.indexOf(46);
                Object tableNamePart = null;
                tableNamePart = dotIndex != -1 ? propertyName_p.substring(0, dotIndex) : propertyName_p;
                String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, (String)repositoryID_p);
                owColumnQualifier = tableName != null ? new OwColumnQualifier(tableName, tableNamePart) : null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owColumnQualifier;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string3, (Object)string4));
            }
            throw cmisBaseException;
        }
    }

    protected OwColumnQualifier createQueryColumnQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    /*
     * WARNING - void declaration
     */
    protected OwColumnQualifier createQueryFieldQualifier(OwFieldDefinition owFieldDefinition, OwCSQLCProcessor.OwProcessContext owProcessContext) throws OwException {
        OwFieldDefinition owFieldDefinition2 = owFieldDefinition;
        OwCSQLCProcessor.OwProcessContext owProcessContext2 = owProcessContext;
        try {
            OwColumnQualifier owColumnQualifier;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void context_p;
                void fieldDefinition_p;
                String fieldClassName = fieldDefinition_p.getClassName();
                int dotIndex = fieldClassName.indexOf(46);
                String tableNamePart = null;
                tableNamePart = dotIndex != -1 ? fieldClassName.substring(0, dotIndex) : fieldClassName;
                String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, context_p.repositoryID);
                if (tableName == null) {
                    String message = "The filed definition " + fieldClassName + " is not qualifiable! ";
                    LOG.error((Object)("OwCMISSearchNodeSQLProcessor.createQueryFieldQualifier():" + message));
                    throw new OwInvalidOperationException((OwString)new OwString1("opencmis.search.OwCMISCSQLCProcessor.err.non.queryable.field", "Invalid search field. The field %1 can not be queried.", fieldClassName));
                }
                owColumnQualifier = new OwColumnQualifier(tableName, tableNamePart);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owColumnQualifier;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)owFieldDefinition2, (Object)owProcessContext2));
            }
            throw cmisBaseException;
        }
    }

    protected OwSQLDateTimeLiteral createLiteral(OwSearchCriteria criteria_p, Date date_p) throws OwCSQLCException {
        return new OwCMISSQLDateTimeLiteral(this.convertDate(date_p));
    }

    protected XMLGregorianCalendar convertDate(Date definedDate_p) throws OwCSQLCException {
        TimeZone from = this.m_entitiesResolver.getNetworkContext().getClientTimeZone();
        TimeZone to = TimeZone.getTimeZone("UTC");
        try {
            return OwDateTimeUtil.convertToXMLGregorianCalendar((Date)definedDate_p, (TimeZone)from, (TimeZone)to);
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn((Object)"Could not convert into XMLGregorianCalendar", (Throwable)e);
            throw new OwCSQLCException("XMLGregorianCalendar error.", (Throwable)e);
        }
    }

    protected String createJoinColumnName(OwColumnQualifier qualifier_p) {
        return "cmis:objectId";
    }

    protected OwPredicateFormat getInFormat() {
        return IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedInFormat() {
        return QUANTIIFED_IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedComparisonFormat() {
        return QUANTIIFED_COPMARISON_FORMAT;
    }

    protected OwFolderPredicateFormat getFolderPredicateFormat() {
        return FOLDER_FORMAT;
    }

    /*
     * WARNING - void declaration
     */
    protected OwTextSearchPredicate createTextSearchPredicate(OwCharacterStringLiteral owCharacterStringLiteral, OwColumnReference owColumnReference) throws OwException {
        OwCharacterStringLiteral owCharacterStringLiteral2 = owCharacterStringLiteral;
        OwColumnReference owColumnReference2 = owColumnReference;
        try {
            OwTextSearchPredicate owTextSearchPredicate;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void searchExpression_p;
                void columnReference_p;
                if (columnReference_p != null) {
                    throw new OwInvalidOperationException("Property based text search predicates are not supported.");
                }
                owTextSearchPredicate = new OwTextSearchPredicate((OwCharacterStringLiteral)searchExpression_p, null, new OwColumnQualifier(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owTextSearchPredicate;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)owCharacterStringLiteral2, (Object)owColumnReference2));
            }
            throw cmisBaseException;
        }
    }

    protected String joinType(OwCorrelatedTableName joinedTable_p) {
        return "";
    }

    protected OwPredicateFormat createLikeFormat() {
        return LIKE_FORMAT;
    }

    protected String escapeNativeWildCardRepresentation(String value_p, Collection<OwWildCardDefinition> wildCardDefs) {
        for (OwWildCardDefinition def : wildCardDefs) {
            value_p = OwString.replaceAll((String)value_p, (String)def.getNativeWildCard(), (String)("\\" + def.getNativeWildCard()));
        }
        return value_p;
    }

    protected boolean isMultipleTextSearchSyntax() {
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCSQLCProcessor.java", OwCMISCSQLCProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createColumnQualifier", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "java.lang.String:java.lang.String", "propertyName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwColumnQualifier"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createQueryFieldQualifier", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "com.wewebu.ow.server.field.OwFieldDefinition:com.wewebu.ow.csqlc.OwCSQLCProcessor$OwProcessContext", "fieldDefinition_p:context_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwColumnQualifier"), 99);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createTextSearchPredicate", "com.wewebu.ow.server.ecmimpl.opencmis.search.OwCMISCSQLCProcessor", "com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral:com.wewebu.ow.csqlc.ast.OwColumnReference", "searchExpression_p:columnReference_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.csqlc.ast.OwTextSearchPredicate"), 189);
    }
}

