/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.ui;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwGroup;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUser;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUserRole;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISUserSelectionModule
extends OwUIUserSelectModul {
    protected static final String SEARCH_FIELD_ID = "OwCMISUserSelect";
    protected static final String SEARCH_USER_LST = "OwCMISUserList";
    private static final Logger LOG;
    private String enteredPattern;
    private String currentUserID;
    private int[] filter;
    private List<OwCMISInfoItem> infoList;
    private OwUsersRepository usersRepository;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        OwCMISUserSelectionModule.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISUserSelectionModule.class);
    }

    public OwCMISUserSelectionModule(OwUsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public String getCurrentUserID() {
        return this.currentUserID;
    }

    protected void init() throws Exception {
        super.init();
        this.infoList = new LinkedList<OwCMISInfoItem>();
    }

    public void setCurrentUserID(String currentUserID_p) {
        this.currentUserID = currentUserID_p;
    }

    public int[] getFilter() {
        return this.filter;
    }

    public void setFilter(int[] filter_p) {
        this.filter = filter_p;
    }

    public void onRender(Writer w_p) throws Exception {
        w_p.write("<div id=\"OwMainContent\" class=\"OwUIUserSelectModul OwCMISUserSelectionModule\">\n");
        this.renderSearchCriteriaBox(w_p);
        this.renderResultList(w_p);
        this.renderUserSelectButton(w_p);
        w_p.write("</div>");
    }

    protected void renderUserSelectButton(Writer w_p) throws IOException {
        w_p.write("<div class=\"block\"><input type=\"button\" onclick=\"");
        w_p.write(this.getFormEventURL("SelectUser", null));
        w_p.write("\" onkeydown=\"event.cancelBubble=true\" value=\"");
        w_p.write(this.getContext().localize("opencmis.ui.OwCMISUserSelectionModule.select", "Select"));
        w_p.write("\" name=\"selectUser\"/></div>\n");
    }

    protected void renderSearchCriteriaBox(Writer w_p) throws Exception {
        w_p.write("<div class=\"block\">\n");
        w_p.write("     <input type=\"text\" value=\"");
        if (this.getEnteredPattern() != null) {
            OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)this.getEnteredPattern());
        }
        w_p.write("\" name=\"");
        w_p.write(SEARCH_FIELD_ID);
        w_p.write("\"/>&nbsp;&nbsp;");
        String sSearchEventURL = this.getFormEventURL("Search", null);
        w_p.write("<input type=\"button\" name=\"Search\" onClick=\"");
        w_p.write(sSearchEventURL);
        w_p.write("\" value=\"");
        String searchLabel = this.getContext().localize("opencmis.ui.OwCMISUserSelectionModule.search", "Search");
        w_p.write(searchLabel);
        w_p.write("\" /></div>\n");
        this.getContext().setFocusControlID(SEARCH_FIELD_ID);
        this.getContext().registerKeyEvent(13, 0, sSearchEventURL, searchLabel);
    }

    /*
     * WARNING - void declaration
     */
    protected void renderResultList(Writer writer) throws OwException {
        Writer writer2 = writer;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String selectUserEvent = this.getFormEventURL("SelectUser", null);
                try {
                    void w_p;
                    w_p.write("<div class=\"block\" ondblclick=\"");
                    w_p.write(selectUserEvent);
                    w_p.write("\">");
                    w_p.write("<select class=\"OwInputfield_minWidth\" size=\"10\" ");
                    w_p.write("onkeydown=\"onKey(event,13,true,function(event){");
                    w_p.write(selectUserEvent);
                    w_p.write("});\" name=\"");
                    w_p.write(SEARCH_USER_LST);
                    w_p.write("\"");
                    if (this.getMultiselect()) {
                        w_p.write(" multiple>");
                    }
                    w_p.write(">");
                    List<OwCMISInfoItem> lst = this.getInfoList();
                    if (lst != null) {
                        int i = 0;
                        while (i < lst.size()) {
                            OwCMISInfoItem item = lst.get(i);
                            w_p.write("<option value=\"");
                            w_p.write(Integer.toString(i));
                            w_p.write("\">");
                            w_p.write(item.getUserDisplayName());
                            w_p.write("</option>");
                            ++i;
                        }
                    }
                    w_p.write("</select>");
                    w_p.write("</div>");
                }
                catch (IOException e) {
                    LOG.fatal((Object)"Cannot write to outputstream.", (Throwable)e);
                    throw new OwServerException(this.getContext().localize("opencmis.ui.OwCMISUserSelectionModule.err.io", "Cannot write to outputstream."), (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot get displayname for rendering.", (Throwable)e);
                    throw new OwServerException(this.getContext().localize("opencmis.ui.OwCMISUserSelectionModule.err.render", "Cannot get displayname for rendering."), (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)writer2));
            }
            throw cmisBaseException;
        }
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected List<OwCMISInfoItem> getInfoList() {
        return this.infoList;
    }

    /*
     * WARNING - void declaration
     */
    public void onSearch(HttpServletRequest httpServletRequest) throws OwException {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                int[] filter;
                void request_p;
                this.getInfoList().clear();
                String searchPattern = request_p.getParameter(SEARCH_FIELD_ID);
                this.setEnteredPattern(searchPattern);
                if (searchPattern != null && (filter = this.getFilter()) != null && filter.length > 0) {
                    int i = 0;
                    while (i < filter.length) {
                        switch (filter[i]) {
                            case 1: {
                                this.getInfoList().addAll(this.getTypeUser(searchPattern));
                                break;
                            }
                            case 3: {
                                this.getInfoList().addAll(this.getTypeRole(searchPattern));
                                break;
                            }
                            case 2: {
                                this.getInfoList().addAll(this.getTypeGroup(searchPattern));
                                break;
                            }
                            default: {
                                this.getInfoList().addAll(this.getExtendedType(filter[i], searchPattern));
                            }
                        }
                        ++i;
                    }
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest2));
            }
            throw cmisBaseException;
        }
    }

    public void onSelectUser(HttpServletRequest request_p) throws Exception {
        String selection = request_p.getParameter(SEARCH_USER_LST);
        if (selection == null || selection.length() == 0) {
            return;
        }
        OwCMISInfoItem info = this.getInfoList().get(Integer.parseInt(selection));
        if (3 == info.getType() || 1 == info.getType()) {
            LinkedList<String> roles = new LinkedList<String>();
            roles.add(info.getUserName());
            this.getEventListner().onSelectRoles(roles);
        } else {
            LinkedList<OwUserInfo> users = new LinkedList<OwUserInfo>();
            OwUserInfo selectedUser = this.getNetwork().getUserFromID(info.getUserName());
            users.add(selectedUser);
            this.getEventListner().onSelectUsers(users);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<OwCMISInfoItem> getTypeUser(String string) throws OwException {
        String string2 = string;
        try {
            LinkedList<OwCMISInfoItem> linkedList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void pattern;
                OwObjectCollection users = this.usersRepository.findUsersMatching((String)pattern);
                LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
                for (Object record : users) {
                    OwUser user = (OwUser)record;
                    lst.add(new OwCMISInfoItem(user.getId(), user.getName(), 2));
                }
                try {
                    if (!users.isComplete()) {
                        OwMainAppContext ctx = (OwMainAppContext)this.getContext();
                        String msg = ctx.localize1("owsearch.OwResultListView.notcomplete", "The result list does not contain all results. Only the first %1 are displayed.", String.valueOf(users.size()));
                        ctx.postMessage(msg);
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new OwServerException("Fata; error!", (Throwable)e);
                }
                linkedList = lst;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<OwCMISInfoItem> getTypeGroup(String string) throws OwException {
        String string2 = string;
        try {
            LinkedList<OwCMISInfoItem> linkedList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void pattern;
                Set<OwGroup> groups = this.usersRepository.findGroupsMatching((String)pattern);
                LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
                for (OwGroup group : groups) {
                    lst.add(new OwCMISInfoItem(group.getId(), group.getName(), 3));
                }
                linkedList = lst;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<OwCMISInfoItem> getTypeRole(String string) throws OwException {
        String string2 = string;
        try {
            LinkedList<OwCMISInfoItem> linkedList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                void pattern;
                Set<OwUserRole> roles = this.usersRepository.findRolesMatching((String)pattern);
                LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
                String last = pattern.replaceAll("[:*:]", ".+");
                String[] stringArray = this.getDefaultRoleNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    if (val.matches(last)) {
                        lst.add(this.createRoleInfo(val));
                    }
                    ++n2;
                }
                for (OwUserRole role : roles) {
                    OwCMISInfoItem group = new OwCMISInfoItem(role.getId(), role.getName(), 3);
                    if (lst.contains(group)) continue;
                    lst.add(group);
                }
                linkedList = lst;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public boolean isRoleSelection() {
        int[] filter = this.getFilter();
        int i = 0;
        while (i < filter.length) {
            if (filter[i] == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getEnteredPattern() {
        return this.enteredPattern;
    }

    protected void setEnteredPattern(String pattern) {
        this.enteredPattern = pattern;
    }

    public List<OwCMISInfoItem> getExtendedType(int extendedType_p, String pattern_p) {
        return new LinkedList<OwCMISInfoItem>();
    }

    protected OwCMISNetwork getCurrentNetwork() {
        return (OwCMISNetwork)this.getNetwork();
    }

    protected OwCMISInfoItem createUserInfo(String name_p) {
        return new OwCMISInfoItem(name_p, 2);
    }

    protected OwCMISInfoItem createRoleInfo(String name_p) {
        return new OwCMISInfoItem(name_p, 1);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISUserSelectionModule.java", OwCMISUserSelectionModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "renderResultList", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule", "java.io.Writer", "w_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 165);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onSearch", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule", "javax.servlet.http.HttpServletRequest", "request_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 240);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeUser", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule", "java.lang.String", "pattern", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 315);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeGroup", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule", "java.lang.String", "pattern", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 354);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeRole", "com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule", "java.lang.String", "pattern", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 375);
    }

    protected static class OwCMISInfoItem {
        public static final int ROLE = 1;
        public static final int USER = 2;
        public static final int GROUP = 3;
        private int type;
        private String name;
        private String displayName;

        public OwCMISInfoItem(String name_p, int type) {
            this(name_p, name_p, type);
        }

        public OwCMISInfoItem(String name_p, String displayName, int type) {
            this.name = name_p;
            this.type = type;
            this.displayName = displayName;
        }

        public String getUserDisplayName() throws Exception {
            return this.displayName;
        }

        public String getUserName() throws Exception {
            return this.name;
        }

        public boolean isGroup() throws Exception {
            return this.type == 3;
        }

        public int getType() {
            return this.type;
        }

        public int hashCode() {
            return 31 * (31 + (this.name == null ? 0 : this.name.hashCode())) + this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OwCMISInfoItem other = (OwCMISInfoItem)obj;
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }
    }
}

