/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.ui.acl;

import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollection;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OwCMISPrivilegeEditorDocument
extends OwDocument {
    private OwCMISPermissionCollection permissions;
    private List<OwPrivilegeSet> modifySets;
    private String selectedPrincipal;
    private List<String> principalSelection;
    private List<OwPrivilege> renderList;
    private List<OwPrivilege> selectedList;

    public OwCMISPrivilegeEditorDocument(OwCMISPermissionCollection permCol, List<OwPrivilegeSet> modifySets) throws Exception {
        this.permissions = permCol;
        this.modifySets = modifySets;
        this.principalSelection = new LinkedList<String>();
        if (modifySets != null) {
            for (OwPrivilegeSet set : modifySets) {
                this.principalSelection.add(set.getPrincipal().getUserName());
                if (this.selectedPrincipal != null) continue;
                this.selectedPrincipal = set.getPrincipal().getUserName();
            }
        }
    }

    public OwCMISPermissionCollection getPermissions() {
        return this.permissions;
    }

    public List<OwPrivilegeSet> getModifySets() {
        return this.modifySets;
    }

    public String getSelectedPrincipal() {
        return this.selectedPrincipal;
    }

    public void setSelectedPrincipal(String principalId) {
        if (this.modifySets == null && this.selectedPrincipal != null) {
            this.getPrincipalSelection().add(this.selectedPrincipal);
        }
        if (principalId != null && !this.getPrincipalSelection().contains(principalId)) {
            this.getPrincipalSelection().add(principalId);
        }
        this.selectedPrincipal = principalId;
    }

    public List<String> getPrincipalSelection() {
        return this.principalSelection;
    }

    public void setPrincipalSelection(List<String> previousSelected) {
        if (previousSelected != null) {
            this.principalSelection = previousSelected;
        }
    }

    public List<OwPrivilege> getRenderList() {
        if (this.renderList == null) {
            return Collections.emptyList();
        }
        return this.renderList;
    }

    public List<OwPrivilege> getSelectedList() {
        if (this.selectedList == null) {
            return Collections.emptyList();
        }
        return this.selectedList;
    }

    public void setRenderList(List<OwPrivilege> renderLst) {
        this.renderList = renderLst;
    }

    public void setSelectedList(List<OwPrivilege> selected) {
        this.selectedList = selected;
    }
}

