/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco;

import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.GetPersonResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListGroupsResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.ListPeopleResource;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.OwRestException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.resource.ClientResource;

public class AlfrescoRESTFulFactory {
    private String baseURL;
    private String userName;
    private String password;

    public AlfrescoRESTFulFactory(String baseURL, String userName, String password) {
        this.baseURL = baseURL;
        this.userName = userName;
        this.password = password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ListGroupsResource listGroupsResource(String shortNameFilter) throws OwRestException {
        String resourceURI = String.format("%s/service/api/groups?shortNameFilter=%s", this.baseURL, this.encodeValue(shortNameFilter));
        return this.createResourceFor(resourceURI, ListGroupsResource.class);
    }

    public ListPeopleResource getPeopleResource(String filterQuery) throws OwRestException {
        String resourceURI = String.format("%s/service/api/people?filter=%s", this.baseURL, this.encodeValue(filterQuery));
        return this.createResourceFor(resourceURI, ListPeopleResource.class);
    }

    public GetPersonResource getPersonResource(String userName) throws OwRestException {
        String resourceURI = String.format("%s/service/api/people/%s?groups=true", this.baseURL, this.encodeValue(userName));
        return this.createResourceFor(resourceURI, GetPersonResource.class);
    }

    private String encodeValue(String aStringValue) throws OwRestException {
        String encodeValue = null;
        try {
            encodeValue = URLEncoder.encode(aStringValue, "UTF-8");
        }
        catch (UnsupportedEncodingException encEx) {
            throw new OwRestException("Could not encode the filter!", encEx);
        }
        return encodeValue;
    }

    private <T> T createResourceFor(String resourceURI, Class<T> wrappedClass) throws OwRestException {
        ClientResource cr = new ClientResource(resourceURI);
        cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.userName, this.password);
        cr.getConverterService().setEnabled(true);
        Object resource = cr.wrap(wrappedClass);
        final Uniform originalNext = cr.getNext();
        cr.setNext(new Uniform(){

            public void handle(Request request, Response response) {
                if (originalNext != null) {
                    originalNext.handle(request, response);
                }
            }
        });
        return (T)resource;
    }
}

