/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.users.info;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwGroup;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.ecmimpl.opencmis.users.alfresco.dao.Person;
import com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoGroupInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.mandator.OwMandator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISAlfrescoUserInfo
extends OwCMISUserInfo {
    private String id;
    private String firstName;
    private String lastName;
    private String email;
    private Collection<OwUserInfo> groups;
    private OwUsersRepository userRepository;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public OwCMISAlfrescoUserInfo(Person person, OwMandator mandator, OwUsersRepository userrRepository) {
        super(person.getUserName(), mandator);
        this.userRepository = userrRepository;
        this.id = person.getUserName();
        this.firstName = person.getFirstName();
        this.lastName = person.getLastName();
        this.email = person.getEmail();
        LinkedList<OwUserInfo> groups = new LinkedList<OwUserInfo>();
        Person.Group[] personGroups = person.getGroups();
        if (personGroups != null) {
            Person.Group[] groupArray = personGroups;
            int n = personGroups.length;
            int n2 = 0;
            while (n2 < n) {
                Person.Group group = groupArray[n2];
                groups.add(new OwCMISAlfrescoGroupInfo(group.getItemName()));
                ++n2;
            }
        }
        this.groups = groups;
    }

    @Override
    public Collection<OwUserInfo> getGroups() throws OwException {
        try {
            ArrayList<OwUserInfo> arrayList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.groups == null) {
                    this.groups = new HashSet<OwUserInfo>();
                    Set<OwGroup> userGroups = this.userRepository.findGroupsForUserID(this.getUserID());
                    for (OwGroup owGroup : userGroups) {
                        this.groups.add(new OwCMISAlfrescoGroupInfo(owGroup.getId()));
                    }
                }
                ArrayList<OwUserInfo> result = new ArrayList<OwUserInfo>();
                result.addAll(this.groups);
                result.addAll(this.getDefaulfGroups());
                arrayList = result;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return arrayList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public Collection<String> getRoleNames() throws OwException {
        try {
            LinkedHashSet<String> linkedHashSet;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    LinkedHashSet<String> names = new LinkedHashSet<String>();
                    HashSet<String> shortGroupNames = new HashSet<String>();
                    for (OwUserInfo group : this.getGroups()) {
                        OwCMISAlfrescoGroupInfo groupInfo = (OwCMISAlfrescoGroupInfo)group;
                        shortGroupNames.add(groupInfo.getUserShortName());
                    }
                    List<String> superRoles = this.getDefaultRoleNames();
                    if (this.getMandator() == null) {
                        names.addAll(superRoles);
                        names.addAll(shortGroupNames);
                    } else {
                        for (String superRole : superRoles) {
                            names.add(this.getMandator().filterRoleName(superRole));
                        }
                        for (String groupName : shortGroupNames) {
                            names.add(this.getMandator().filterRoleName(groupName));
                        }
                    }
                    names.addAll(superRoles);
                    linkedHashSet = names;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new OwServerException("Could not process roles for this user.", (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedHashSet;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public String getUserDisplayName() throws Exception {
        return String.valueOf(this.firstName) + " " + this.lastName;
    }

    @Override
    public String getUserID() {
        return this.id;
    }

    @Override
    public String getUserLongName() throws OwException {
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                string = String.valueOf(this.firstName) + " " + this.lastName;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public String getUserShortName() throws Exception {
        return this.lastName;
    }

    @Override
    public String getUserEmailAdress() throws OwException {
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                string = this.email;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    static {
        OwCMISAlfrescoUserInfo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAlfrescoUserInfo.java", OwCMISAlfrescoUserInfo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroups", "com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleNames", "com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserLongName", "com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 158);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserEmailAdress", "com.wewebu.ow.server.ecmimpl.opencmis.users.info.OwCMISAlfrescoUserInfo", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 176);
    }
}

