/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.util;

import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

public class OwCMISDateTime {
    private static Logger LOG = OwLog.getLogger(OwCMISDateTime.class);
    private GregorianCalendar m_calendar;

    public OwCMISDateTime(String dateLexicalRepresentation_p) throws OwInvalidOperationException {
        try {
            char middleZoneMark;
            char zoneMark;
            String representation = dateLexicalRepresentation_p;
            if (representation != null && representation.length() > 5 && ((zoneMark = representation.charAt(representation.length() - 5)) == '+' || zoneMark == '-') && (middleZoneMark = representation.charAt(representation.length() - 3)) != ':') {
                representation = new StringBuffer(representation).insert(representation.length() - 2, ":").toString();
            }
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregoriaCalendar = factory.newXMLGregorianCalendar(representation);
            this.m_calendar = xmlGregoriaCalendar.toGregorianCalendar();
        }
        catch (Exception e) {
            String msg = "Could not parse date lexical representation :" + dateLexicalRepresentation_p;
            LOG.error((Object)("OwCMISDateTime.OwCMISDateTime():" + msg));
            throw new OwInvalidOperationException((OwString)new OwString1("opencmis.util.OwCMISDateTime.err.parse.date", "Invalid date/time format: %1", dateLexicalRepresentation_p), (Throwable)e);
        }
    }

    public OwCMISDateTime(GregorianCalendar calendar_p) {
        this.m_calendar = (GregorianCalendar)calendar_p.clone();
    }

    public OwCMISDateTime(Date date_p, TimeZone timeZone_p) throws OwInvalidOperationException {
        Calendar local = Calendar.getInstance();
        local.setTime(date_p);
        this.m_calendar = new GregorianCalendar(timeZone_p);
        int year = local.get(1);
        int month = local.get(2);
        int day = local.get(5);
        int hour = local.get(11);
        int minute = local.get(12);
        int second = local.get(13);
        int millisecond = local.get(14);
        this.m_calendar.set(1, year);
        this.m_calendar.set(2, month);
        this.m_calendar.set(5, day);
        this.m_calendar.set(11, hour);
        this.m_calendar.set(12, minute);
        this.m_calendar.set(13, second);
        this.m_calendar.set(14, millisecond);
    }

    public String toCMISDateTimeString() {
        return this.toCMISDateTimeString(false);
    }

    public String toISODateTimeString() {
        return this.toISODateTimeString(false);
    }

    public String toISODateTimeString(boolean omitTimeZone_p) {
        String isoString = this.toCMISDateTimeString(omitTimeZone_p);
        if (!omitTimeZone_p) {
            int mark = isoString.length() - 3;
            isoString = new StringBuffer(isoString).replace(mark, mark + 1, "").toString();
        }
        return isoString;
    }

    public String toCMISDateTimeString(boolean omitTimeZone_p) {
        XMLGregorianCalendar calendar = this.getXMLGregorianCalendar(omitTimeZone_p);
        return calendar.toXMLFormat();
    }

    public Date getDate(boolean ignoreTimeZone_p) {
        GregorianCalendar calendar = this.getCalendar();
        ((Calendar)calendar).setTimeZone(TimeZone.getDefault());
        if (!ignoreTimeZone_p) {
            ((Calendar)calendar).setTimeZone(this.getTimeZone());
        }
        return calendar.getTime();
    }

    public GregorianCalendar getCalendar() {
        return (GregorianCalendar)this.m_calendar.clone();
    }

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            return factory.newXMLGregorianCalendar(this.m_calendar);
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)"OwCMISDateTime.getXMLGregorianCalendar : ", (Throwable)e);
            return null;
        }
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(boolean ignoreTimeZone_p) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar calendarCopy = factory.newXMLGregorianCalendar(this.m_calendar);
            if (ignoreTimeZone_p) {
                calendarCopy.setTimezone(Integer.MIN_VALUE);
            }
            return calendarCopy;
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)"OwCMISDateTime.getXMLGregorianCalendar : ", (Throwable)e);
            return null;
        }
    }

    public TimeZone getTimeZone() {
        return this.m_calendar.getTimeZone();
    }

    public String toString() {
        return this.m_calendar == null ? "<null calendar>" : this.toCMISDateTimeString();
    }

    public int hashCode() {
        return this.m_calendar.hashCode();
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwCMISDateTime) {
            OwCMISDateTime dateTimeObj = (OwCMISDateTime)obj_p;
            if (this.m_calendar == null || dateTimeObj.m_calendar == null) {
                return this.m_calendar == dateTimeObj.m_calendar;
            }
            return this.m_calendar.equals(dateTimeObj.m_calendar);
        }
        return false;
    }
}

