/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.util;

public class OwCMISQualifiedName {
    private static final String SEPARATOR = ".";
    private static final String SEPARATOR_REGEXP = "\\.";
    private String name;
    private String namespace;

    public OwCMISQualifiedName(String qualifiedName_p) {
        String[] nameSplit;
        if (qualifiedName_p != null && qualifiedName_p.length() > 0 && (nameSplit = qualifiedName_p.split(SEPARATOR_REGEXP)).length > 0) {
            if (nameSplit.length > 1) {
                this.namespace = nameSplit[0];
                this.name = nameSplit[1];
            } else {
                this.name = nameSplit[0];
            }
        }
    }

    public OwCMISQualifiedName(String namespace_p, String name_p) {
        this.namespace = namespace_p;
        this.name = name_p;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwCMISQualifiedName) {
            OwCMISQualifiedName nameObject = (OwCMISQualifiedName)obj;
            if (this.namespace == null ? nameObject.namespace != null : !this.namespace.equals(nameObject.namespace)) {
                return false;
            }
            if (this.name == null) {
                return nameObject.name == null;
            }
            return this.name.equals(nameObject.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        int hash = this.namespace != null ? this.namespace.hashCode() : 0;
        return hash + (this.name != null ? this.name.hashCode() : 0);
    }

    public String toString() {
        return this.namespace != null ? String.valueOf(this.namespace) + SEPARATOR + this.name : this.name;
    }
}

