/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owaddmultidocuments;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwEcmUtil;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwObjectClassSelectionCfg;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwStandardSearchSpecialNodeOperator;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owaddmultidocuments.OwCreateMultipleDocumentsDialog;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.plug.owutil.OwMappingUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwAddMultipleDocumentsRecordFunction
extends OwRecordFunction
implements OwDialog.OwDialogListener {
    protected OwObject m_rootObject;
    protected OwObject m_folderObject;
    private static final Logger LOG = OwLog.getLogger(OwAddMultipleDocumentsRecordFunction.class);
    private List<OwObjectPropertyView.OwPropertyInfo> m_propertyInfos;
    private List<OwDocumentImporter> m_documentImporters;
    private OwObjectClassProcessor processor;
    private OwJspFormConfigurator m_jspConfigurator;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        String strClazz;
        super.init(node_p, context_p);
        this.m_jspConfigurator = this.createOwJspFromConfigurator(node_p);
        if (this.getConfigNode().getSubUtil("EditPropertyList") != null) {
            this.m_propertyInfos = new LinkedList<OwObjectPropertyView.OwPropertyInfo>();
            List propertyConfigNodes = this.getConfigNode().getSafeNodeList("EditPropertyList");
            Iterator it = propertyConfigNodes.iterator();
            while (it.hasNext()) {
                OwStandardXMLUtil propertyConfig = new OwStandardXMLUtil((Node)it.next());
                String propertyName = propertyConfig.getSafeTextValue(null);
                boolean fReadOnly = propertyConfig.getSafeBooleanAttributeValue("readonly", false);
                if (null == propertyName) continue;
                this.m_propertyInfos.add(new OwObjectPropertyView.OwPropertyInfo(propertyName, fReadOnly));
            }
        }
        this.m_documentImporters = new LinkedList<OwDocumentImporter>();
        if (this.getConfigNode().getSubUtil("DocumentImporter") != null) {
            List documentImporterConfigNodes = this.getConfigNode().getSafeNodeList("DocumentImporter");
            Iterator itDocumentImporterConfigNodes = documentImporterConfigNodes.iterator();
            while (itDocumentImporterConfigNodes.hasNext()) {
                OwStandardXMLUtil documentImporterConfig = new OwStandardXMLUtil((Node)itDocumentImporterConfigNodes.next());
                String className = documentImporterConfig.getSafeTextValue("ClassName", null);
                if (className == null) continue;
                try {
                    Class<?> documentImporterClass = Class.forName(className);
                    OwDocumentImporter documentImporter = (OwDocumentImporter)documentImporterClass.newInstance();
                    documentImporter.init(this.getContext(), (OwXMLUtil)documentImporterConfig);
                    this.m_documentImporters.add(documentImporter);
                }
                catch (ClassNotFoundException ex) {
                    String msg = "Plugin initialization failed, Pluginid = " + this.getPluginID() + ". Documentimporter with classname = " + className + " not found, please check your owplugins.xml...";
                    LOG.error((Object)msg, (Throwable)ex);
                    throw new OwConfigurationException(msg, (Throwable)ex);
                }
            }
        }
        if (this.m_documentImporters.size() <= 0) {
            throw new OwConfigurationException("There are no document importers configured for the AddMultipleDocuments Plugin. Do not know how to get the content for the new document.");
        }
        OwXMLUtil handler = this.getConfigNode().getSubUtil("AspectsAssociations");
        if (handler != null && (strClazz = handler.getSafeStringAttributeValue("class", "com.wewebu.ow.server.plug.owaddmultidocuments.OwSecondaryTypesProcessor")) != null) {
            try {
                Class<?> procCls = Class.forName(strClazz);
                this.processor = (OwObjectClassProcessor)procCls.newInstance();
                this.processor.init(handler);
            }
            catch (ClassNotFoundException ex) {
                String msg = "Plugin initialization failed, Pluginid = " + this.getPluginID() + ". AspectsAssociations with class = " + strClazz + " not found, please check configuration.";
                LOG.error((Object)msg, (Throwable)ex);
                throw new OwConfigurationException(msg, (Throwable)ex);
            }
        }
    }

    public boolean getNoEvent() {
        return false;
    }

    public boolean isDragDropTarget() {
        try {
            return this.getConfigNode().getSafeBooleanValue("DragDropTarget", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isMultifileDragDropAllowed() {
        if (!this.isDragDropTarget()) {
            return false;
        }
        try {
            return new OwStandardXMLUtil(this.getConfigNode().getSubNode("DragDropTarget")).getSafeBooleanAttributeValue("multifile", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owaddmultidocuments/add_document.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owaddmultidocuments/add_document_24.png");
    }

    public boolean isEnabled(OwObject rootObject_p, OwObject folderObject_p, int iContext_p) throws Exception {
        if (!super.isEnabled(rootObject_p, folderObject_p, iContext_p)) {
            return false;
        }
        if (null == this.getConfigNode().getSafeTextValue("ParentObject", null)) {
            OwResource resource = null;
            if (folderObject_p != null) {
                resource = folderObject_p.getResource();
            }
            boolean canCreateNewObject = this.getContext().getNetwork().canCreateNewObject(resource, folderObject_p, iContext_p);
            return canCreateNewObject;
        }
        return true;
    }

    public void onClickEvent(OwObject rootObject_p, OwObject folderObject_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(rootObject_p, folderObject_p, 2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owaddmultidocuments.OwAddMultipleDocumentsRecordFunction.invalidobject", "It is not possible to add an object."));
        }
        OwObject parentObject = this.processParentObject(folderObject_p);
        OwResource resource = this.findResource(parentObject);
        OwObjectClassSelectionCfg classSelectionCfg = this.getClassSelectionCfg(this.getConfigNode());
        HashMap<String, String> objectclassmap = new HashMap<String, String>();
        int iDirection = OwMappingUtils.getObjectClassMap((OwXMLUtil)this.getConfigNode(), objectclassmap);
        if ((classSelectionCfg = this.processObjectClassMapping(parentObject, classSelectionCfg, iDirection, objectclassmap)).hasDefaultClass()) {
            String defaultClassName = classSelectionCfg.getDefaultClass().getName();
            try {
                this.getContext().getNetwork().getObjectClass(defaultClassName, resource);
            }
            catch (OwObjectNotFoundException e) {
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owaddmultidocuments.OwAddMultipleDocumentsRecordFunction.invalidobjectclass", "It is not possible to add an object because class (%1) does not exist.", defaultClassName), (Throwable)e);
            }
        }
        int iViewMask = this.calculateViewMask();
        List batchIndexProperties = this.getConfigNode().getSafeStringList("EditBatchPropertyList");
        String strParentObjectClass = this.getConfigNode().getSafeTextValue("ObjectClassParent", null);
        String strClassName = this.getConfigNode().getSafeTextValue("ObjectClass", null);
        OwXMLUtil objectClassSelectionEl = this.getConfigNode().getSubUtil("ObjectClassSelection");
        OwCreateMultipleDocumentsDialog dlg = null;
        dlg = null == strClassName && null == strParentObjectClass && null != objectClassSelectionEl ? this.createCreateMultipleDocumentsDialog(parentObject, resource, classSelectionCfg, batchIndexProperties, this.m_documentImporters, iViewMask) : this.createCreateMultipleDocumentsDialog(parentObject, resource, strClassName, strParentObjectClass, batchIndexProperties, this.m_documentImporters, iViewMask);
        dlg.setJspConfigurator(this.getJspConfigurator());
        dlg.setImporterBeforeBatchHandling(this.getConfigNode().getSafeBooleanValue("ImporterBeforeBatch", false));
        dlg.setUseImporterProposedName(this.getConfigNode().getSafeBooleanValue("UseProposedName", true));
        dlg.setObjectClassProcessor(this.getProcessor());
        this.m_rootObject = rootObject_p;
        this.m_folderObject = folderObject_p;
        if (iDirection == 2) {
            dlg.setFolderMapping(objectclassmap);
        }
        dlg.setValues(OwMappingUtils.getParameterMapValuesFromRecord((OwXMLUtil)this.getConfigNode(), (OwObject)rootObject_p, (OwObject)folderObject_p));
        dlg.setHelp(this.getHelpPath());
        dlg.setInfoIcon(this.getBigIcon());
        dlg.setRefreshContext(refreshCtx_p);
        dlg.setPropertyInfos(this.getPropertyInfos());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(rootObject_p, folderObject_p, 3, 4);
    }

    protected OwCreateMultipleDocumentsDialog createCreateMultipleDocumentsDialog(OwObject folderObject_p, OwResource resource_p, String strClassName_p, String strParentObjectClass_p, Collection batchIndexProperties_p, List documentImporters_p, int iViewMask_p) throws Exception {
        OwCreateMultipleDocumentsDialog dlg = new OwCreateMultipleDocumentsDialog(folderObject_p, resource_p, strClassName_p, strParentObjectClass_p, batchIndexProperties_p, documentImporters_p);
        dlg.setViewMask(iViewMask_p);
        return dlg;
    }

    protected OwCreateMultipleDocumentsDialog createCreateMultipleDocumentsDialog(OwObject folderObject_p, OwResource resource_p, OwObjectClassSelectionCfg classSelectionCfg, Collection batchIndexProperties_p, List documentImporters_p, int iViewMask_p) throws Exception {
        OwCreateMultipleDocumentsDialog dlg = new OwCreateMultipleDocumentsDialog(folderObject_p, resource_p, classSelectionCfg, batchIndexProperties_p, documentImporters_p);
        dlg.setViewMask(iViewMask_p);
        return dlg;
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwCreateMultipleDocumentsDialog dlg = (OwCreateMultipleDocumentsDialog)dialogView_p;
        int status = dlg.getStatus();
        dlg.setObjectClassProcessor(null);
        switch (status) {
            case 2: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 2);
                break;
            }
            case 1: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 1);
                break;
            }
            default: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 3);
            }
        }
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    private OwResource retrieveResourceFromParent(OwObject parent_p) throws Exception {
        OwStandardSearchSpecialNodeOperator scanner = new OwStandardSearchSpecialNodeOperator();
        scanner.scan(parent_p.getSearchTemplate().getSearch(Boolean.FALSE.booleanValue()));
        List objectStores = scanner.getObjectStores();
        OwMainAppContext context = this.getContext();
        OwNetwork network = context.getNetwork();
        HashMap<String, OwResource> resourcesMap = new HashMap<String, OwResource>();
        for (OwSearchObjectStore searchStore : objectStores) {
            String osIdentifier = searchStore.getId();
            if (osIdentifier == null) {
                osIdentifier = searchStore.getName();
            }
            OwResource resource = network.getResource(osIdentifier);
            resourcesMap.put(resource.getID(), resource);
        }
        if (resourcesMap.size() == 1) {
            Collection resources = resourcesMap.values();
            Iterator resourcesIt = resources.iterator();
            return (OwResource)resourcesIt.next();
        }
        LOG.debug((Object)"OwAddMultipleDocumentsRecordFunction.retrieveResourceFromParent: Cannot execute add in none or multiple repositories/objectstores! One and only 1 objectstore must be defined by the undelaying search template!");
        throw new OwInvalidOperationException(this.getContext().localize("plug.owaddmultidocuments.OwAddMultipleDocumentsRecordFunction.invalidMultiResources", "The operation cannot be executed on multiple object stores/repositories."));
    }

    protected OwJspFormConfigurator createOwJspFromConfigurator(OwXMLUtil node_p) throws Exception {
        return new OwJspFormConfigurator(node_p);
    }

    protected OwJspFormConfigurator getJspConfigurator() {
        return this.m_jspConfigurator;
    }

    protected List<OwObjectPropertyView.OwPropertyInfo> getPropertyInfos() {
        return this.m_propertyInfos;
    }

    protected OwObjectClassProcessor getProcessor() {
        return this.processor;
    }

    protected OwObject processParentObject(OwObject currentParent) throws Exception {
        String strParentObject = this.getConfigNode().getSafeTextValue("ParentObject", null);
        if (strParentObject != null) {
            return OwEcmUtil.createObjectFromString((OwMainAppContext)this.getContext(), (String)strParentObject);
        }
        return currentParent;
    }

    protected OwResource findResource(OwObject parentObject) throws Exception {
        if (parentObject != null) {
            OwResource resource = parentObject.getResource();
            if (resource == null && parentObject instanceof OwVirtualFolderObject) {
                resource = this.retrieveResourceFromParent(parentObject);
            }
            return resource;
        }
        return null;
    }

    protected OwObjectClassSelectionCfg getClassSelectionCfg(OwXMLUtil config) throws OwConfigurationException {
        return OwObjectClassSelectionCfg.fromPluginXml((OwXMLUtil)config);
    }

    protected OwObjectClassSelectionCfg processObjectClassMapping(OwObject currentParent, OwObjectClassSelectionCfg classSelectionCfg, int mapDirection, Map<String, String> objectclassmap) throws Exception {
        String defaultClassName = null;
        switch (mapDirection) {
            case 1: {
                if (classSelectionCfg.hasDefaultClass()) {
                    String msg = "OwAddMultipleDocumentsRecordFunction.processObjectClassMapping: You can either specify ObjectClass or ObjectClassMapping, not both in plugindesriptor.";
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
                if (currentParent == null || null != (defaultClassName = objectclassmap.get(currentParent.getName()))) break;
                String folderclassname = currentParent.getObjectClass().getClassName();
                defaultClassName = objectclassmap.get(folderclassname);
                break;
            }
        }
        if (defaultClassName == null) {
            return classSelectionCfg;
        }
        return OwObjectClassSelectionCfg.createSingleClassConfiguration(defaultClassName);
    }

    protected int calculateViewMask() {
        int viewMask = 0;
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"EnablePasteMetadata", (int)1, (boolean)false);
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"AccessRightsView", (int)2, (boolean)false);
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"AutoOpen", (int)4, (boolean)false);
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInModeOption", (int)128, (boolean)true);
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInReleaseVersionOption", (int)256, (boolean)true);
        viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"CheckInReleaseVersionDefault", (int)512, (boolean)true);
        return viewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"EnableSaveAll", (int)1024, (boolean)true);
    }
}

