/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owaddmultidocuments;

import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.ecm.OwLocation;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.plug.owaddmultidocuments.cfg.OwSecondaryTypesProcessorCfg;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwSecondaryTypesProcessor
implements OwObjectClassProcessor {
    private static final Logger LOG = OwLog.getLogger(OwSecondaryTypesProcessor.class);
    private Map<String, String> mapping;

    public OwObjectClass process(OwObjectClass objCls, OwLocation location, OwAppContext ctx) {
        String secTypes;
        OwObjectClass processed = objCls;
        if (this.getMapping() != null && (secTypes = this.getMapping().get(objCls.getClassName())) != null) {
            String objClass = objCls.getClassName() + "," + secTypes;
            OwRoleManagerContext roleCtx = (OwRoleManagerContext)ctx.getRegisteredInterface(OwRoleManagerContext.class);
            if (roleCtx != null) {
                try {
                    processed = roleCtx.getNetwork().getObjectClass(objClass, location.getResource());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not retrieve specific object class = " + objClass), (Throwable)e);
                }
            }
        }
        return processed;
    }

    public void init(OwXMLUtil configNode) throws OwException {
        this.mapping = OwSecondaryTypesProcessorCfg.getMapping(configNode);
    }

    protected Map<String, String> getMapping() {
        return this.mapping;
    }
}

