/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdoccopy;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.ecm.OwObject;
import java.util.HashSet;
import java.util.Map;

public abstract class OwClipboardMoveOperation {
    private OwClipboard clipboard;
    private HashSet<OwObject> parentFoldersToBeRefreshed;
    private Map propertyMap;

    public OwClipboardMoveOperation(OwClipboard clipboard, Map propertyMap) {
        this.clipboard = clipboard;
        this.propertyMap = propertyMap;
        this.parentFoldersToBeRefreshed = new HashSet();
    }

    public void execute() throws Exception {
        for (OwClipboardContentOwObject element : this.clipboard.getContent()) {
            OwObject parent;
            OwObject owObject = element.getObject();
            if (8193 == owObject.getType() && null != (parent = element.getParent())) {
                this.parentFoldersToBeRefreshed.add(parent);
            }
            this.processClipboardElement(element, this.propertyMap);
        }
        this.clipboard.clearContent();
    }

    protected abstract void processClipboardElement(OwClipboardContentOwObject var1, Map var2) throws Exception;

    public void sendUpdates(OwClientRefreshContext refreshCtx_p) throws Exception {
        if (null != refreshCtx_p && !this.parentFoldersToBeRefreshed.isEmpty()) {
            for (OwObject owFolder : this.parentFoldersToBeRefreshed) {
                refreshCtx_p.onClientRefreshContextUpdate(4, (Object)owFolder);
            }
        }
    }
}

