/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdoccopy;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardException;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.command.OwCommand;
import com.wewebu.ow.server.command.OwProcessableObjectStrategy;
import com.wewebu.ow.server.ecm.OwObject;
import java.util.Collection;

public class OwCommandAddToClipboard
extends OwCommand {
    private static final String CLIPBOARD_BEHAVIOR_PROPERTY = "ClipboardBehavior";
    private OwObject m_parent;
    private boolean m_isMessageWarningPosted = false;

    public OwCommandAddToClipboard(OwObject parent_p, Collection objects_p, OwMainAppContext appContext_p, OwClipboard.OwClipboardOperation clipboardOperation_p, OwDocumentFunction plugin_p) {
        super(objects_p, appContext_p, OwCommandAddToClipboard.createProcessableStrategy(plugin_p, parent_p));
        String clipboardType;
        this.m_parent = parent_p;
        if (this.m_appContext.getClipboard().getCut() != clipboardOperation_p.isCutOperation()) {
            this.m_appContext.getClipboard().clearContent();
        }
        if ("OW_CLIPBOARD_BEHAVIOR_APPEND".compareTo(clipboardType = this.m_appContext.getSafeStringAppSetting(CLIPBOARD_BEHAVIOR_PROPERTY, "OW_CLIPBOARD_BEHAVIOR_APPEND")) != 0) {
            this.m_appContext.getClipboard().clearContent();
        }
        this.m_appContext.getClipboard().setCut(clipboardOperation_p.isCutOperation());
    }

    private static OwProcessableObjectStrategy createProcessableStrategy(final OwDocumentFunction plugin_p, final OwObject parent_p) {
        OwProcessableObjectStrategy processableObjectStrategy = new OwProcessableObjectStrategy(){

            public boolean canBeProcessed(OwObject object_p) throws Exception {
                boolean result = plugin_p.isEnabled(object_p, parent_p, 2);
                return result;
            }
        };
        return processableObjectStrategy;
    }

    protected void processObject(OwObject object_p) throws Exception {
        if (!this.m_appContext.getClipboard().canAdd()) {
            if (!this.m_isMessageWarningPosted) {
                this.m_appContext.getClipboard().postWarningMessage();
                this.m_isMessageWarningPosted = true;
            }
            throw new OwClipboardException("Clipboard is full: Cannot add more items in clipboard, the maximum clipboard size was reached!");
        }
        this.m_appContext.getClipboard().addContent(object_p, this.m_parent);
    }
}

