/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdoccopy;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owdoccopy.OwClipboardMoveOperation;
import com.wewebu.ow.server.plug.owutil.OwMappingUtils;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public class OwRecordFunctionPaste
extends OwRecordFunction {
    public static final int INSERT_MODE_REFERENCE = 0;
    public static final int INSERT_MODE_PHYSICALCOPY = 1;
    private int m_insertMode = 0;
    private Set<?> m_supportedObjectTypes;
    private Set<?> m_supportedObjectClasses;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_supportedObjectTypes = this.getSupportedObjectTypesFromDescriptor("pasteitemobjecttypes");
        this.m_supportedObjectClasses = this.getSupportedObjectClassesFromDescriptor("pasteitemobjectclasses");
        String strInsertMode = this.getConfigNode().getSafeTextValue("InsertMode", "INSERT_MODE_REFERENCE");
        try {
            Field insertModeField = ((Object)((Object)this)).getClass().getDeclaredField(strInsertMode);
            this.m_insertMode = insertModeField.getInt(insertModeField);
        }
        catch (Exception e) {
            this.m_insertMode = 0;
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owpaste/paste.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owpaste/paste_24.png");
    }

    public boolean isEnabled(OwObject rootObject_p, OwObject folderObject_p, int iContext_p) throws Exception {
        if (!super.isEnabled(rootObject_p, folderObject_p, iContext_p)) {
            return false;
        }
        if (folderObject_p == null) {
            return false;
        }
        OwClipboard clipboard = this.getContext().getClipboard();
        if (1 != clipboard.getContentType()) {
            return false;
        }
        if (clipboard.getCut()) {
            for (OwClipboardContentOwObject item : clipboard.getContent()) {
                if (this.m_supportedObjectTypes != null && !this.m_supportedObjectTypes.contains(new Integer(item.getObject().getType()))) {
                    return false;
                }
                if (this.m_supportedObjectClasses != null && !this.m_supportedObjectClasses.contains(item.getObject().getClassName())) {
                    return false;
                }
                if (folderObject_p.canMove(item.getObject(), item.getParent(), iContext_p)) continue;
                return false;
            }
        } else {
            for (OwClipboardContentOwObject item : clipboard.getContent()) {
                if (this.m_supportedObjectTypes != null && !this.m_supportedObjectTypes.contains(item.getObject().getType())) {
                    return false;
                }
                if (this.m_supportedObjectClasses != null && !this.m_supportedObjectClasses.contains(item.getObject().getClassName())) {
                    return false;
                }
                if (!(this.m_insertMode == 0 ? !folderObject_p.canAdd(item.getObject(), iContext_p) : !this.getContext().getNetwork().canCreateObjectCopy(folderObject_p, null, iContext_p))) continue;
                return false;
            }
        }
        return true;
    }

    protected void processCut(OwClipboardContentOwObject clipboardObject_p, OwObject folderObject_p, Map propertyMap_p) throws Exception {
        folderObject_p.move(clipboardObject_p.getObject(), clipboardObject_p.getParent());
    }

    protected void processCopyRef(OwClipboardContentOwObject clipboardObject_p, OwObject folderObject_p, Map propertyMap_p) throws Exception {
        OwObject sourceObject_p = clipboardObject_p.getObject();
        folderObject_p.add(sourceObject_p);
    }

    protected void processCopyInstance(OwClipboardContentOwObject clipboardObject_p, OwObject folderObject_p, Map propertyMap_p) throws Exception {
        OwObject sourceObject_p = clipboardObject_p.getObject();
        OwPropertyCollection newPropertyCollection = this.mapPropertyCollection(propertyMap_p, folderObject_p, sourceObject_p);
        OwMainAppContext context = this.getContext();
        OwNetwork network = context.getNetwork();
        network.createObjectCopy(sourceObject_p, newPropertyCollection, null, folderObject_p, null);
    }

    protected OwPropertyCollection mapPropertyCollection(Map propertyMap_p, OwObject folderObject_p, OwObject sourceObject_p) throws Exception {
        OwStandardPropertyCollection newPropertyCollection = null;
        if (null != propertyMap_p && folderObject_p != null) {
            newPropertyCollection = new OwStandardPropertyCollection();
            OwPropertyCollection sourceProps = sourceObject_p.getClonedProperties(null);
            for (OwProperty prop : sourceProps.values()) {
                if (prop.isReadOnly(1) || prop.getPropertyClass().isSystemProperty() || prop.isHidden(1)) continue;
                OwProperty original = (OwProperty)sourceProps.get((Object)prop.getPropertyClass().getClassName());
                prop.setValue(original.getValue());
                newPropertyCollection.put((Object)prop.getPropertyClass().getClassName(), (Object)prop);
            }
            for (String strPropName : propertyMap_p.keySet()) {
                try {
                    OwProperty property = sourceObject_p.getProperty(strPropName.toString());
                    property.setValue(propertyMap_p.get(strPropName));
                    newPropertyCollection.put((Object)property.getPropertyClass().getClassName(), (Object)property);
                }
                catch (OwObjectNotFoundException e) {}
            }
        }
        return newPropertyCollection;
    }

    public void onClickEvent(OwObject rootObject_p, final OwObject folderObject_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(rootObject_p, folderObject_p, 2)) {
            throw new OwInvalidOperationException(new OwString("plug.owdoccopy.OwRecordFunctionPaste.invalidobject", "Item cannot be pasted."));
        }
        Map propertyMap = null;
        if (this.createPropertyMap()) {
            propertyMap = OwMappingUtils.getParameterMapValuesFromRecord((OwXMLUtil)this.getConfigNode(), (OwObject)rootObject_p, (OwObject)folderObject_p);
        }
        OwClipboard clipboard = this.getContext().getClipboard();
        OwClipboardMoveOperation clipboardOperation = null;
        try {
            if (clipboard.getCut()) {
                clipboardOperation = new OwClipboardMoveOperation(clipboard, propertyMap){

                    @Override
                    protected void processClipboardElement(OwClipboardContentOwObject element, Map propertyMap) throws Exception {
                        OwRecordFunctionPaste.this.processCut(element, folderObject_p, propertyMap);
                    }
                };
                clipboardOperation.execute();
            } else {
                for (OwClipboardContentOwObject element : clipboard.getContent()) {
                    if (this.m_insertMode == 0) {
                        this.processCopyRef(element, folderObject_p, propertyMap);
                        continue;
                    }
                    this.processCopyInstance(element, folderObject_p, propertyMap);
                }
            }
        }
        catch (Exception e) {
            this.addHistoryEvent(rootObject_p, folderObject_p, 3, 2);
            throw e;
        }
        this.addHistoryEvent(rootObject_p, folderObject_p, 3, 1);
        if (null != refreshCtx_p) {
            if (null != clipboardOperation) {
                clipboardOperation.sendUpdates(refreshCtx_p);
            }
            refreshCtx_p.onClientRefreshContextUpdate(4, null);
        }
    }

    protected boolean createPropertyMap() {
        return this.m_insertMode == 1;
    }
}

