/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocdel;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.command.OwProcessableObjectStrategy;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.event.OwEvent;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.history.OwStandardHistoryObjectDeleteEvent;
import com.wewebu.ow.server.plug.owdocdel.OwCommandDel;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OwDocumentFunctionDel
extends OwDocumentFunction {
    public int TOTAL_ELEMENTS_DISPLAY = 10;

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdelref/deletebtn.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdelref/deletebtn_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        return super.isEnabled(oObject_p, oParent_p, iContext_p) && oObject_p.canDelete(iContext_p);
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            if (oObject_p.hasVersionSeries() && oObject_p.getVersion().isCheckedOut(2)) {
                boolean isMyCheckedOut = false;
                try {
                    isMyCheckedOut = oObject_p.getVersion().isMyCheckedOut(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!isMyCheckedOut) {
                    String checkedoutBy = null;
                    try {
                        checkedoutBy = oObject_p.getVersion().getCheckedOutUserID(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (checkedoutBy != null && !checkedoutBy.equals("")) {
                        checkedoutBy = this.getDisplayNameFromUserId(checkedoutBy);
                        throw new OwInvalidOperationException(this.getContext().localize1("plug.owdms.OwDocumentFunctionDel.documentCheckedOutbyOtherUser", "Cannot delete in the document. The document is checked out by user (%1).", checkedoutBy));
                    }
                }
            }
            throw new OwInvalidOperationException(this.getContext().localize("owdocdel.OwDocumentFunctionDel.invalidobject", "Item cannot be deleted."));
        }
        StringBuffer dialogContent = new StringBuffer();
        dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDel.wanttodeleteobject", "Warning!<br><br>You are about to delete this item permanently. In doing so, all links to the item are deleted as well.<br />"));
        dialogContent.append("<ul class=\"OwMessageBoxText\">");
        dialogContent.append("<li>");
        dialogContent.append(OwHTMLHelper.encodeToSecureHTML((String)oObject_p.getName()));
        dialogContent.append("</li>");
        dialogContent.append("</ul><br />");
        dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDel.continue", "Do you really want to continue?"));
        OwDelMessageBox dlg = new OwDelMessageBox(2, 0, this.getDefaultLabel(), dialogContent.toString());
        dlg.m_Objects = new ArrayList(1);
        dlg.m_Objects.add(oObject_p);
        dlg.m_Objectnames = new ArrayList(1);
        dlg.m_Objectnames.add(oObject_p.getName());
        dlg.m_refreshCtx = refreshCtx_p;
        dlg.m_Parent = oParent_p;
        this.addHistoryEvent(dlg.m_Objectnames, dlg.m_Parent, 3, 4);
        this.getContext().openDialog((OwDialog)dlg, null);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        StringBuffer dialogContent = new StringBuffer();
        dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDel.wanttodeleteobjects", "Warning!<br><br>You are about to delete these items permanently. In doing so, all links to the items are deleted as well."));
        dialogContent.append("<ul class=\"OwMessageBoxText\">");
        Iterator it = objects_p.iterator();
        while (it.hasNext()) {
            OwObject obj = (OwObject)it.next();
            if (!this.isEnabled(obj, oParent_p, 2)) continue;
            dialogContent.append("<li>");
            dialogContent.append(OwHTMLHelper.encodeToSecureHTML((String)obj.getName()));
            dialogContent.append("</li>");
            if (0 != --this.TOTAL_ELEMENTS_DISPLAY || !it.hasNext()) continue;
            dialogContent.append("<li>");
            dialogContent.append("...");
            dialogContent.append("</li>");
            break;
        }
        dialogContent.append("</ul><br />");
        dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDel.continue", "Do you really want to continue?"));
        OwDelMessageBox dlg = new OwDelMessageBox(2, 0, this.getDefaultLabel(), dialogContent.toString());
        dlg.m_Objects = objects_p;
        dlg.m_Objectnames = new ArrayList(objects_p.size());
        for (OwObject obj : objects_p) {
            dlg.m_Objectnames.add(obj.getName());
        }
        dlg.m_refreshCtx = refreshCtx_p;
        dlg.m_Parent = oParent_p;
        this.addHistoryEvent(dlg.m_Objectnames, dlg.m_Parent, 3, 4);
        this.getContext().openDialog((OwDialog)dlg, null);
    }

    protected void addHistoryEvent(Collection objectnames_p, OwObject oParent_p, int iEventType_p, int iStatus_p) throws Exception {
        this.getEventManager().addEvent(iEventType_p, this.getPluginID(), (OwEvent)new OwStandardHistoryObjectDeleteEvent(objectnames_p, (OwObjectReference)oParent_p), iStatus_p);
    }

    private class OwDelMessageBox
    extends OwMessageBox {
        public Collection m_Objects;
        public Collection m_Objectnames;
        public OwObject m_Parent;
        public OwClientRefreshContext m_refreshCtx;

        public OwDelMessageBox(int type_p, int icontype_p, String strTitle_p, String strText_p) {
            super(type_p, 2, icontype_p, strTitle_p, strText_p);
        }

        public void onOK() throws Exception {
            OwProcessableObjectStrategy processableObjectStrategy = new OwProcessableObjectStrategy(){

                public boolean canBeProcessed(OwObject object_p) throws Exception {
                    return OwDocumentFunctionDel.this.isEnabled(object_p, null, 2);
                }
            };
            OwCommandDel commandDel = new OwCommandDel(this.m_Objects, (OwMainAppContext)this.getContext(), processableObjectStrategy);
            commandDel.execute();
            if (commandDel.hasProcessedObjects()) {
                OwDocumentFunctionDel.this.addHistoryEvent(commandDel.getProcessedObjectNames(), this.m_Parent, 3, 1);
                if (null != this.m_refreshCtx) {
                    this.m_refreshCtx.onClientRefreshContextUpdate(11, (Object)commandDel.getProcessedDMSIDs());
                }
            }
            if (commandDel.hasDisabledObjects()) {
                OwDocumentFunctionDel.this.addHistoryEvent(commandDel.getDisabledObjectNames(), this.m_Parent, 3, 5);
            }
            if (commandDel.hasErrors()) {
                OwDocumentFunctionDel.this.addHistoryEvent(commandDel.getAllErrorNames(), this.m_Parent, 3, 2);
                throw new Exception(commandDel.getAllErrorMessages());
            }
        }

        public void onCancel() throws Exception {
            OwDocumentFunctionDel.this.addHistoryEvent(this.m_Objectnames, this.m_Parent, 3, 3);
        }
    }
}

