/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocdel;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.command.OwProcessableObjectStrategy;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.event.OwEvent;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.history.OwStandardHistoryObjectDeleteEvent;
import com.wewebu.ow.server.plug.owdocdel.OwCommandDelRef;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class OwDocumentFunctionDelRef
extends OwDocumentFunction {
    public int TOTAL_ELEMENTS_DISPLAY = 10;

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdelref/remove.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdelref/remove_24.png");
    }

    public boolean getNeedParent() {
        return true;
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        return super.isEnabled(oObject_p, oParent_p, iContext_p) && oParent_p.canRemoveReference(oObject_p, iContext_p);
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            throw new OwInvalidOperationException(new OwString("owdocdel.OwDocumentFunctionDelRef.invalidobject", "Item cannot be removed."));
        }
        StringBuffer dialogContent = new StringBuffer();
        if (1 == oObject_p.getParents().size()) {
            dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.wanttodeletelastobject", "Warning!<br><br>You are about to delete the last link to this item."));
        } else {
            dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.wanttodeleteobject", "Warning!<br><br>You are about to delete the link to this item."));
        }
        dialogContent.append("<ul class=\"OwMessageBoxText\">");
        dialogContent.append("<li>");
        dialogContent.append(OwHTMLHelper.encodeToSecureHTML((String)oObject_p.getName()));
        dialogContent.append("</li>");
        dialogContent.append("</ul><br/>");
        dialogContent.append(this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.continue", "Do you really want to continue?"));
        OwDelRefMessageBox dlg = new OwDelRefMessageBox(2, 0, this.getDefaultLabel(), dialogContent.toString());
        dlg.m_Objects = new ArrayList(1);
        dlg.m_Objects.add(oObject_p);
        dlg.m_Objectnames = new ArrayList(1);
        dlg.m_Objectnames.add(oObject_p.getName());
        dlg.m_refreshCtx = refreshCtx_p;
        dlg.m_Parent = oParent_p;
        this.addHistoryEvent(dlg.m_Objectnames, dlg.m_Parent, 3, 4);
        this.getContext().openDialog((OwDialog)dlg, null);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        StringBuffer strObjectsTitleWithEllipses = new StringBuffer();
        strObjectsTitleWithEllipses.append("<ul class=\"OwMessageBoxText\">");
        Vector<OwObject> lastReferences = new Vector<OwObject>();
        Iterator it = objects_p.iterator();
        while (it.hasNext()) {
            OwObject obj = (OwObject)it.next();
            if (!this.isEnabled(obj, oParent_p, 2)) continue;
            strObjectsTitleWithEllipses.append("<li>");
            strObjectsTitleWithEllipses.append(OwHTMLHelper.encodeToSecureHTML((String)obj.getName()));
            if (1 == obj.getParents().size()) {
                lastReferences.add(obj);
                strObjectsTitleWithEllipses.append(" (*)");
            }
            strObjectsTitleWithEllipses.append("</li>");
            if (0 != --this.TOTAL_ELEMENTS_DISPLAY || !it.hasNext()) continue;
            strObjectsTitleWithEllipses.append("<li>");
            strObjectsTitleWithEllipses.append("...");
            strObjectsTitleWithEllipses.append("</li>");
            break;
        }
        strObjectsTitleWithEllipses.append("</ul>");
        OwDelRefMessageBox dlg = 0 < lastReferences.size() ? new OwDelRefMessageBox(2, 0, this.getDefaultLabel(), this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.wanttodeletelastobjects", "Warning!<br><br>You are about to delete the last link to this item.") + strObjectsTitleWithEllipses + "<br>" + this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.continue", "Do you really want to continue?")) : new OwDelRefMessageBox(2, 0, this.getDefaultLabel(), this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.wanttodeleteobjects", "Warning!<br><br>You are about to delete the links to these items.") + strObjectsTitleWithEllipses + "<br>" + this.getContext().localize("owdocdel.OwDocumentFunctionDelRef.continue", "Do you really want to continue?"));
        dlg.m_Objects = objects_p;
        dlg.m_Objectnames = new ArrayList(objects_p.size());
        for (OwObject obj : objects_p) {
            dlg.m_Objectnames.add(obj.getName());
        }
        dlg.m_refreshCtx = refreshCtx_p;
        dlg.m_Parent = oParent_p;
        this.addHistoryEvent(dlg.m_Objectnames, dlg.m_Parent, 3, 4);
        this.getContext().openDialog((OwDialog)dlg, null);
    }

    protected void addHistoryEvent(Collection objectnames_p, OwObject oParent_p, int iEventType_p, int iStatus_p) throws Exception {
        this.getEventManager().addEvent(iEventType_p, this.getPluginID(), (OwEvent)new OwStandardHistoryObjectDeleteEvent(objectnames_p, (OwObjectReference)oParent_p), iStatus_p);
    }

    private class OwDelRefMessageBox
    extends OwMessageBox {
        public Collection m_Objects;
        public Collection m_Objectnames;
        public OwObject m_Parent;
        public OwClientRefreshContext m_refreshCtx;

        public OwDelRefMessageBox(int type_p, int icontype_p, String strTitle_p, String strText_p) {
            super(type_p, 2, icontype_p, strTitle_p, strText_p);
        }

        public void onOK() throws Exception {
            OwProcessableObjectStrategy processableObjectStrategy = new OwProcessableObjectStrategy(){

                public boolean canBeProcessed(OwObject object_p) throws Exception {
                    return OwDocumentFunctionDelRef.this.isEnabled(object_p, OwDelRefMessageBox.this.m_Parent, 2);
                }
            };
            OwCommandDelRef commandDelRef = new OwCommandDelRef(this.m_Objects, this.m_Parent, (OwMainAppContext)this.getContext(), processableObjectStrategy);
            commandDelRef.execute();
            if (commandDelRef.hasProcessedObjects()) {
                OwDocumentFunctionDelRef.this.addHistoryEvent(commandDelRef.getProcessedObjectNames(), this.m_Parent, 3, 1);
            }
            if (commandDelRef.hasDisabledObjects()) {
                OwDocumentFunctionDelRef.this.addHistoryEvent(commandDelRef.getDisabledObjectNames(), this.m_Parent, 3, 5);
            }
            if (commandDelRef.hasErrors()) {
                OwDocumentFunctionDelRef.this.addHistoryEvent(commandDelRef.getAllErrorNames(), this.m_Parent, 3, 2);
                throw new Exception(commandDelRef.getAllErrorMessages());
            }
            if (null != this.m_refreshCtx) {
                this.m_refreshCtx.onClientRefreshContextUpdate(11, null);
            }
        }

        public void onCancel() throws Exception {
            OwDocumentFunctionDelRef.this.addHistoryEvent(this.m_Objectnames, this.m_Parent, 3, 3);
        }
    }
}

