/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.OwGroupPropertiesConfiguration;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyFormularView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesDialog;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesDialogBuilder;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.plug.owutil.OwObjectUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwEditDocumentPropertiesFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwEditDocumentPropertiesFunction.class);
    private OwJspFormConfigurator m_owJspFormConfigurator;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_owJspFormConfigurator = new OwJspFormConfigurator(node_p);
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocprops/edit_properties.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocprops/edit_properties_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            LOG.debug((Object)"OwEditDocumentProperties.onClickEvent(): the edit function is not enabled for the given object !");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.invalid.object", "Item can not be edited!"));
        }
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        LinkedList<OwObject> enabledObjects = new LinkedList<OwObject>();
        for (OwObject objectToEdit : objects_p) {
            if (!this.isEnabled(objectToEdit, oParent_p, 2)) continue;
            enabledObjects.add(objectToEdit);
        }
        if (enabledObjects.isEmpty()) {
            LOG.error((Object)"OwEditDocumentProperties.onMultiselectClickEvent(): Invalid object collection!The enabled objects collection is empty!");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.object.collection", "Invalid object collection!"));
        }
        List batchIndexProperties = this.getConfigNode().getSafeStringList("EditBatchPropertyList");
        int iViewMask = 0;
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"PropertiesView", (int)1);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"SystemPropertiesView", (int)2);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"VersionsView", (int)8);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"HistoryView", (int)16);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"LinksView", (String)"show", (int)OwEditPropertiesDialog.VIEW_MASK_LINKS, (boolean)false);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"FiledInView", (int)32);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"AccessRightsView", (int)4);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"DocumentFunctionsView", (int)64);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"EnablePasteMetadata", (int)128);
        iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"EnableSaveAll", (int)4096);
        int iReadOnlyViewMask = 0;
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"PropertiesView", (int)1);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"SystemPropertiesView", (int)2);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"VersionsView", (int)8);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"HistoryView", (int)16);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"FiledInView", (int)32);
        iReadOnlyViewMask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"AccessRightsView", (int)4);
        Node historyNode = this.getConfigNode().getSubNode("HistoryView");
        iViewMask |= OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)historyNode, (String)"objecthistory", (boolean)true) ? 1024 : 0;
        int n = OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)historyNode, (String)"casehistory", (boolean)true) ? 2048 : 0;
        OwSearchTemplate historySearchTemplate = null;
        List historyViewColumnInfo = null;
        if (((iViewMask |= n) & 0x10) == 16) {
            String strHistoryViewSearchTemplate = this.getConfigNode().getSafeTextValue("HistoryViewSearchTemplate", null);
            if (null != strHistoryViewSearchTemplate) {
                historySearchTemplate = (OwSearchTemplate)this.getContext().getNetwork().getApplicationObject(3, strHistoryViewSearchTemplate, false, false);
                historySearchTemplate.init((OwFieldDefinitionProvider)this.getContext().getHistoryManager());
            } else {
                historyViewColumnInfo = (List)this.getSafeSetting("HistoryViewColumnInfo", null);
                if (historyViewColumnInfo == null) {
                    String msg = "OwEditDocumentProperties.onMultiselectClickEvent: Please specify either &lt;HistoryViewSearchTemplate&gt; ... or &lt;settingsset&gt; &lt;HistoryViewColumnInfo&gt; in the plugin descriptor, PluginId = " + this.getPluginID();
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
            }
        }
        Collection<Object> objects = enabledObjects;
        if (this.getConfigNode().getSafeBooleanValue("AlwaysUseLatestVersion", false)) {
            objects = OwObjectUtils.getLatesVersionObjects(enabledObjects);
        }
        OwXMLUtil linksViewConfig = this.getConfigNode().getSubUtil("LinksView");
        OwObjectLinkRelation split = OwObjectLinkRelation.BOTH;
        List linkClassNames = Collections.EMPTY_LIST;
        boolean displayTypedList = true;
        if (linksViewConfig != null) {
            displayTypedList = linksViewConfig.getSafeBooleanAttributeValue("typeList", true);
            String direction = linksViewConfig.getSafeStringAttributeValue("direction", "BOTH");
            try {
                split = OwObjectLinkRelation.valueOf((String)direction);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Invalid direction attribute value in confiuration of document function with ID=" + this.getPluginID()), (Throwable)e);
            }
            linkClassNames = linksViewConfig.getSafeStringList("linkclasses");
        }
        OwEditPropertiesDialog dlg = this.createPropertiesDialog(objects, oParent_p, refreshCtx_p, this.getConfigNode().getSafeIntegerValue("MaxChildSize", 50), (List)this.getSafeSetting("VersionViewColumnInfo", null), historySearchTemplate, historyViewColumnInfo, batchIndexProperties, split, displayTypedList, linkClassNames);
        iViewMask |= this.getConfigNode().getSafeBooleanValue("AutoOpen", false) ? 512 : 0;
        dlg.setViewMask(iViewMask |= OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)this.getConfigNode().getSubNode("AutoOpen"), (String)"previewmode", (boolean)false) ? 256 : 0);
        dlg.setReadOnlyViewMask(iReadOnlyViewMask);
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getContext().localize("owdocprops.OwEditDocumentProperties.helptitle", "Dokument Eigenschaften bearbeiten"));
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(objects, oParent_p, 2, 1);
    }

    protected OwEditPropertiesDialog createPropertiesDialog(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p, int iMaxElementSize_p, Collection versionColumnInfo_p, OwSearchTemplate historyViewSearchTemplate_p, Collection historyViewColumnInfo_p, Collection batchIndexProperties_p, OwObjectLinkRelation relationSplit_p, boolean displayTypedList_p, Collection<String> linkClassNames_p) throws Exception {
        OwEditPropertiesDialog owEditDocumentProps = new OwEditPropertiesDialogBuilder().items(objects_p).index(0).parentObject(oParent_p).maxElementSize(iMaxElementSize_p).versionColumnInfo(versionColumnInfo_p).historyViewSearchTemplate(historyViewSearchTemplate_p).historyViewColumnInfo(historyViewColumnInfo_p).batchIndexProperties(batchIndexProperties_p).relationSplit(relationSplit_p).displayLinksByType(displayTypedList_p).linkClassNames(linkClassNames_p).build();
        owEditDocumentProps.setJspConfigurator(this.m_owJspFormConfigurator);
        owEditDocumentProps.setGroupPropertiesConfiguration(new OwGroupPropertiesConfiguration(this.getConfigNode(), this.m_MainContext));
        return owEditDocumentProps;
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        switch (code_p) {
            case 15: {
                if (caller_p instanceof OwObjectPropertyView) {
                    OwObjectPropertyView realCaller = (OwObjectPropertyView)caller_p;
                    OwObject objectRef = realCaller.getObjectRef();
                    this.historizeModifiedPropsEvent(objectRef);
                    break;
                }
                if (!(caller_p instanceof OwObjectPropertyFormularView)) break;
                OwObjectPropertyFormularView realCaller = (OwObjectPropertyFormularView)caller_p;
                OwObject objectRef = realCaller.getObjectRef();
                this.historizeModifiedPropsEvent(objectRef);
            }
        }
    }

    private void historizeModifiedPropsEvent(OwObject objectRef_p) throws Exception {
        LinkedList<OwObject> objectColection = new LinkedList<OwObject>();
        if (objectRef_p != null) {
            objectColection.add(objectRef_p);
            OwObjectCollection parents = objectRef_p.getParents();
            OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
            this.addHistoryEvent(objectRef_p, parent, 3, 1);
        }
    }
}

