/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.ecm.OwFieldPropertyClassWrapper;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.plug.owdocprops.OwFieldsView;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OwEditMultiDocumentFieldsDialogSimple
extends OwStandardDialog {
    public static final int VIEW_MASK_SHOW_DOCUMENT_LIST = 1;
    public static final int VIEW_MASK_CLOSE_ON_SAVE = 2;
    protected int m_iViewMask;
    protected List m_failedObjects = new LinkedList();
    protected OwObject m_processedObject;
    private Collection m_objects;
    private Collection m_fieldnames;
    private Map m_propertyclasses;

    public OwEditMultiDocumentFieldsDialogSimple(Collection objects_p, OwObject parent_p, Collection fieldnames_p) throws Exception {
        this.m_objects = objects_p;
        this.m_fieldnames = fieldnames_p;
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (this.m_iViewMask & iViewMask_p) > 0;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    public void saveFields(Map changedFields_p) throws Exception {
        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        for (OwField field : changedFields_p.values()) {
            properties.put((Object)field.getFieldDefinition().getClassName(), (Object)new OwStandardProperty(field.getValue(), (OwPropertyClass)new OwFieldPropertyClassWrapper(field.getFieldDefinition())));
        }
        for (OwObject obj : this.m_objects) {
            try {
                obj.setProperties((OwPropertyCollection)properties);
                this.m_processedObject = obj;
                this.getDocument().update((OwEventTarget)this, 15, null);
            }
            catch (Exception e) {
                this.m_failedObjects.add(obj);
            }
        }
        if (this.hasViewMask(2)) {
            this.closeDialog();
        }
    }

    protected Collection getFieldNames() {
        return this.m_fieldnames;
    }

    protected Collection getObjects() {
        return this.m_objects;
    }

    private Map determinePropertyClasses(Collection objects_p, Collection fieldnames_p) throws Exception {
        HashMap<String, OwPropertyClass> ret = new HashMap<String, OwPropertyClass>();
        for (OwObject obj : objects_p) {
            OwObjectClass objclass = obj.getObjectClass();
            for (String name : fieldnames_p) {
                try {
                    OwPropertyClass propclass = objclass.getPropertyClass(name);
                    OwPropertyClass mappropclass = (OwPropertyClass)ret.get(propclass.getClassName());
                    if (null == mappropclass) {
                        ret.put(propclass.getClassName(), propclass);
                        continue;
                    }
                    if (propclass.getJavaClassName().equals(mappropclass.getJavaClassName())) continue;
                    throw new OwInvalidOperationException(this.getContext().localize2("owplug.OwEditMultiDocumentFieldsDialogSimple.propertytypematcherror", "Different data types for the property [%1] in [%2].", propclass.getDisplayName(this.getContext().getLocale()), obj.getName()));
                }
                catch (OwObjectNotFoundException e) {
                    throw new OwInvalidOperationException(this.getContext().localize2("owplug.OwEditMultiDocumentFieldsDialogSimple.propertynotfound", "Could not find the property [%1] in [%2].", name, obj.getName()), (Throwable)e);
                }
            }
        }
        return ret;
    }

    protected void init() throws Exception {
        super.init();
        this.m_propertyclasses = this.determinePropertyClasses(this.m_objects, this.m_fieldnames);
        OwSubLayout m_Layout = new OwSubLayout();
        this.addView((OwView)m_Layout, 2, null);
        HashMap<String, OwEditField> fields = new HashMap<String, OwEditField>();
        ArrayList<OwStandardFieldColumnInfo> columninfo = new ArrayList<OwStandardFieldColumnInfo>();
        columninfo.add(new OwStandardFieldColumnInfo((OwFieldDefinition)OwResource.m_ObjectNamePropertyClass, 0));
        for (String name : this.getFieldNames()) {
            OwFieldDefinition def = (OwFieldDefinition)this.m_propertyclasses.get(name);
            fields.put(name, new OwEditField(def, null));
            columninfo.add(new OwStandardFieldColumnInfo(def, 0));
        }
        OwEditFieldsView fieldsview = new OwEditFieldsView(this);
        int fieldsViewMask = 0;
        fieldsViewMask |= this.hasViewMask(128) ? 128 : 0;
        fieldsview.setViewMask(fieldsViewMask |= this.hasViewMask(4) ? 4 : 0);
        m_Layout.addView((OwView)fieldsview, 2, null);
        fieldsview.setFields(fields);
        if (this.hasViewMask(1)) {
            OwObjectListViewRow objectssview = new OwObjectListViewRow(0);
            m_Layout.addView((OwView)objectssview, 0, null);
            objectssview.setColumnInfo(columninfo);
            OwStandardObjectCollection list = new OwStandardObjectCollection();
            list.addAll(this.getObjects());
            objectssview.setObjectList((OwObjectCollection)list, null);
        }
    }

    public List getFailedObjects() {
        return this.m_failedObjects;
    }

    public OwObject getProcessedObject() {
        return this.m_processedObject;
    }

    public static class OwEditField
    implements OwField {
        private OwFieldDefinition fielddefinition;
        private Object value;

        public OwFieldDefinition getFieldDefinition() throws Exception {
            return this.fielddefinition;
        }

        public Object getValue() throws Exception {
            return this.value;
        }

        public void setValue(Object value_p) throws Exception {
            this.value = value_p;
        }

        public OwEditField(OwFieldDefinition fieldDefinition_p, Object value_p) {
            this.fielddefinition = fieldDefinition_p;
            this.value = value_p;
        }
    }

    private static class OwEditFieldsView
    extends OwFieldsView {
        private OwEditMultiDocumentFieldsDialogSimple m_owEditMultiDocumentFieldsDialogSimple;

        public OwEditFieldsView(OwEditMultiDocumentFieldsDialogSimple owEditMultiDocumentFieldsDialogSimple_p) {
            this.m_owEditMultiDocumentFieldsDialogSimple = owEditMultiDocumentFieldsDialogSimple_p;
        }

        @Override
        protected void saveFields(Map changedFields_p) throws Exception {
            this.m_owEditMultiDocumentFieldsDialogSimple.saveFields(changedFields_p);
        }
    }
}

