/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwStatusIconDocumentFunction
extends OwDocumentFunction {
    private static final Logger LOG = OwLog.getLogger(OwStatusIconDocumentFunction.class);
    private Vector m_rules = new Vector();

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        for (Node n : node_p.getSafeNodeList("IconRules")) {
            this.m_rules.add(new OwStatusIconDocumentFunctionIconRule(n, context_p));
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owstatus/hasminorversions.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owstatus/hasminorversions_24.png");
    }

    public boolean getObjectInstance() {
        return true;
    }

    public boolean getContextMenu() {
        return false;
    }

    public boolean getMultiselect() {
        return false;
    }

    public boolean getNoEvent() {
        return true;
    }

    public String getIconHTML(OwObject oObject_p, OwObject oParent_p) throws Exception {
        this.addHistoryEvent(oObject_p, oParent_p, 1, 1);
        for (OwStatusIconDocumentFunctionIconRule rule : this.m_rules) {
            String icon = rule.applyAndGetIcon(oObject_p, oParent_p);
            if (null == icon) continue;
            return icon;
        }
        return "";
    }

    public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
    }

    private static class OwStatusIconDocumentFunctionIconRule {
        String m_icon;
        String m_property;
        String m_value;

        public OwStatusIconDocumentFunctionIconRule(Node n_p, OwMainAppContext context_p) throws Exception {
            String icon = OwXMLDOMUtil.getSafeStringAttributeValue((Node)n_p, (String)"icon", null);
            if (icon == null) {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a icon in IconRule.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            String tooltip = OwXMLDOMUtil.getSafeStringAttributeValue((Node)n_p, (String)"tooltip", null);
            String rule = n_p.getFirstChild().getNodeValue();
            if (rule == null) {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a rule.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            int iEqual = rule.indexOf("=");
            if (-1 == iEqual) {
                String msg = "OwStatusIconDocumentFunction$OwStatusIconDocumentFunctionIconRule: Please specify a '=' in the rule.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            this.m_property = rule.substring(0, iEqual);
            this.m_property = this.m_property.trim();
            this.m_value = rule.substring(iEqual + 1);
            this.m_value = this.m_value.trim();
            if (this.m_value.equals("OW_NULL")) {
                this.m_value = null;
            }
            StringBuilder iconbuf = new StringBuilder();
            tooltip = tooltip == null ? this.m_property : context_p.localizeLabel(tooltip);
            iconbuf.append("<img class=\"OwFunctionIcon\" alt=\"");
            iconbuf.append(tooltip);
            iconbuf.append("\" title=\"");
            iconbuf.append(tooltip);
            iconbuf.append("\" src=\"");
            iconbuf.append(context_p.getDesignURL());
            iconbuf.append(icon);
            iconbuf.append("\"/>");
            this.m_icon = iconbuf.toString();
        }

        public String applyAndGetIcon(OwObject oObject_p, OwObject oParent_p) throws Exception {
            try {
                OwProperty prop = oObject_p.getProperty(this.m_property);
                Object value = prop.getValue();
                if (value == null) {
                    return this.m_value == null ? this.m_icon : null;
                }
                if (this.m_value != null) {
                    return value.toString().equals(this.m_value) ? this.m_icon : null;
                }
                return null;
            }
            catch (OwObjectNotFoundException e) {
                return null;
            }
        }
    }
}

