/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocview;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;

public class OwDownloadAsZipDocumentFunction
extends OwDocumentFunction {
    protected static final String DEFAULT_URL = "multifileDownload";
    protected static final String TAG_DOWNLOAD_URL = "downloadUrl";
    private String m_servletUrl;

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdms/compress.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdms/compress_24.png");
    }

    public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
        if (!super.isEnabled(object_p, parent_p, context_p)) {
            return false;
        }
        return object_p.getType() == 4097 && object_p.hasContent(context_p);
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        ArrayList<OwObject> objects = new ArrayList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        ArrayList<OwObject> filesToZip = new ArrayList<OwObject>();
        for (OwObject object : objects_p) {
            if (!this.isEnabled(object, parent_p, 2)) {
                String escapedName = OwHTMLHelper.encodeToSecureHTML((String)object.getName());
                this.m_MainContext.postMessage(this.m_MainContext.localize1("OwDownloadAsZipDocumentFunction.nodocument", "Object %1 is not a document.", escapedName));
                continue;
            }
            filesToZip.add(object);
        }
        if (filesToZip == null || filesToZip.size() == 0) {
            this.m_MainContext.postMessage(this.m_MainContext.localize("OwDownloadAsZipDocumentFunction.nofile", "No valid file(s) to download selected!"));
            return;
        }
        this.m_MainContext.getHttpSession().setAttribute("OwMultifileDownload.files2download", filesToZip);
        StringBuffer downloadServletUrl = new StringBuffer();
        downloadServletUrl.append(this.m_MainContext.getBaseURL());
        if (!this.m_servletUrl.startsWith("/")) {
            downloadServletUrl.append("/");
        }
        downloadServletUrl.append(this.getServletUrl());
        downloadServletUrl.append("?t=");
        downloadServletUrl.append(System.currentTimeMillis());
        this.m_MainContext.addFinalScript("navigateServiceFrameTO(\"" + downloadServletUrl + "\");");
        this.addHistoryEvent(objects_p, parent_p, 1, 1);
    }

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.setServletUrl(node_p.getSafeTextValue(TAG_DOWNLOAD_URL, DEFAULT_URL));
    }

    protected void setServletUrl(String servletUrl_p) {
        this.m_servletUrl = servletUrl_p;
    }

    public String getServletUrl() {
        return this.m_servletUrl;
    }
}

