/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owlink;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectLinksDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectLinksView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owlink.OwReferencedObjectAllLinksView;
import com.wewebu.ow.server.plug.owlink.OwReferencedObjectTypedLinksView;
import com.wewebu.ow.server.plug.owlink.OwShowLinksDialog;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwDocumentFunctionShowLinks
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwDocumentFunctionShowLinks.class);
    protected static final String SETTINGS_COLUMN_INFO = "columninfo";
    private List<String> linkClassNames = Collections.emptyList();
    private OwObjectLinkRelation split = OwObjectLinkRelation.BOTH;
    private boolean displayTypedList = true;
    private List<String> documentFunctionIds = Collections.emptyList();

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        if (node_p != null) {
            this.displayTypedList = node_p.getSafeBooleanValue("typeList", true);
            String direction = node_p.getSafeTextValue("direction", "BOTH");
            try {
                this.split = OwObjectLinkRelation.valueOf((String)direction);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Invalid direction element value in confiuration of document function with ID=" + this.getPluginID()), (Throwable)e);
            }
            this.linkClassNames = node_p.getSafeStringList("linkclasses");
            this.documentFunctionIds = node_p.getSafeStringList("DocumentFunctionPlugins");
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owlink/show_links.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owlink/show_links_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            LOG.debug((Object)"OwDocumentFunctionShowLinks.onClickEvent(): the edit function is not enabled for the given object !");
            throw new OwInvalidOperationException(new OwString("owdocprops.show.links.function.invalid.invalid.object", "Can not display links for this item."));
        }
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    protected OwShowLinksDialog createShowLinksDialog(List<OwObject> enabledObjects, boolean typedList, Collection<String> linkClassNames, OwObjectLinkRelation relation, List<String> documentFunctionIds) {
        OwObjectLinksDocument document = new OwObjectLinksDocument(relation, linkClassNames, documentFunctionIds);
        Object view = typedList ? new OwReferencedObjectTypedLinksView(document) : new OwReferencedObjectAllLinksView(document);
        return new OwShowLinksDialog(enabledObjects, (OwObjectLinksView)view);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        LinkedList<OwObject> enabledObjects = new LinkedList<OwObject>();
        for (OwObject objectToEdit : objects_p) {
            if (!this.isEnabled(objectToEdit, oParent_p, 2)) continue;
            enabledObjects.add(objectToEdit);
        }
        if (enabledObjects.isEmpty()) {
            LOG.error((Object)"OwDocumentFunctionShowLinks.onMultiselectClickEvent(): Invalid object collection!The enabled objects collection is empty!");
            throw new OwInvalidOperationException(new OwString("owdocprops.show.links.function.invalid.object.collection", "Invalid object collection!"));
        }
        OwShowLinksDialog dlg = this.createShowLinksDialog(enabledObjects, this.displayTypedList, this.linkClassNames, this.split, this.documentFunctionIds);
        dlg.setTitle(this.getPluginTitle());
        dlg.setColumnNames(this.getConfiguredColumns());
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
    }

    private List<String> getConfiguredColumns() {
        LinkedList<String> columns = (LinkedList<String>)this.getSafeSetting(SETTINGS_COLUMN_INFO, null);
        if (columns == null) {
            columns = new LinkedList<String>();
            columns.add(OwResource.m_ObjectNamePropertyClass.getClassName());
        }
        return columns;
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
    }
}

