/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.ownew;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwToolExtension;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwNewDocument
extends OwMasterDocument {
    private static final Logger LOG = OwLog.getLogger(OwNewDocument.class);
    protected static final String CONFIG_NODE_EXTENSIONS = "Extensions";
    protected static final String CONFIG_NODE_EXTENSION = "Extension";
    protected static final String CONFIG_NODE_CLASSNAME = "ClassName";
    private List m_newExtensions = new ArrayList();

    protected void init() throws Exception {
        super.init();
        Node extensionsNode = this.getConfigNode().getSubNode(CONFIG_NODE_EXTENSIONS);
        if (extensionsNode != null) {
            OwStandardXMLUtil extensionsNodeUtil = new OwStandardXMLUtil(extensionsNode);
            List extensionUtilList = extensionsNodeUtil.getSafeUtilList(CONFIG_NODE_EXTENSION);
            for (OwXMLUtil extensionNodeUtil : extensionUtilList) {
                OwXMLUtil extensionClassNameNodeUtil = extensionNodeUtil.getSubUtil(CONFIG_NODE_CLASSNAME);
                String extensionClassName = extensionClassNameNodeUtil.getSafeTextValue(null);
                if (extensionClassName != null) {
                    String pluginId;
                    try {
                        Class<?> extensionClass = Class.forName(extensionClassName);
                        if (!OwToolExtension.class.isAssignableFrom(extensionClass)) {
                            pluginId = this.getPluginID();
                            LOG.error((Object)("OwNewDocument.init : Invalid new-extension class name in plugin with ID  " + pluginId + " : " + extensionClassName + " is not an OwNewExtension!"));
                            throw new OwConfigurationException(this.getContext().localize("ownew.OwNewDocument.invalidextension", "Invalid new-extension class name in plugin with ID  ") + pluginId + " : " + extensionClassName);
                        }
                        Constructor<?> defaultConstructor = extensionClass.getConstructor(new Class[0]);
                        OwToolExtension extension = (OwToolExtension)defaultConstructor.newInstance(new Object[0]);
                        extension.init(extensionNodeUtil, (OwMainAppContext)this.getContext());
                        this.m_newExtensions.add(extension);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("OwNewDocument.init : new-extension intialized - " + extension.getClass().getName()));
                        continue;
                    }
                    catch (OwConfigurationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        pluginId = this.getPluginID();
                        LOG.error((Object)("OwNewDocument.init : Invalid new-extension class name in plugin with ID  " + pluginId + " : " + extensionClassName), (Throwable)e);
                        throw new OwConfigurationException(this.getContext().localize("ownew.OwNewDocument.invalidextension", "Invalid new-extension class name in plugin with ID  ") + pluginId + " : " + extensionClassName, (Throwable)e);
                    }
                }
                String pluginId = this.getPluginID();
                LOG.error((Object)("OwNewDocument.init : Invalid new-extension class name in plugin with ID  " + pluginId));
                throw new OwConfigurationException(this.getContext().localize("ownew.OwNewDocument.invalidextension", "Invalid new-extension class name in plugin with ID  ") + pluginId);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No new-extensions defined for \"new\" plugin with ID : " + this.getPluginID()));
        }
    }

    public Collection getExtensions() {
        return this.m_newExtensions;
    }
}

