/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsettings;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwPlugin;
import com.wewebu.ow.server.app.OwSettings;
import com.wewebu.ow.server.app.OwSettingsSet;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.plug.owsettings.OwSettingsSetView;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwView;
import java.util.List;

public class OwSettingsView
extends OwMasterView {
    private OwSubLayout m_Layout = new OwSubLayout();
    protected OwConfiguration m_Configuration;
    protected OwSubNavigationView m_SubNavigation;
    protected OwSettings m_Settings;

    protected void init() throws Exception {
        super.init();
        this.m_Configuration = ((OwMainAppContext)this.getContext()).getConfiguration();
        this.m_Settings = ((OwMainAppContext)this.getContext()).getSettings();
        this.addView((OwView)this.m_Layout, null);
        this.m_SubNavigation = new OwSubNavigationView();
        this.m_Layout.addView((OwView)this.m_SubNavigation, 0, null);
        this.m_Layout.addViewReference(this.m_SubNavigation.getViewReference(), 2);
        OwSettingsSetView setView = this.createSettingsSetView();
        boolean fAdmin = ((OwMainAppContext)this.getContext()).isAllowed(6, "owcaneditsitesettings");
        for (OwSettingsSet settingsInfo : this.m_Settings.getCollection()) {
            if (!settingsInfo.hasUserEditableProperties() && (!fAdmin || !settingsInfo.hasAppEditableProperties())) continue;
            String sImage = null;
            if (settingsInfo != ((OwMainAppContext)this.getContext()).getConfiguration().getAppSettings()) {
                try {
                    OwPlugin plugin = ((OwMainAppContext)this.getContext()).getConfiguration().getAllowedPluginInstance(settingsInfo.getName());
                    sImage = plugin.getIcon();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.m_SubNavigation.addView((OwView)setView, settingsInfo.getDisplayName(), null, sImage, (Object)settingsInfo, null);
        }
        this.m_SubNavigation.navigate(0);
    }

    protected OwSettingsSetView createSettingsSetView() {
        return new OwSettingsSetView();
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        if (((OwMainAppContext)this.getContext()).getCurrentMasterView() != null) {
            List tabList = this.m_SubNavigation.getTabList();
            for (int i = 0; i < tabList.size(); ++i) {
                OwNavigationView.OwTabInfo menuTabInfo = (OwNavigationView.OwTabInfo)tabList.get(i);
                OwSettingsSet settingsInfo = (OwSettingsSet)menuTabInfo.getReasonObject();
                if (null == settingsInfo || !settingsInfo.getName().equals(((OwMainAppContext)this.getContext()).getCurrentMasterView().getPluginID())) continue;
                this.m_SubNavigation.navigate(i);
                break;
            }
        }
        super.onActivate(iIndex_p, oReason_p);
    }

    private boolean isDynamicSplitUsed() {
        return this.getConfigNode().getSafeBooleanValue("UseDynamicSplit", false);
    }
}

