/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owshortcut.OwSavedSearchWrapper;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwSavedSearchesView
extends OwView {
    private static final int NO_SORTED_COLUMN_ID = -1;
    private static final Logger LOG = OwLog.getLogger(OwSavedSearchesView.class);
    private static final String KEY_SEARCH_PLUGIN_ID = "SearchPluginId";
    private String m_searchPluginId;
    private List m_savedSearchesList = new ArrayList();
    private OwSortableColumn m_templateNameColumn;
    private OwSortableColumn m_savedNameColumn;
    private int m_sortColumnId = -1;
    private int m_defaultSortOrder;
    private Comparator m_defaultComparator;
    private boolean m_changeSortOrder = false;
    private static final Comparator TEMPLATE_ORDER = new Comparator(){

        public int compare(Object e1_p, Object e2_p) {
            return ((OwSavedSearchWrapper)e2_p).getSearchTemplateName().compareTo(((OwSavedSearchWrapper)e1_p).getSearchTemplateName());
        }
    };
    private static final Comparator SAVENAME_ORDER = new Comparator(){

        public int compare(Object e1_p, Object e2_p) {
            return ((OwSavedSearchWrapper)e2_p).getSavedSearch().compareTo(((OwSavedSearchWrapper)e1_p).getSavedSearch());
        }
    };

    protected void init() throws Exception {
        super.init();
        String documentId = this.getDocument().getID();
        OwXMLUtil pluginXML = ((OwMainAppContext)this.getContext()).getConfiguration().getPlugin(documentId.substring(0, documentId.length() - 4));
        if (pluginXML.getSubUtil(KEY_SEARCH_PLUGIN_ID) == null || pluginXML.getSubUtil(KEY_SEARCH_PLUGIN_ID).getSafeTextValue(null) == null) {
            String msg = "The mandatory plugin Id of the Search plugin that is linked with the Favorites Plugin, is missing. (Favorites Plugin, XML tag: SearchPluginId, default value: com.wewebu.ow.Search)";
            LOG.error((Object)("OwSaveSearchView.init: " + msg));
            throw new OwConfigurationException(this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.invalidsearchplugin", "The plugin Id of the Search plugin is missing from the Favorites plugin configuration. (Favorites Plugin, XML tag: SearchPluginId, default value: com.wewebu.ow.Search)"));
        }
        this.m_searchPluginId = pluginXML.getSubUtil(KEY_SEARCH_PLUGIN_ID).getSafeTextValue(null);
        this.m_savedNameColumn = new OwSortableColumn(1, this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.name", "Name"), 0);
        this.m_templateNameColumn = new OwSortableColumn(2, this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.templatename", "Search Template Name"), 0);
        this.updateList();
    }

    protected void onRender(Writer w_p) throws Exception {
        this.updateList();
        if (this.m_savedSearchesList == null || this.m_savedSearchesList.size() < 1) {
            w_p.write("<p class=\"OwEmptyTextMessage\">" + this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.noelements", "No favorites found.") + "</p>");
        } else {
            this.sortList(this.m_sortColumnId);
            String tableTitle = this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.tableTitle", "This table containts saved searches list");
            String tableCaption = this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.tableCaption.searches", "This table containts saved searches list");
            w_p.write("<table summary='" + tableTitle + "' class='OwGeneralList_table OwStoredSearches'>");
            w_p.write("<caption>" + tableCaption + "</caption>");
            w_p.write("<thead><tr class='OwGeneralList_header'><th class='a1'>");
            this.renderPropertyColumnHeader(w_p, this.m_savedNameColumn);
            w_p.write("</th><th class='a2'>");
            this.renderPropertyColumnHeader(w_p, this.m_templateNameColumn);
            w_p.write("&nbsp;</th><th  class='a3'>");
            w_p.write(this.getContext().localize("plugin.owshortcut.OwSavedSearchesView.functions", "Functions"));
            w_p.write("</tr></thead>");
            int index = 0;
            String deleteTooltip = this.getContext().localize("plug.owsearch.OwSearchTemplateView.deletesearchtooltip", "Delete saved search");
            String openTooltip = this.getContext().localize("plug.owsearch.OwSearchTemplateView.opensearchtooltip", "Open Search");
            String deleteIcon = this.getDeleteIcon();
            for (OwSavedSearchWrapper savedSearch : this.m_savedSearchesList) {
                w_p.write(index % 2 == 0 ? "<tr class=\"OwGeneralList_RowEven\">" : "<tr class=\"OwGeneralList_RowOdd\">");
                w_p.write("<td class=\"a1\">");
                w_p.write("<a class=\"OwMimeItem\" href=\"");
                String encodedSavedSearch = OwHTMLHelper.encodeToSecureHTML((String)savedSearch.getSavedSearch());
                StringBuilder buffer = new StringBuilder();
                buffer.append("savedSearchIndex").append("=").append(Integer.toString(index));
                buffer.append("&templateName").append("=").append(savedSearch.getSearchTemplateName());
                w_p.write(this.getEventURL("Execute", OwHTMLHelper.encodeToSecureHTML((String)buffer.toString())));
                w_p.write("\" title=\"");
                w_p.write(openTooltip);
                w_p.write("\">");
                w_p.write(encodedSavedSearch);
                w_p.write("</a>");
                w_p.write("</td>");
                w_p.write("<td class=\"a2\">");
                OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)savedSearch.getSearchTemplateDisplayName());
                w_p.write("</td>");
                w_p.write("<td class=\"a3\">&nbsp;");
                w_p.write("<a href=\"");
                w_p.write(this.getEventURL("DeleteSearch", OwHTMLHelper.encodeToSecureHTML((String)buffer.toString())));
                w_p.write("\" title=\"");
                w_p.write(deleteTooltip);
                w_p.write("\"><img src=\"");
                w_p.write(deleteIcon);
                w_p.write("\" ");
                String deleteTooltipCustomized = this.getContext().localize1("plug.owsearch.OwSearchTemplateView.deletesearchtooltipforname", "Delete saved search %1", encodedSavedSearch);
                w_p.write("alt=\"");
                w_p.write(deleteTooltipCustomized);
                w_p.write("\" title=\"");
                w_p.write(deleteTooltipCustomized);
                w_p.write("\"/></a>");
                w_p.write("</td>");
                w_p.write("</tr>");
                ++index;
            }
            w_p.write("</table>");
        }
    }

    protected String getDeleteIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/deletebtn.png";
    }

    public void onDeleteSearch(HttpServletRequest request_p) throws Exception {
        String templateName = request_p.getParameter("templateName");
        String indexString = request_p.getParameter("savedSearchIndex");
        int index = Integer.parseInt(indexString);
        OwSavedSearchWrapper savedSearchWrapp = (OwSavedSearchWrapper)this.m_savedSearchesList.get(index);
        String savedSearch = savedSearchWrapp.getSavedSearch();
        Collection searchTemplates = this.getSearchTemplates();
        for (OwSearchTemplate searchTemplate : searchTemplates) {
            searchTemplate.isInitalized();
            if (!templateName.equals(searchTemplate.getName())) continue;
            searchTemplate.deleteSavedSearch(savedSearch);
        }
    }

    public void onExecute(HttpServletRequest request_p) throws Exception {
        String indexString = request_p.getParameter("savedSearchIndex");
        int index = Integer.parseInt(indexString);
        OwSavedSearchWrapper savedSearchWrapp = (OwSavedSearchWrapper)this.m_savedSearchesList.get(index);
        String savedSearch = savedSearchWrapp.getSavedSearch();
        String templateName = request_p.getParameter("templateName");
        OwMasterDocument searchplugin = (OwMasterDocument)this.getContext().getEventTarget(this.m_searchPluginId + ".Doc");
        if (null == searchplugin) {
            LOG.error((Object)"OwRemoteControlDocument.onExternalRequest: CONTROL_EVENT_SEARCH: No Masterplugin handler defined for given object in frontcontroller OwRemoteControlDocument.");
        }
        searchplugin.dispatch(16, (Object)templateName, (Object)savedSearch);
        searchplugin.getMasterView().activate();
    }

    private void renderPropertyColumnHeader(Writer w_p, OwSortableColumn column_p) throws Exception {
        w_p.write("<a href=\"");
        w_p.write(this.getEventURL("Sort", "sortField=" + column_p.getColumnId()));
        w_p.write("\" title=\"");
        String text = OwString.localize2((Locale)this.getContext().getLocale(), (String)"app.OwObjectListView.sortTooltip", (String)"Sort %1 %2 ", (String)column_p.getColumnTitle(), (String)this.getSortOrderType(column_p.getSortInfo()));
        w_p.write(text);
        w_p.write("\" class=\"OwGeneralList_sort\">");
        w_p.write(column_p.getColumnTitle());
        w_p.write("&nbsp;&nbsp;&nbsp;&nbsp;");
        w_p.write("&nbsp;<img class=\"OwGeneralList_sortimg\" alt=\"" + text + "\" title=\"");
        w_p.write(text);
        w_p.write("\" border=\"0\" src=\"");
        w_p.write(this.getSortOrderImage(column_p.getSortInfo()));
        w_p.write("\">");
        w_p.write("</a>");
    }

    protected String getSortOrderType(int sortInfo_p) throws Exception {
        String sortOrderType = this.getContext().localize("app.OwObjectListView.sorting.ascending", "Ascending");
        String ascending = this.getContext().localize("app.OwObjectListView.sorting.ascending", "Ascending");
        String descending = this.getContext().localize("app.OwObjectListView.sorting.descending", "Descending");
        if (sortInfo_p == 0) {
            return sortOrderType;
        }
        if (sortInfo_p == 1) {
            return descending;
        }
        if (sortInfo_p == 2) {
            return ascending;
        }
        return sortOrderType;
    }

    protected String getSortOrderImage(int sortInfo_p) throws Exception {
        if (sortInfo_p == 1) {
            return this.getContext().getDesignURL() + "/images/OwObjectListView/sortasc.png";
        }
        if (sortInfo_p == 2) {
            return this.getContext().getDesignURL() + "/images/OwObjectListView/sortdesc.png";
        }
        return this.getContext().getDesignURL() + "/images/OwObjectListView/nosort.png";
    }

    public void onSort(HttpServletRequest request_p) throws Exception {
        this.m_sortColumnId = Integer.parseInt(request_p.getParameter("sortField"));
        this.m_changeSortOrder = true;
    }

    private void sortList(int sortColumnId_p) {
        if (sortColumnId_p != -1) {
            if (this.m_changeSortOrder) {
                if (sortColumnId_p == this.m_savedNameColumn.getColumnId()) {
                    Collections.sort(this.m_savedSearchesList, SAVENAME_ORDER);
                    if (this.m_savedNameColumn.getSortInfo() == 1) {
                        this.m_savedNameColumn.setSortInfo(2);
                        this.m_defaultSortOrder = 2;
                    } else {
                        Collections.reverse(this.m_savedSearchesList);
                        this.m_savedNameColumn.setSortInfo(1);
                        this.m_defaultSortOrder = 1;
                    }
                    this.m_templateNameColumn.setSortInfo(0);
                    this.m_defaultComparator = SAVENAME_ORDER;
                } else if (sortColumnId_p == this.m_templateNameColumn.getColumnId()) {
                    Collections.sort(this.m_savedSearchesList, TEMPLATE_ORDER);
                    if (this.m_templateNameColumn.getSortInfo() == 1) {
                        this.m_templateNameColumn.setSortInfo(2);
                        this.m_defaultSortOrder = 2;
                    } else {
                        Collections.reverse(this.m_savedSearchesList);
                        this.m_templateNameColumn.setSortInfo(1);
                        this.m_defaultSortOrder = 1;
                    }
                    this.m_savedNameColumn.setSortInfo(0);
                    this.m_defaultComparator = TEMPLATE_ORDER;
                }
                this.m_changeSortOrder = false;
            } else {
                this.defaultSort(this.m_defaultComparator, this.m_defaultSortOrder);
            }
        }
    }

    public void defaultSort(Comparator defaultComparator_p, int sortOrder_p) {
        if (sortOrder_p == 1) {
            Collections.sort(this.m_savedSearchesList, defaultComparator_p);
            Collections.reverse(this.m_savedSearchesList);
        } else {
            Collections.sort(this.m_savedSearchesList, defaultComparator_p);
        }
    }

    private void updateList() throws Exception {
        this.m_savedSearchesList.clear();
        Collection searchTemplates = null;
        searchTemplates = this.getSearchTemplates();
        for (OwSearchTemplate searchTemplate : searchTemplates) {
            String templateName = searchTemplate.getName();
            String templateDisplayName = searchTemplate.getDisplayName(this.getContext().getLocale());
            Collection result = null;
            try {
                result = searchTemplate.getSavedSearches();
            }
            catch (OwObjectNotFoundException e) {
                // empty catch block
            }
            if (result == null) continue;
            for (String savedName : result) {
                this.m_savedSearchesList.add(new OwSavedSearchWrapper(templateName, templateDisplayName, savedName));
            }
        }
    }

    protected Collection getSearchTemplates() throws Exception {
        OwXMLUtil pluginXML = ((OwMainAppContext)this.getContext()).getConfiguration().getPlugin(this.m_searchPluginId);
        Iterator itReps = pluginXML.getSafeNodeList("SearchTemplates").iterator();
        Vector<OwSearchTemplate> searchTemplates = new Vector<OwSearchTemplate>();
        while (itReps.hasNext()) {
            OwStandardXMLUtil repositoryNode = new OwStandardXMLUtil((Node)itReps.next());
            String repName = repositoryNode.getSafeStringAttributeValue("repname", null);
            OwRepository repository = (OwRepository)this.getRepositories().get(repName);
            if (repository == null) {
                String msg = "OwShortCutDocument.init: Repository is not existing, name = " + repName;
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.repositorynotdefined", "Das Repository existiert nicht:") + " " + repName);
            }
            String strSearchTemplates = repositoryNode.getNode().getFirstChild().getNodeValue();
            if (strSearchTemplates == null) {
                String msg = "OwShortCutDocument.init: Search template category has not been defined at the Search Plugin.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.templatesnotdefined", "Es wurde keine Suchtemplatekategory im Suchen Plugin definiert."));
            }
            Collection SearchTemplateObjects = ((OwMainAppContext)this.getContext()).getNetwork().getApplicationObjects(3, strSearchTemplates, false);
            if (SearchTemplateObjects == null) continue;
            for (OwSearchTemplate searchtemplate : SearchTemplateObjects) {
                try {
                    if (!((OwMainAppContext)this.getContext()).isAllowed(5, searchtemplate.getName())) continue;
                    searchTemplates.add(searchtemplate);
                }
                catch (Exception e) {
                    String msg = "OwShortCutDocument.init: Search form could not be loaded, SearchTemplate = " + searchtemplate.getName();
                    LOG.error((Object)msg, (Throwable)e);
                    throw new OwConfigurationException(this.getContext().localize1("owsearch.OwSearchDocument.searchtemplateload_failed", "Das Suchformular konnte nicht geladen werden: %1", searchtemplate.getName()), (Throwable)e);
                }
            }
        }
        return searchTemplates;
    }

    protected Map getRepositories() {
        HashMap<String, Object> repositories = new HashMap<String, Object>();
        repositories.put("OW_HISTORY", ((OwMainAppContext)this.getContext()).getHistoryManager());
        repositories.put("OW_ECM_ADAPTER", ((OwMainAppContext)this.getContext()).getNetwork());
        return repositories;
    }

    public class OwSortableColumn {
        private String m_columnTitle;
        private int m_columnId;
        private static final int NOT_SORTED = 0;
        private static final int ASCENDING_SORT = 1;
        private static final int DESCENDING_SORT = 2;
        private int m_SortInfo;

        public OwSortableColumn(int columnID_p, String columnTitle_p, int sortInfo_p) {
            this.m_columnId = columnID_p;
            this.m_columnTitle = columnTitle_p;
            this.m_SortInfo = sortInfo_p;
        }

        public String getColumnTitle() {
            return this.m_columnTitle;
        }

        public void setColumnTitle(String columnTitle_p) {
            this.m_columnTitle = columnTitle_p;
        }

        public int getColumnId() {
            return this.m_columnId;
        }

        public void setColumnId(int columnId_p) {
            this.m_columnId = columnId_p;
        }

        public int getSortInfo() {
            return this.m_SortInfo;
        }

        public void setSortInfo(int sortInfo_p) {
            this.m_SortInfo = sortInfo_p;
        }
    }
}

