/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocument;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwShortCutDocumentFunction
extends OwDocumentFunction {
    private static final Logger LOG = OwLog.getLogger(OwShortCutDocumentFunction.class);
    private OwShortCutDocument m_favoritePlugin = null;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_favoritePlugin = (OwShortCutDocument)this.getFavoriteMasterPlugin();
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocshortcut/bookmark_add.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocshortcut/bookmark_add_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        Vector<OwObject> objects = new Vector<OwObject>();
        objects.add(oObject_p);
        this.m_favoritePlugin.addOwObjectShortCuts(objects);
        this.addHistoryEvent(oObject_p, oParent_p, 1, 1);
        this.getContext().postMessage(this.getContext().localize("plug.owshortcut.OwShortCutDocumentFunction.addedfavourite", "The selected object has been added to the favorites."));
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        this.m_favoritePlugin.addOwObjectShortCuts(objects_p);
        this.getContext().postMessage(this.getContext().localize("plug.owshortcut.OwShortCutDocumentFunction.addedfavourites", "The selected objects have been added to the favorites."));
        this.addHistoryEvent(objects_p, oParent_p, 1, 1);
    }

    public OwMasterDocument getFavoriteMasterPlugin() throws OwConfigurationException {
        String sEventTargetID = null;
        OwMasterDocument masterPlugin = null;
        try {
            Node useMasterPluginNode = this.getConfigNode().getSubNode("UsedMasterPluginID");
            if (null != useMasterPluginNode) {
                sEventTargetID = useMasterPluginNode.getFirstChild().getNodeValue() + ".Doc";
                masterPlugin = (OwMasterDocument)this.getContext().getEventTarget(sEventTargetID);
            } else {
                masterPlugin = this.searchMasterPluginFromClassName();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("OwRecordFunctionShortcut.getFavoriteMasterPlugin: Cannot find the event target for ID: " + sEventTargetID), (Throwable)e);
        }
        return masterPlugin;
    }

    public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
        if (null == this.m_favoritePlugin) {
            return false;
        }
        return super.isEnabled(object_p, parent_p, context_p);
    }

    private OwMasterDocument searchMasterPluginFromClassName() {
        List all = this.getContext().getConfiguration().getMasterPlugins(true);
        OwMasterDocument ret = null;
        if (all != null) {
            for (OwConfiguration.OwMasterPluginInstance inst : all) {
                if (!(inst.getDocument() instanceof OwShortCutDocument)) continue;
                ret = inst.getDocument();
                break;
            }
        }
        return ret;
    }
}

