/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardUnresolvedReference;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocument;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItem;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemContext;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemOwObject;
import com.wewebu.ow.server.plug.owshortcut.OwShortcutDocumentEventListner;
import com.wewebu.ow.server.plug.owshortcut.OwShortcutItemUnresolved;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwShortCutItemView
extends OwView
implements OwShortCutItemContext,
OwObjectListView.OwObjectListViewEventListner,
OwShortcutDocumentEventListner {
    private static final Logger LOG = OwLog.getLogger(OwShortCutItemView.class);
    public static final int SHORTCUT_ITEM_FILTER_ALL = 0;
    public static final int SHORTCUT_ITEM_FILTER_DOCUMENTS = 1;
    public static final int SHORTCUT_ITEM_FILTER_FOLDERS = 2;
    public static final int SHORTCUT_ITEM_FILTER_REST = 3;
    private static final String SHORTCUT_ITEM_ID_KEY = "scid";
    private int m_filter;
    private OwObjectListView m_listView = null;
    private Map m_objectInstanceToShortcut = new HashMap();
    private List<OwShortCutItem> m_nonObjectShortcuts = new LinkedList<OwShortCutItem>();
    private OwSort m_objectListSort;
    private OwMimeManager m_MimeManager = this.createOwMimeManager();

    protected OwMimeManager createOwMimeManager() {
        return new OwMimeManager();
    }

    protected void onActivate(int index_p, Object reason_p) throws Exception {
        super.onActivate(index_p, reason_p);
        if (reason_p != null) {
            this.m_filter = (Integer)reason_p;
        }
    }

    protected void init() throws Exception {
        super.init();
        this.m_listView = this.createObjectListView();
        this.m_listView.setEventListner((OwObjectListView.OwObjectListViewEventListner)this);
        this.m_listView.setExternalFormTarget(this.getFormTarget());
        this.m_objectListSort = this.getShortcutDocument().getColumnSortCriteria();
        this.applyConfiguration(this.m_listView);
        this.m_listView.attach(this.getContext(), null);
        this.enableFunctions(this.m_listView);
        this.m_listView.setExternalFormTarget((OwEventTarget)this.m_listView);
        this.m_MimeManager.attach(this.getContext(), null);
        OwShortCutDocument document = this.getShortcutDocument();
        document.addEventListener(this);
    }

    public OwShortCutDocument getShortcutDocument() {
        return (OwShortCutDocument)this.getDocument();
    }

    protected void applyConfiguration(OwObjectListView listView_p) throws Exception {
        listView_p.setViewMask(69);
        OwShortCutDocument document = (OwShortCutDocument)this.getDocument();
        Collection columninfo = document.getDefaultColumnInfo();
        if (this.m_objectListSort != null) {
            listView_p.setSort(this.m_objectListSort);
        }
        listView_p.setColumnInfo(columninfo);
        listView_p.setStickyFooterInUse(false);
        listView_p.attach(this.getContext(), null);
    }

    protected OwShortCutItem getShortcutForObject(OwObject object_p) {
        return (OwShortCutItem)this.m_objectInstanceToShortcut.get(new OwInstanceMapKey(object_p));
    }

    protected OwObjectListView createObjectListView() throws Exception {
        return new OwObjectListViewRow(){

            protected OwMimeManager createMimeManager() {
                return new OwMimeManager(){

                    public void insertTextLink(Writer w_p, String strDisplayName_p, OwObjectReference obj_p) throws Exception {
                        OwObject object = obj_p.getInstance();
                        OwShortCutItem shortCutItem = OwShortCutItemView.this.getShortcutForObject(object);
                        if (shortCutItem != null) {
                            shortCutItem.insertLabel(OwShortCutItemView.this, w_p);
                        } else {
                            super.insertTextLink(w_p, strDisplayName_p, obj_p);
                        }
                    }

                    public void insertIconLink(Writer w_p, OwObjectReference obj_p) throws Exception {
                        OwObject object = obj_p.getInstance();
                        OwShortCutItem shortCutItem = OwShortCutItemView.this.getShortcutForObject(object);
                        if (shortCutItem != null) {
                            shortCutItem.insertIcon(OwShortCutItemView.this, w_p);
                        } else {
                            super.insertIconLink(w_p, obj_p);
                        }
                    }
                };
            }
        };
    }

    private void enableFunctions(OwObjectListView listView_p) throws Exception {
        LinkedList<OwDocumentFunction> enabledDocumentFunctions = new LinkedList<OwDocumentFunction>();
        OwShortCutDocument document = (OwShortCutDocument)this.getDocument();
        List bookmarkFunctionIDs = document.getShortcutFunctionIDs();
        if (bookmarkFunctionIDs != null) {
            for (String id : bookmarkFunctionIDs) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                OwDocumentFunction function = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                enabledDocumentFunctions.add(function);
            }
        }
        OwDeleteShortcutFunction m_delAttachmentFunction = new OwDeleteShortcutFunction();
        m_delAttachmentFunction.init((OwXMLUtil)new OwStandardXMLUtil(), (OwMainAppContext)this.getContext());
        enabledDocumentFunctions.add(m_delAttachmentFunction);
        listView_p.setDocumentFunctionPluginList(enabledDocumentFunctions);
    }

    public void onRemove(HttpServletRequest request_p) throws Exception {
        String id = request_p.getParameter(SHORTCUT_ITEM_ID_KEY);
        id = OwAppContext.decodeURL((String)id);
        ((OwShortCutDocument)this.getDocument()).deleteShortCut(id);
    }

    public void detach() {
        this.getShortcutDocument().removeEventListener(this);
        super.detach();
        this.m_MimeManager.detach();
        this.m_listView.detach();
    }

    public String getDeleteIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/plug/owdocshortcut/bookmark_delete.png";
    }

    public String getUnkownMimeIcon() throws Exception {
        return this.getContext().getDesignURL() + "/micon/unknown.png";
    }

    protected void onRender(Writer w_p) throws Exception {
        this.m_MimeManager.reset();
        this.refreshDisplayedShortcuts(this.getShortcutDocument());
        String deletetitle = this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.remove", "Delete bookmark");
        if (this.m_objectInstanceToShortcut.size() < 1 && this.m_nonObjectShortcuts.size() < 1) {
            w_p.write("<p class=\"OwEmptyTextMessage\">" + this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.noelements", "No favorites found") + "</p>");
        } else {
            if (this.m_objectInstanceToShortcut.size() > 0) {
                w_p.write("<div style='floaf:left;'>");
                this.m_listView.render(w_p);
                w_p.write("</div>");
            }
            if (this.m_nonObjectShortcuts.size() > 0) {
                w_p.write("<h3 class=\"OwInvalidText\">");
                w_p.write(this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.invalidfavorites", "Invalid Favorites"));
                w_p.write("</h3><table class=\"OwGeneralList_table\"><caption>");
                w_p.write(this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.tableCaption", "Table of favorites"));
                w_p.write("</caption><thead><tr class=\"OwGeneralList_header\"><td>&nbsp;</td><td>");
                w_p.write(this.getContext().localize("plugin.owshortcut.OwShortCutView.name", "Name"));
                w_p.write("</td><td>");
                w_p.write("&nbsp;");
                w_p.write("</td><td width='80%'>&nbsp;</td></tr></thead>");
                for (int i = 0; i < this.m_nonObjectShortcuts.size(); ++i) {
                    OwShortCutItem item = this.m_nonObjectShortcuts.get(i);
                    if (this.isItemFiltered(item)) continue;
                    w_p.write("<tr class=\"OwGeneralList_");
                    w_p.write(i % 2 == 0 ? "RowEven" : "RowOdd");
                    w_p.write("\"><td>");
                    try {
                        item.insertIcon(this, w_p);
                    }
                    catch (OwException e) {
                        w_p.write("<a title=\"");
                        String tooltip = this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.invaliddocument", "Invalid document");
                        w_p.write(tooltip);
                        w_p.write("\"><img src=\"");
                        w_p.write(this.getUnkownMimeIcon());
                        w_p.write("\" border=\"0\"");
                        w_p.write(" alt=\"");
                        w_p.write(tooltip);
                        w_p.write("\" title=\"");
                        w_p.write(tooltip);
                        w_p.write("\"/></a>");
                    }
                    w_p.write("</td>");
                    w_p.write("<td nowrap>");
                    try {
                        item.insertLabel(this, w_p);
                    }
                    catch (OwException e) {
                        w_p.write(this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.alreadydeleted", "The document has already been deleted from the system."));
                    }
                    w_p.write("</td>");
                    w_p.write("<td nowrap>&nbsp;<a title=\"");
                    w_p.write(deletetitle);
                    w_p.write("\" href=\"");
                    String id = OwAppContext.encodeURL((String)item.getId());
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(SHORTCUT_ITEM_ID_KEY).append("=").append(id);
                    w_p.write(this.getEventURL("Remove", buffer.toString()));
                    w_p.write("\"><img alt=\"");
                    w_p.write(deletetitle);
                    w_p.write("\" title=\"");
                    w_p.write(deletetitle);
                    w_p.write("\" src=\"");
                    w_p.write(this.getDeleteIcon());
                    w_p.write("\"></a>");
                    w_p.write("</td><td>&nbsp;</td>");
                    w_p.write("</tr>");
                }
                w_p.write("</table>");
            }
        }
    }

    protected void createShortcutsStructures(OwShortCutDocument document_p, Map objectShortcuts_p, List nonObjectShortcuts_p) throws Exception {
        objectShortcuts_p.clear();
        nonObjectShortcuts_p.clear();
        List shortcuts = document_p.getShortCutItems();
        for (OwShortCutItem item : shortcuts) {
            if (this.isItemFiltered(item)) continue;
            if (item instanceof OwShortCutItemOwObject) {
                OwObjectReference objectReference = ((OwShortCutItemOwObject)item).getObjRef();
                if (objectReference != null) {
                    OwShortcutItemUnresolved urItem;
                    OwStandardUnresolvedReference unresolvedReference;
                    OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
                    String referenceDMSID = "<invalidDMSID>";
                    try {
                        referenceDMSID = objectReference.getDMSID();
                        OwObject object = network.getObjectFromDMSID(referenceDMSID, true);
                        objectShortcuts_p.put(new OwInstanceMapKey(object), item);
                    }
                    catch (OwObjectNotFoundException e) {
                        LOG.debug((Object)("OwShortCutItemView.createShortcutsStructures(): shortcut object with DMSID " + referenceDMSID + " not found!"), (Throwable)e);
                        unresolvedReference = new OwStandardUnresolvedReference((Exception)((Object)e), "Could not display shortcut!", referenceDMSID, item.getName(), "", item.getType());
                        urItem = new OwShortcutItemUnresolved(item.getId(), item.getName(), unresolvedReference);
                        if (this.isItemFiltered(urItem)) continue;
                        nonObjectShortcuts_p.add(urItem);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"OwShortCutItemView.createShortcutsStructures(): shortcut object could not be retrieved for an unknown reason! The object is considered deleted!", (Throwable)e);
                        unresolvedReference = new OwStandardUnresolvedReference(e, "Could not display shortcut!", referenceDMSID, item.getName(), "", item.getType());
                        urItem = new OwShortcutItemUnresolved(item.getId(), item.getName(), unresolvedReference);
                        if (this.isItemFiltered(urItem)) continue;
                        nonObjectShortcuts_p.add(urItem);
                    }
                    continue;
                }
                LOG.debug((Object)("OwShortCutItemView.createShortcutsStructures(): legacy shortcut detected : " + item.toString()));
                nonObjectShortcuts_p.add(item);
                continue;
            }
            nonObjectShortcuts_p.add(item);
        }
    }

    protected boolean isItemFiltered(OwShortCutItem item_p) {
        OwShortcutItemUnresolved obj;
        int type = 0;
        if (item_p instanceof OwShortCutItemOwObject) {
            OwObjectReference obj2 = ((OwShortCutItemOwObject)item_p).getObjRef();
            if (obj2 != null) {
                type = obj2.getType();
            }
        } else if (item_p instanceof OwShortcutItemUnresolved && (obj = (OwShortcutItemUnresolved)item_p) != null) {
            type = obj.getType();
        }
        switch (this.m_filter) {
            case 3: {
                return OwStandardObjectClass.isContentType((int)type) || OwStandardObjectClass.isContainerType((int)type);
            }
            case 1: {
                return !OwStandardObjectClass.isContentType((int)type);
            }
            case 2: {
                return !OwStandardObjectClass.isContainerType((int)type);
            }
        }
        return false;
    }

    @Override
    public OwMimeManager getMimeManager() {
        return this.m_MimeManager;
    }

    public void onObjectListViewFilterChange(OwSearchNode filterNode_p, OwObject parent_p) throws Exception {
    }

    public String onObjectListViewGetRowClassName(int index_p, OwObject obj_p) {
        return null;
    }

    public boolean onObjectListViewItemClick(OwObject obj_p) throws Exception {
        return false;
    }

    public void onObjectListViewSelect(OwObject object_p, OwObject parent_p) throws Exception {
    }

    public void onObjectListViewSort(OwSort newSort_p, String strSortProperty_p) throws Exception {
        this.m_objectListSort = newSort_p;
    }

    protected void refreshDisplayedShortcuts(OwShortCutDocument document_p) throws Exception {
        document_p.refreshShortcuts();
        this.createShortcutsStructures(document_p, this.m_objectInstanceToShortcut, this.m_nonObjectShortcuts);
        OwStandardObjectCollection visibleObjects = new OwStandardObjectCollection();
        Set objectInstanceKeySet = this.m_objectInstanceToShortcut.keySet();
        for (OwInstanceMapKey instanceMapKey : objectInstanceKeySet) {
            OwObject object = instanceMapKey.getObject();
            visibleObjects.add((Object)object);
        }
        if (this.m_objectListSort != null) {
            visibleObjects.sort(this.m_objectListSort);
        }
        this.m_listView.setObjectList((OwObjectCollection)visibleObjects, null);
    }

    @Override
    public void onShortcutDocumentChaged(OwShortCutDocument document_p) {
        try {
            this.refreshDisplayedShortcuts(document_p);
        }
        catch (Exception e) {
            LOG.error((Object)"OwShortCutItemView.onShortcutDocumentChaged(): could not create shortcut structures on document update!", (Throwable)e);
        }
    }

    protected class OwInstanceMapKey {
        private OwObject m_object;

        public OwInstanceMapKey(OwObject object_p) {
            this.m_object = object_p;
        }

        public final OwObject getObject() {
            return this.m_object;
        }

        public int hashCode() {
            try {
                return this.m_object != null ? this.m_object.getDMSID().hashCode() : 0;
            }
            catch (Exception e) {
                LOG.error((Object)"OwDeleteBookmarkFunction.hashCode(): could not create hash code.", (Throwable)e);
                return 0;
            }
        }

        public boolean equals(Object obj_p) {
            if (obj_p instanceof OwInstanceMapKey) {
                OwInstanceMapKey keyObject = (OwInstanceMapKey)obj_p;
                return this.m_object == keyObject.m_object;
            }
            return false;
        }
    }

    public class OwDeleteShortcutFunction
    extends OwDocumentFunction {
        private static final String PLUGIN_ID_PREFIX = "delete.shortcut";
        private String m_pluginID;

        public OwDeleteShortcutFunction() {
            Random random = new Random(System.currentTimeMillis());
            int randomSuffix = random.nextInt(Integer.MAX_VALUE);
            this.m_pluginID = "delete.shortcut." + randomSuffix;
        }

        public String getIcon() throws Exception {
            return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocshortcut/bookmark_delete.png");
        }

        public String getBigIcon() throws Exception {
            return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocshortcut/bookmark_delete_24.png");
        }

        public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
            LinkedList<OwObject> oneObjectList = new LinkedList<OwObject>();
            oneObjectList.add(object_p);
            this.onMultiselectClickEvent(oneObjectList, parent_p, refreshCtx_p);
        }

        public void onMultiselectClickEvent(Collection objects_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
            LinkedList<String> idsToDelete = new LinkedList<String>();
            for (OwObject object : objects_p) {
                OwShortCutItem shrtcutItem = OwShortCutItemView.this.getShortcutForObject(object);
                idsToDelete.add(shrtcutItem.getId());
            }
            OwShortCutItemView.this.getShortcutDocument().deleteShortCuts(idsToDelete);
        }

        protected Set getSupportedObjectTypesFromDescriptor(String strKey_p) throws OwConfigurationException {
            Integer[] supportedObjects = new Integer[]{new Integer(4097), new Integer(8193)};
            return new HashSet<Integer>(Arrays.asList(supportedObjects));
        }

        public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
            return true;
        }

        public boolean getContextMenu() {
            return true;
        }

        public boolean getMultiselect() {
            return true;
        }

        public boolean getObjectInstance() {
            return true;
        }

        public String getPluginTitle() {
            return this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.remove", "Delete favorite");
        }

        public String getTooltip() throws Exception {
            return this.getPluginTitle();
        }

        public String getPluginID() {
            return this.m_pluginID;
        }
    }
}

