/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsearch;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMaxMinButtonControlView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewControl;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owsearch.OwSearchDocument;
import com.wewebu.ow.server.plug.owsearch.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.ui.button.OwImageButtonView;
import com.wewebu.ow.server.ui.button.OwUnifyImageButtonView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwResultListView
extends OwLayout
implements OwClientRefreshContext {
    public static final int OBJECT_LIST_REGION = 1;
    public static final int MIN_MAX_CONTROL_VIEW = 3;
    public static final int OBJECT_LIST_CONTROL_REGION = 6;
    public static final int NEW_SAVED_SEARCH_REGION = 7;
    public static final int NEW_SEARCH_BUTTON_REGION = 8;
    private static final String SAVE_SEARCH_NAME_KEY = "owsavesearch";
    private static final Logger LOG = OwLog.getLogger(OwResultListView.class);
    protected OwSubMenuView m_NewSearchMenuView;
    private OwObjectListViewControl m_listcontrol;
    private OwUnifyImageButtonView buttonView;
    protected OwMaxMinButtonControlView m_MaxMinButtonControlView;

    protected void init() throws Exception {
        List docfunctionsList;
        LinkedHashSet docfunctions;
        super.init();
        this.m_NewSearchMenuView = new OwSubMenuView();
        this.addView((OwView)this.m_NewSearchMenuView, 8, null);
        LinkedList<OwDocumentFunction> filteredDocumentFunctions = null;
        OwXMLUtil documentFunctionsNode = ((OwSearchDocument)this.getDocument()).getDocumentFunctionsNode();
        if (documentFunctionsNode != null && documentFunctionsNode.getSafeBooleanAttributeValue("enable", false) && (docfunctions = new LinkedHashSet(docfunctionsList = documentFunctionsNode.getSafeStringList())).size() != 0) {
            filteredDocumentFunctions = new LinkedList<OwDocumentFunction>();
            for (String id : docfunctions) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                OwDocumentFunction func = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                filteredDocumentFunctions.add(func);
            }
        }
        this.m_listcontrol = this.createObjectListViewControl();
        this.addView((OwView)this.m_listcontrol, 6, null);
        this.m_MaxMinButtonControlView = this.createMaxMinButtonControlView((OwView)this);
        this.addView((OwView)this.m_MaxMinButtonControlView, 3, null);
        if (filteredDocumentFunctions != null && documentFunctionsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_listcontrol.setDocumentFunctionPluginList(filteredDocumentFunctions);
        }
        if (documentFunctionsNode != null && !documentFunctionsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_listcontrol.setDocumentFunctionPluginList(new LinkedList());
        }
        int saveSearchButton = this.m_NewSearchMenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("owsearch.OwResultListView.savesearch", "Save"), "SaveNewSearch", null);
        this.m_NewSearchMenuView.setDefaultMenuItem(saveSearchButton);
        this.buttonView = this.createButtonView();
        this.addView((OwView)this.buttonView, 6, null);
        this.buttonView.addButtonProvider((OwImageButtonView)this.m_listcontrol);
        this.buttonView.setHtmlId(this.m_listcontrol.getHtmlId());
        this.buttonView.getDesignClasses().addAll(this.m_listcontrol.getDesignClasses());
        this.buttonView.addButtonProvider((OwImageButtonView)this.m_MaxMinButtonControlView);
        this.buttonView.getDesignClasses().addAll(this.m_MaxMinButtonControlView.getDesignClasses());
        this.addViewReference(this.m_listcontrol.getViewReference(), 1);
        this.m_listcontrol.setConfigNode(((OwMasterDocument)this.getDocument()).getConfigNode().getSubNode("ResultListViews"));
        this.m_listcontrol.activateListView();
        this.m_listcontrol.getObjectListView().setRefreshContext((OwClientRefreshContext)this);
        this.m_listcontrol.getObjectListView().setExternalFormTarget((OwEventTarget)this);
        this.m_listcontrol.setExternalFormTarget((OwEventTarget)this);
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    public void onSaveNewSearch(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwSearchTemplate searchtemplate = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
        if (null == searchtemplate) {
            return;
        }
        String name = request_p.getParameter(SAVE_SEARCH_NAME_KEY);
        if (null != name && name.length() > 0) {
            searchtemplate.saveSearch(name);
            this.informUserOnSave();
        }
    }

    public OwObjectListView getObjectListView() {
        return this.m_listcontrol.getObjectListView();
    }

    public boolean isRegion(int region_p) {
        switch (region_p) {
            case 7: 
            case 8: {
                try {
                    return ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate().canSaveSearch();
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return super.isRegion(region_p);
    }

    public String getTitle() {
        return this.getContext().localize("plug.owsearch.OwResultListView.title", "Result List");
    }

    public void renderNamedRegion(Writer w_p, String strRegion_p) throws Exception {
        OwObjectCollection objList = this.getObjectListView().getObjectList();
        if (null != objList) {
            w_p.write(objList.getAttribute(strRegion_p).toString());
        }
    }

    public Object getSafeListAttribute(String attributeName_p, Object default_p) {
        OwObjectCollection objectList = this.getObjectListView().getObjectList();
        if (objectList != null) {
            return objectList.getSafeAttribute(attributeName_p, default_p);
        }
        LOG.debug((Object)("OwResultListView.getSafeListAttribute: No object list available for the object list view... returns the default_p value w=" + default_p));
        return default_p;
    }

    public boolean isNamedRegion(String strRegion_p) throws Exception {
        OwObjectCollection objList = this.getObjectListView().getObjectList();
        if (null != objList) {
            return objList.hasAttribute(strRegion_p);
        }
        return false;
    }

    public String getBackToSearchTemplateURL() {
        return this.getEventURL("BackToTemplate", null);
    }

    public boolean getCanGoBackToSearchTemplate() {
        return ((OwSearchDocument)this.getDocument()).canGoBackToSearchTemplate();
    }

    public int getCount() {
        return (Integer)this.getSafeListAttribute("ow_size", 0);
    }

    public boolean getIsComplete() {
        return (Boolean)this.getSafeListAttribute("ow_complete", Boolean.TRUE);
    }

    public void onBackToTemplate(HttpServletRequest request_p) throws Exception {
        ((OwSearchDocument)this.getDocument()).goBackToSearchTemplate();
    }

    public String getTemplateDisplayName() {
        String name = "";
        try {
            name = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate().getDisplayName(this.getContext().getLocale());
        }
        catch (Exception e) {
            String msg = "OwResultListView.getTemplateDisplayName: Can't retrieve display name of current search template.";
            LOG.warn((Object)msg, (Throwable)e);
        }
        return name;
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 7: {
                this.renderNewSavedSearchRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private void renderNewSavedSearchRegion(Writer w_p) throws Exception {
        w_p.write("<div id=\"OwResultListViewSearch\">\n");
        w_p.write("<div>\n");
        w_p.write("<div class='OwPropertyName'>\n");
        w_p.write("<label for='saveTheSearchAsId'>");
        w_p.write(this.getContext().localize("plug.owsearch.OwResultListView.newsavedsearchlabel", "Save the search as:"));
        w_p.write("</label>");
        w_p.write("</div>\n");
        w_p.write("<input id='saveTheSearchAsId' name='");
        w_p.write(SAVE_SEARCH_NAME_KEY);
        w_p.write("' title='");
        w_p.write(this.getContext().localize("plug.owsearch.OwResultListView.newsavedsearchtooltip", "Enter a name for the new search"));
        w_p.write("'/>\n");
        w_p.write("</div>\n");
        w_p.write("</div>\n");
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owsearch/OwResultListView.jsp", w_p);
    }

    public void onClientRefreshContextUpdate(int reason_p, Object param_p) throws Exception {
        switch (reason_p) {
            case 11: {
                Set deleteddmsids = (Set)param_p;
                Iterator it = this.getObjectListView().getObjectList().iterator();
                while (it.hasNext()) {
                    OwObject obj = (OwObject)it.next();
                    if (!deleteddmsids.contains(obj.getDMSID())) continue;
                    it.remove();
                }
                break;
            }
            case 3: {
                OwSearchDocument searchDocument = (OwSearchDocument)this.getDocument();
                searchDocument.repeatLastSearch();
            }
        }
    }

    protected void informUserOnSave() {
        ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("plug.owsearch.OwResultListView.successfullysave", "Your search was successfully saved."));
    }

    public boolean isEnabledStoredSearch() {
        return ((OwSearchDocument)this.getDocument()).getConfigNode().getSafeBooleanValue("EnableStoredSearches", true);
    }

    protected OwObjectListViewControl createObjectListViewControl() {
        return new OwObjectListViewControl();
    }

    protected OwMaxMinButtonControlView createMaxMinButtonControlView(OwView view) {
        return new OwMaxMinButtonControlView(view);
    }

    protected OwUnifyImageButtonView createButtonView() {
        return new OwUnifyImageButtonView();
    }

    protected OwUnifyImageButtonView getButtonView() {
        return this.buttonView;
    }
}

