/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsearch;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owsearch.OwResultListView;
import com.wewebu.ow.server.plug.owsearch.OwSearchDocument;
import com.wewebu.ow.server.plug.owsearch.OwSearchTemplateView;
import com.wewebu.ow.server.plug.owsearch.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OwSearchView
extends OwMasterView {
    private static final Logger LOG = OwLog.getLogger(OwSearchView.class);
    public static final String PERSIST_SEARCHTEMPLATE_ATTRIBUTE_NAME = "OwSearchView_LastTemplate";
    private OwSubLayout m_Layout;
    private OwResultListView m_resultList;
    private OwSubNavigationView m_SubNavigation;
    private OwSearchTemplateView m_searchTemplateView;

    public void navigate(String searchTemplateName_p) throws OwObjectNotFoundException {
        boolean retVal = false;
        List tabs = this.m_SubNavigation.getTabList();
        for (int i = 0; i < tabs.size(); ++i) {
            OwNavigationView.OwTabInfo info = (OwNavigationView.OwTabInfo)tabs.get(i);
            String templateName = (String)info.getReasonObject();
            try {
                if (!searchTemplateName_p.equals(templateName)) continue;
                this.m_SubNavigation.navigate(i);
                retVal = true;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!retVal) {
            LOG.warn((Object)("SearchTemplate " + searchTemplateName_p + " does not exists in current configuration, selection will be kept."));
            throw new OwObjectNotFoundException(this.getContext().localize1("owsearch.OwSearchView.navigate.unknown.searchTemplate", "SearchTemplate named %1 could not be found.", searchTemplateName_p));
        }
    }

    protected void init() throws Exception {
        super.init();
        this.m_Layout = this.createSubLayout();
        this.addView((OwView)this.m_Layout, null);
        this.m_SubNavigation = this.createSubNavigationView();
        this.m_Layout.addView((OwView)this.m_SubNavigation, 0, null);
        ((OwSearchDocument)this.getDocument()).setNavigationView((OwNavigationView)this.m_SubNavigation);
        this.m_Layout.addViewReference(this.m_SubNavigation.getViewReference(), 2);
        OwAttributeBagWriteable attributes = this.getDocument().getPersistentAttributeBagWriteable();
        String currentSearchTemplateName = (String)attributes.getSafeAttribute(PERSIST_SEARCHTEMPLATE_ATTRIBUTE_NAME, (Object)"");
        Collection templates = ((OwSearchDocument)this.getDocument()).getSearchTemplates();
        int iNavigationIndex = 0;
        if (templates != null) {
            this.m_searchTemplateView = this.createSearchTemplateView();
            Iterator it = templates.iterator();
            int i = 0;
            while (it.hasNext()) {
                OwSearchDocument.OwRepositorySearchTemplate repTemplate = (OwSearchDocument.OwRepositorySearchTemplate)it.next();
                String strIcon = null;
                strIcon = repTemplate.getIcon() != null ? this.getContext().getDesignURL() + repTemplate.getIcon() : this.getContext().getDesignURL() + "/images/plug/owsearch/find.png";
                this.m_SubNavigation.addView((OwView)this.m_searchTemplateView, repTemplate.getDisplayName(this.getContext().getLocale()), null, strIcon, (Object)repTemplate.getName(), null);
                if (repTemplate.getName().equals(currentSearchTemplateName)) {
                    iNavigationIndex = i;
                }
                ++i;
            }
        }
        this.m_SubNavigation.addDelimiter();
        this.m_resultList = this.createResultListView();
        String strIcon = this.getContext().getDesignURL() + "/images/plug/owsearch/hitlist.png";
        this.m_SubNavigation.addView((OwView)this.m_resultList, this.getContext().localize("owsearch.OwSearchView.resultlist_title", "Result List"), null, strIcon, (Object)this.getContext().localize("owsearch.OwSearchView.resultlist_title", "Result List"), null);
        this.m_SubNavigation.navigate(iNavigationIndex);
    }

    public OwObjectListView getObjectListView() {
        return this.m_resultList.getObjectListView();
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 0: {
                OwObject obj;
                int iSize;
                this.m_resultList.activate();
                OwSearchDocument searchDocument = (OwSearchDocument)this.getDocument();
                if (!searchDocument.isAutoOpenFirstDocument() && !searchDocument.isAutoOpenSingleRecord() || (iSize = searchDocument.getResultList().size()) <= 0 || !searchDocument.autoOpenFirstObject(obj = (OwObject)searchDocument.getResultList().get(0), iSize)) break;
                OwMimeManager.openObject((OwMainAppContext)((OwMainAppContext)this.getContext()), (OwObjectReference)obj, null, (int)1, null);
            }
        }
    }

    protected OwSubNavigationView createSubNavigationView() {
        return new OwSubNavigationView();
    }

    protected OwSubLayout createSubLayout() {
        return new OwSubLayout();
    }

    protected OwSearchTemplateView createSearchTemplateView() {
        return new OwSearchTemplateView();
    }

    protected OwResultListView createResultListView() {
        return new OwResultListView();
    }

    public void updateSearchCriteria(OwSearchTemplate templateObject_p) throws Exception {
        if (this.m_searchTemplateView != null) {
            this.m_searchTemplateView.updateSearchCriteriaView(templateObject_p);
        }
    }

    public void updateSearchTemplateView(OwSearchTemplate templateObject_p) throws Exception {
        if (this.m_searchTemplateView != null) {
            this.m_searchTemplateView.updateSearchTemplate(templateObject_p);
        }
    }

    public String getBreadcrumbPart() {
        String dlgTitle = this.getDialogManager().getBreadcrumbPart();
        String bcPart = this.getTitle() + " - " + this.m_SubNavigation.getTitle();
        if (dlgTitle.equals("")) {
            return bcPart;
        }
        return bcPart + " - " + dlgTitle;
    }
}

