/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.client.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoUtils {
    public static final String ALFRESCO_NAMESPACE = "http://www.alfresco.org";
    public static final String CMIS_NAMESPACE = "http://docs.oasis-open.org/ns/cmis/core/200908/";
    public static final String APPLIED_ASPECTS = "appliedAspects";
    public static final String SET_ASPECTS = "setAspects";
    public static final String ASPECTS_TO_ADD = "aspectsToAdd";
    public static final String ASPECTS_TO_REMOVE = "aspectsToRemove";
    public static final String PROPERTIES = "properties";
    public static final String MANDATORY_ASPECTS = "mandatoryAspects";
    public static final String MANDATORY_ASPECT = "mandatoryAspect";

    private AlfrescoUtils() {
    }

    public static List<CmisExtensionElement> findAlfrescoExtensions(List<CmisExtensionElement> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return null;
        }
        for (CmisExtensionElement ext : extensions) {
            if (!ALFRESCO_NAMESPACE.equals(ext.getNamespace())) continue;
            return ext.getChildren();
        }
        return null;
    }

    public static Collection<ObjectType> getAspectTypes(Session session, List<CmisExtensionElement> alfrescoExtensions) {
        ArrayList<ObjectType> aspectTypes = new ArrayList<ObjectType>();
        for (CmisExtensionElement extension : alfrescoExtensions) {
            if (!extension.getName().equals(APPLIED_ASPECTS)) continue;
            ObjectType aspectType = session.getTypeDefinition(extension.getValue());
            aspectTypes.add(aspectType);
        }
        return aspectTypes;
    }

    public static ObjectType findAspect(Collection<ObjectType> aspectTypes, String propertyId) {
        if (aspectTypes == null || propertyId == null) {
            return null;
        }
        for (ObjectType type : aspectTypes) {
            if (type == null || type.getPropertyDefinitions() == null || !type.getPropertyDefinitions().containsKey(propertyId)) continue;
            return type;
        }
        return null;
    }

    public static CmisExtensionElement createSetAspectsExtension(List<CmisExtensionElement> setAspectsChildren) {
        return new CmisExtensionElementImpl(ALFRESCO_NAMESPACE, SET_ASPECTS, null, setAspectsChildren);
    }

    public static CmisExtensionElement createAspectsToAddExtension(ObjectType aspectType) {
        return new CmisExtensionElementImpl(ALFRESCO_NAMESPACE, ASPECTS_TO_ADD, null, aspectType.getId());
    }

    public static CmisExtensionElement createAspectsToRemoveExtension(ObjectType aspectType) {
        return new CmisExtensionElementImpl(ALFRESCO_NAMESPACE, ASPECTS_TO_REMOVE, null, aspectType.getId());
    }

    public static CmisExtensionElement createAspectPropertiesExtension(List<CmisExtensionElement> propertiesChildren) {
        return new CmisExtensionElementImpl(ALFRESCO_NAMESPACE, PROPERTIES, null, propertiesChildren);
    }

    public static CmisExtensionElement createAspectPropertyExtension(PropertyDefinition<?> propertyDefintion, Object value) {
        String name;
        switch (propertyDefintion.getPropertyType()) {
            case BOOLEAN: {
                name = "propertyBoolean";
                break;
            }
            case DATETIME: {
                name = "propertyDateTime";
                break;
            }
            case DECIMAL: {
                name = "propertyDecimal";
                break;
            }
            case INTEGER: {
                name = "propertyInteger";
                break;
            }
            case ID: {
                name = "propertyId";
                break;
            }
            case HTML: {
                name = "propertyHtml";
                break;
            }
            case URI: {
                name = "propertyUri";
                break;
            }
            default: {
                name = "propertyString";
            }
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("propertyDefinitionId", propertyDefintion.getId());
        ArrayList<CmisExtensionElementImpl> propertyValues = new ArrayList<CmisExtensionElementImpl>();
        if (value != null) {
            if (value instanceof Property) {
                value = ((Property)value).getValues();
            }
            if (value instanceof List) {
                for (Object o : (List)value) {
                    propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, AlfrescoUtils.convertAspectPropertyValue(o)));
                }
            } else {
                propertyValues.add(new CmisExtensionElementImpl(CMIS_NAMESPACE, "value", null, AlfrescoUtils.convertAspectPropertyValue(value)));
            }
        }
        return new CmisExtensionElementImpl(CMIS_NAMESPACE, name, attributes, propertyValues);
    }

    private static String convertAspectPropertyValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Aspect property value must not be null!");
        }
        if (value instanceof GregorianCalendar) {
            DatatypeFactory df;
            try {
                df = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException("Aspect conversation exception: " + e.getMessage(), e);
            }
            return df.newXMLGregorianCalendar((GregorianCalendar)value).toXMLFormat();
        }
        if (!(value instanceof String || value instanceof Number || value instanceof Boolean)) {
            throw new IllegalArgumentException("Invalid aspect value!");
        }
        return value.toString();
    }

    public static <T> List<T> checkProperty(PropertyDefinition<T> propertyDefinition, Object value) {
        if (value == null) {
            return null;
        }
        List<Object> values = null;
        if (value instanceof List) {
            if (propertyDefinition.getCardinality() != Cardinality.MULTI) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a multi value property!");
            }
            values = (List<Object>)value;
            if (values.isEmpty()) {
                return values;
            }
        } else {
            if (propertyDefinition.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a single value property!");
            }
            values = Collections.singletonList(value);
        }
        for (Object o : values) {
            if (o != null) continue;
            throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' contains null values!");
        }
        boolean typeMatch = false;
        Object firstValue = values.get(0);
        switch (propertyDefinition.getPropertyType()) {
            case ID: 
            case HTML: 
            case URI: 
            case STRING: {
                typeMatch = firstValue instanceof String;
                break;
            }
            case INTEGER: {
                typeMatch = firstValue instanceof BigInteger || firstValue instanceof Byte || firstValue instanceof Short || firstValue instanceof Integer || firstValue instanceof Long;
                break;
            }
            case DECIMAL: {
                typeMatch = firstValue instanceof BigDecimal;
                break;
            }
            case BOOLEAN: {
                typeMatch = firstValue instanceof Boolean;
                break;
            }
            case DATETIME: {
                typeMatch = firstValue instanceof GregorianCalendar;
            }
        }
        if (!typeMatch) {
            throw new IllegalArgumentException("Value of property '" + propertyDefinition.getId() + "' does not match property type!");
        }
        return values;
    }

    public static Map<String, ?> preparePropertiesForUpdate(Map<String, ?> properties, ObjectType type, Collection<ObjectType> aspectTypes) {
        LinkedHashMap newProperties;
        LinkedHashMap linkedHashMap = newProperties = properties == null ? null : new LinkedHashMap(properties);
        if (newProperties != null) {
            newProperties.put("cmis:objectTypeId", AlfrescoUtils.createObjectTypeIdValue(type, aspectTypes));
        }
        return newProperties;
    }

    public static String createObjectTypeIdValue(ObjectType type, Collection<ObjectType> aspectTypes) {
        StringBuilder sb = new StringBuilder(type.getId());
        for (ObjectType aspect : aspectTypes) {
            sb.append(',');
            sb.append(aspect.getId());
        }
        return sb.toString();
    }

    public static void updateAspects(Session session, String objectId, ObjectType[] addAspectIds, ObjectType[] removeAspectIds, Map<String, ?> properties) {
        String repId = session.getRepositoryInfo().getId();
        Holder objectIdHolder = new Holder((Object)objectId);
        HashMap aspectPropertyDefinition = null;
        ArrayList<CmisExtensionElement> alfrescoExtensionList = new ArrayList<CmisExtensionElement>();
        if (addAspectIds != null) {
            aspectPropertyDefinition = new HashMap();
            for (ObjectType type : addAspectIds) {
                if (type == null) continue;
                alfrescoExtensionList.add(AlfrescoUtils.createAspectsToAddExtension(type));
                if (type.getPropertyDefinitions() == null) continue;
                aspectPropertyDefinition.putAll(type.getPropertyDefinitions());
            }
        }
        if (removeAspectIds != null) {
            for (ObjectType type : removeAspectIds) {
                if (type == null) continue;
                alfrescoExtensionList.add(AlfrescoUtils.createAspectsToRemoveExtension(type));
            }
        }
        if (alfrescoExtensionList.isEmpty()) {
            return;
        }
        if (addAspectIds != null && properties != null && !properties.isEmpty()) {
            ArrayList<CmisExtensionElement> aspectProperties = new ArrayList<CmisExtensionElement>(properties.size());
            for (Map.Entry<String, ?> property : properties.entrySet()) {
                if (property == null || property.getKey() == null) continue;
                String id = property.getKey();
                Object value = property.getValue();
                if (!aspectPropertyDefinition.containsKey(id)) {
                    throw new IllegalArgumentException("Property '" + id + "' is not an aspect property!");
                }
                aspectProperties.add(AlfrescoUtils.createAspectPropertyExtension((PropertyDefinition)aspectPropertyDefinition.get(id), value));
            }
            alfrescoExtensionList.add(AlfrescoUtils.createAspectPropertiesExtension(aspectProperties));
        }
        PropertiesImpl cmisProperties = new PropertiesImpl();
        cmisProperties.setExtensions(Collections.singletonList(AlfrescoUtils.createSetAspectsExtension(alfrescoExtensionList)));
        session.getBinding().getObjectService().updateProperties(repId, objectIdHolder, null, (Properties)cmisProperties, null);
    }

    private static CmisExtensionElement getExtension(List<CmisExtensionElement> extensions, String namespace, String name) {
        CmisExtensionElement ret = null;
        for (CmisExtensionElement elem : extensions) {
            if (!elem.getNamespace().equals(namespace) || !elem.getName().equals(name)) continue;
            ret = elem;
        }
        return ret;
    }

    public static List<String> getMandatoryAspects(ExtensionsData object) {
        List<String> mandatoryAspects = null;
        List extensions = object.getExtensions();
        CmisExtensionElement mandatoryAspectsExtension = AlfrescoUtils.getExtension(extensions, ALFRESCO_NAMESPACE, MANDATORY_ASPECTS);
        if (mandatoryAspectsExtension != null) {
            List mandatoryAspectsExtensions = mandatoryAspectsExtension.getChildren();
            mandatoryAspects = new ArrayList<String>(mandatoryAspectsExtensions.size());
            for (CmisExtensionElement elem : mandatoryAspectsExtensions) {
                mandatoryAspects.add(elem.getValue());
            }
        } else {
            mandatoryAspects = Collections.emptyList();
        }
        return mandatoryAspects;
    }
}

