/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.client.AlfrescoAspects;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.alfresco.cmis.client.AlfrescoFolder;
import org.alfresco.cmis.client.impl.AlfrescoDocumentTypeImpl;
import org.alfresco.cmis.client.impl.AlfrescoFolderTypeImpl;
import org.alfresco.cmis.client.impl.AlfrescoUtils;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientAlfrescoAspectsImpl
implements AlfrescoAspects {
    private Session session;
    private CmisObject object;
    private Map<String, ObjectType> aspectTypes;
    private Map<String, ObjectType> addAspectTypes;
    private Map<String, ObjectType> removeAspectTypes;

    public TransientAlfrescoAspectsImpl(Session session, CmisObject object) {
        this.session = session;
        this.object = object;
        List<CmisExtensionElement> alfrescoExtensions = AlfrescoUtils.findAlfrescoExtensions(object.getExtensions(ExtensionLevel.PROPERTIES));
        if (alfrescoExtensions == null) {
            this.aspectTypes = Collections.emptyMap();
        } else {
            this.aspectTypes = new HashMap<String, ObjectType>();
            for (ObjectType type : AlfrescoUtils.getAspectTypes(session, alfrescoExtensions)) {
                if (type == null) continue;
                this.aspectTypes.put(type.getId(), type);
            }
        }
        this.addAspectTypes = new HashMap<String, ObjectType>();
        this.removeAspectTypes = new HashMap<String, ObjectType>();
    }

    @Override
    public ObjectType getTypeWithAspects() {
        if (this.object instanceof AlfrescoDocument) {
            return new AlfrescoDocumentTypeImpl((AlfrescoDocument)this.object);
        }
        if (this.object instanceof AlfrescoFolder) {
            return new AlfrescoFolderTypeImpl((AlfrescoFolder)this.object);
        }
        return this.object.getType();
    }

    @Override
    public boolean hasAspect(String id) {
        return (this.aspectTypes.containsKey(id) || this.addAspectTypes.containsKey(id)) && !this.removeAspectTypes.containsKey(id);
    }

    @Override
    public boolean hasAspect(ObjectType type) {
        return type == null ? false : this.hasAspect(type.getId());
    }

    @Override
    public Collection<ObjectType> getAspects() {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        HashSet<String> addTypes = new HashSet<String>(this.addAspectTypes.keySet());
        for (String typeId : this.aspectTypes.keySet()) {
            if (!this.removeAspectTypes.containsKey(typeId)) {
                result.add(this.aspectTypes.get(typeId));
            }
            addTypes.remove(typeId);
        }
        for (String typeId : addTypes) {
            result.add(this.addAspectTypes.get(typeId));
        }
        return result;
    }

    @Override
    public ObjectType findAspect(String propertyId) {
        return AlfrescoUtils.findAspect(this.getAspects(), propertyId);
    }

    @Override
    public void addAspect(String ... id) {
        if (id == null || id.length == 0) {
            throw new IllegalArgumentException("Id must be set!");
        }
        ObjectType[] types = new ObjectType[id.length];
        for (int i = 0; i < id.length; ++i) {
            types[i] = this.session.getTypeDefinition(id[i]);
        }
        this.addAspect(types);
    }

    @Override
    public void addAspect(ObjectType ... type) {
        if (type == null || type.length == 0) {
            throw new IllegalArgumentException("Type must be set!");
        }
        for (ObjectType t : type) {
            if (t == null) continue;
            this.addAspectTypes.put(t.getId(), t);
            this.removeAspectTypes.remove(t.getId());
        }
    }

    public void setPropertyValues(TransientCmisObject object, Map<String, ?> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            object.setPropertyValue(property.getKey(), property.getValue());
        }
    }

    @Override
    public void addAspect(ObjectType type, Map<String, ?> properties) {
        this.addAspect(type);
    }

    @Override
    public void addAspect(ObjectType[] type, Map<String, ?> properties) {
        this.addAspect(type);
    }

    @Override
    public void addAspect(String id, Map<String, ?> properties) {
        this.addAspect(id);
    }

    @Override
    public void addAspect(String[] id, Map<String, ?> properties) {
        this.addAspect(id);
    }

    @Override
    public void removeAspect(String ... id) {
        if (id == null || id.length == 0) {
            throw new IllegalArgumentException("Id must be set!");
        }
        ObjectType[] types = new ObjectType[id.length];
        for (int i = 0; i < id.length; ++i) {
            types[i] = this.session.getTypeDefinition(id[i]);
        }
        this.removeAspect(types);
    }

    @Override
    public void removeAspect(ObjectType ... type) {
        if (type == null || type.length == 0) {
            throw new IllegalArgumentException("Type must be set!");
        }
        for (ObjectType t : type) {
            if (t == null) continue;
            this.addAspectTypes.remove(t.getId());
            this.removeAspectTypes.put(t.getId(), t);
        }
    }

    public void save() {
        if (this.addAspectTypes.isEmpty() && this.removeAspectTypes.isEmpty()) {
            return;
        }
        AlfrescoUtils.updateAspects(this.session, this.object.getId(), this.addAspectTypes.values().toArray(new ObjectType[0]), this.removeAspectTypes.values().toArray(new ObjectType[0]), null);
    }
}

