/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.desktopsettings.applet;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;

public class DesktopSettings
extends Applet {
    private static final int MAX_MONITORS = 2;
    private GraphicsEnvironment m_graphEnv;
    private GraphicsDevice[] m_Devices;

    @Override
    public void init() {
        this.setupDisplayDevices();
    }

    private void setupDisplayDevices() {
        System.err.println("Querying Graphics the environment.");
        this.m_graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.m_Devices = this.m_graphEnv.getScreenDevices();
    }

    public int getDisplayDevices() {
        return this.m_Devices.length;
    }

    public Dimension[] getDesktopResolutions() {
        int crt = 0;
        Dimension[] array = new Dimension[2];
        for (GraphicsDevice device : this.m_Devices) {
            array[crt] = new Dimension(device.getDisplayMode().getWidth(), device.getDisplayMode().getHeight());
            ++crt;
        }
        return array;
    }

    public String[] getDevicesIDs() {
        String[] devicesId = new String[2];
        int crt = 0;
        for (GraphicsDevice device : this.m_Devices) {
            devicesId[crt] = new String(device.getIDstring());
            ++crt;
        }
        return devicesId;
    }

    public Rectangle getVirtualBounds() {
        Rectangle vBounds = new Rectangle();
        GraphicsDevice[] arr$ = this.m_Devices;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GraphicsDevice device;
            GraphicsDevice gd = device = arr$[i$];
            GraphicsConfiguration[] gcArray = gd.getConfigurations();
            for (int j = 0; j < gcArray.length; ++j) {
                vBounds = vBounds.union(gcArray[j].getBounds());
            }
        }
        Point origin = vBounds.getLocation();
        Dimension size = vBounds.getSize();
        return vBounds;
    }
}

