/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.ClientConnectionHelper;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.ext.ssl.internal.HttpsClientInboundWay;
import org.restlet.ext.ssl.internal.HttpsClientOutboundWay;
import org.restlet.ext.ssl.internal.SslConnection;
import org.restlet.ext.ssl.internal.SslUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsClientHelper
extends ClientConnectionHelper {
    private volatile SSLContext sslContext;

    public HttpsClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    protected Connection<Client> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        SSLEngine engine = socketAddress != null ? this.getSslContext().createSSLEngine(socketAddress.getHostName(), socketAddress.getPort()) : this.getSslContext().createSSLEngine();
        return new SslConnection<Client>(this, socketChannel, controller, socketAddress, engine);
    }

    @Override
    public InboundWay createInboundWay(Connection<Client> connection, int bufferSize) {
        return new HttpsClientInboundWay(connection, bufferSize);
    }

    @Override
    public OutboundWay createOutboundWay(Connection<Client> connection, int bufferSize) {
        return new HttpsClientOutboundWay(connection, bufferSize);
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public synchronized void start() throws Exception {
        SslContextFactory factory = SslUtils.getSslContextFactory(this);
        this.setSslContext(factory.createSslContext());
        super.start();
    }
}

