/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.impl.message.HeaderWrapper;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageWrapper
extends Message {
    private boolean isOneWay = false;
    private SecuredMessage sm;
    private List headers;
    private HeaderList hl = new HeaderList();
    private MutableXMLStreamBuffer bufferedMsg = null;

    public MessageWrapper(SecuredMessage sm, boolean oneWay) {
        this.sm = sm;
        this.isOneWay = oneWay;
        this.headers = sm.getHeaders();
        for (int i = 0; i < this.headers.size(); ++i) {
            Object obj = this.headers.get(i);
            if (obj instanceof Header) {
                this.hl.add((Header)obj);
                continue;
            }
            this.hl.add(new HeaderWrapper((SecurityElement)obj));
        }
    }

    public MessageWrapper(MutableXMLStreamBuffer msg, boolean oneWay, HeaderList hdrs, SecuredMessage sm) {
        this.bufferedMsg = msg;
        this.sm = sm;
        this.hl = hdrs;
        this.isOneWay = oneWay;
    }

    @Override
    public boolean hasHeaders() {
        return this.hl.size() > 0;
    }

    @Override
    public HeaderList getHeaders() {
        return this.hl;
    }

    @Override
    public AttachmentSet getAttachments() {
        return this.sm.getAttachments();
    }

    @Override
    protected boolean hasAttachments() {
        return this.sm.getAttachments() != null;
    }

    @Override
    public boolean isOneWay(@NotNull WSDLPort port) {
        return this.isOneWay;
    }

    @Override
    public String getPayloadLocalPart() {
        return this.sm.getPayloadLocalPart();
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.sm.getPayloadNamespaceURI();
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public Source readEnvelopeAsSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Source readPayloadAsSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        this._check();
        return this.sm.readPayload();
    }

    @Override
    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        this._check();
        this.sm.writePayloadTo(sw);
    }

    @Override
    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        if (this.bufferedMsg != null) {
            this.bufferedMsg.writeToXMLStreamWriter(sw);
            return;
        }
        this.sm.writeTo(sw);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageWrapper copy() {
        return this;
    }

    private void _check() {
        if (this.bufferedMsg != null) {
            throw new UnsupportedOperationException("Message is buffered , only writeTo method is supported");
        }
    }
}

