/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.PolicyReference;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.Authenticator;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.elements.DelegateTo;
import com.sun.xml.ws.security.trust.elements.Encryption;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Issuer;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.ProofEncryption;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedTokenCancelled;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SignChallenge;
import com.sun.xml.ws.security.trust.elements.SignChallengeResponse;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.impl.WSTrustVersion10;
import com.sun.xml.ws.security.trust.impl.bindings.AllowPostdatingType;
import com.sun.xml.ws.security.trust.impl.bindings.AuthenticatorType;
import com.sun.xml.ws.security.trust.impl.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.impl.bindings.DelegateToType;
import com.sun.xml.ws.security.trust.impl.bindings.EncryptionType;
import com.sun.xml.ws.security.trust.impl.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.bindings.LifetimeType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.ProofEncryptionType;
import com.sun.xml.ws.security.trust.impl.bindings.RenewingType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedProofTokenType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedReferenceType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedTokenCancelledType;
import com.sun.xml.ws.security.trust.impl.bindings.SignChallengeType;
import com.sun.xml.ws.security.trust.impl.bindings.StatusType;
import com.sun.xml.ws.security.trust.impl.bindings.UseKeyType;
import com.sun.xml.ws.security.trust.impl.elements.AllowPostdatingImpl;
import com.sun.xml.ws.security.trust.impl.elements.AuthenticatorImpl;
import com.sun.xml.ws.security.trust.impl.elements.BinaryExchangeImpl;
import com.sun.xml.ws.security.trust.impl.elements.DelegateToImpl;
import com.sun.xml.ws.security.trust.impl.elements.EncryptionImpl;
import com.sun.xml.ws.security.trust.impl.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.elements.ProofEncryptionImpl;
import com.sun.xml.ws.security.trust.impl.elements.RenewingImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedAttachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedProofTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedTokenCancelledImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedUnattachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.SignChallengeImpl;
import com.sun.xml.ws.security.trust.impl.elements.SignChallengeResponseImpl;
import com.sun.xml.ws.security.trust.impl.elements.StatusImpl;
import com.sun.xml.ws.security.trust.impl.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class RequestSecurityTokenResponseImpl
extends RequestSecurityTokenResponseType
implements RequestSecurityTokenResponse {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private URI tokenType = null;
    private long keySize = 0L;
    private URI keyType = null;
    private URI computedKeyAlgorithm = null;
    private URI signatureAlgorithm = null;
    private URI encryptionAlgorithm = null;
    private URI canonAlgorithm = null;
    private Lifetime lifetime = null;
    private Entropy entropy = null;
    private AppliesTo appliesTo = null;
    private Authenticator authenticator = null;
    private UseKey useKey = null;
    private ProofEncryption proofEncryption = null;
    private Encryption encryption = null;
    private DelegateTo delegateTo = null;
    private OnBehalfOf obo = null;
    private RequestedSecurityToken requestedSecToken = null;
    private RequestedProofToken requestedProofToken = null;
    private RequestedAttachedReference requestedAttachedReference = null;
    private RequestedUnattachedReference requestedUnattachedReference = null;
    private URI signWith = null;
    private URI encryptWith = null;
    private URI authenticationType = null;
    private SignChallenge signChallenge = null;
    private SignChallengeResponse signChallengeRes = null;
    private boolean forwardable = true;
    private boolean delegatable = false;
    private Issuer issuer = null;
    private Renewing renewable = null;
    private BinaryExchange binaryExchange = null;
    private AllowPostdating apd = null;
    private Status status = null;
    private Policy policy = null;
    private PolicyReference policyRef = null;
    private RequestedTokenCancelled rtc = null;

    public RequestSecurityTokenResponseImpl() {
    }

    public RequestSecurityTokenResponseImpl(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime, Status status) {
        this.setTokenType(tokenType);
        if (context != null) {
            this.setContext(context.toString());
        }
        if (token != null) {
            this.setRequestedSecurityToken(token);
        }
        if (attached != null) {
            this.setRequestedAttachedReference(attached);
        }
        if (unattached != null) {
            this.setRequestedUnattachedReference(unattached);
        }
        if (scopes != null) {
            this.setAppliesTo(scopes);
        }
        if (proofToken != null) {
            this.setRequestedProofToken(proofToken);
        }
        if (entropy != null) {
            this.setEntropy(entropy);
        }
        if (lifetime != null) {
            this.setLifetime(lifetime);
        }
        if (status != null) {
            this.setStatus(status);
        }
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public final void setTokenType(URI tokenType) {
        if (tokenType != null) {
            this.tokenType = tokenType;
            JAXBElement<String> ttElement = new ObjectFactory().createTokenType(tokenType.toString());
            this.getAny().add(ttElement);
        }
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public final void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        JAXBElement<LifetimeType> ltElement = new ObjectFactory().createLifetime((LifetimeType)((Object)lifetime));
        this.getAny().add(ltElement);
    }

    public RequestedTokenCancelled getRequestedTokenCancelled() {
        return this.rtc;
    }

    public final void setRequestedTokenCancelled(RequestedTokenCancelled rtc) {
        this.rtc = rtc;
        JAXBElement<RequestedTokenCancelledType> rtcElement = new ObjectFactory().createRequestedTokenCancelled((RequestedTokenCancelledType)((Object)rtc));
        this.getAny().add(rtcElement);
    }

    public Status getStatus() {
        return this.status;
    }

    public final void setStatus(Status status) {
        this.status = status;
        JAXBElement<StatusType> sElement = new ObjectFactory().createStatus((StatusType)((Object)status));
        this.getAny().add(sElement);
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public final void setEntropy(Entropy entropy) {
        this.entropy = entropy;
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)((Object)entropy));
        this.getAny().add(etElement);
    }

    public final void setAppliesTo(AppliesTo appliesTo) {
        this.getAny().add(appliesTo);
        this.appliesTo = appliesTo;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public final void setOnBehalfOf(OnBehalfOf onBehalfOf) {
        this.obo = onBehalfOf;
    }

    public OnBehalfOf getOnBehalfOf() {
        return this.obo;
    }

    public final void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public final void setRenewable(Renewing renew) {
        this.renewable = renew;
        JAXBElement<RenewingType> renewType = new ObjectFactory().createRenewing((RenewingType)((Object)renew));
        this.getAny().add(renewType);
    }

    public Renewing getRenewable() {
        return this.renewable;
    }

    public final void setSignChallenge(SignChallenge challenge) {
        this.signChallenge = challenge;
        JAXBElement<SignChallengeType> challengeType = new ObjectFactory().createSignChallenge((SignChallengeType)((Object)challenge));
        this.getAny().add(challengeType);
    }

    public SignChallenge getSignChallenge() {
        return this.signChallenge;
    }

    public final void setBinaryExchange(BinaryExchange exchange) {
        this.binaryExchange = exchange;
        JAXBElement<BinaryExchangeType> exchangeType = new ObjectFactory().createBinaryExchange((BinaryExchangeType)((Object)exchange));
        this.getAny().add(exchangeType);
    }

    public BinaryExchange getBinaryExchange() {
        return this.binaryExchange;
    }

    public final void setAuthenticationType(URI uri) {
        this.authenticationType = uri;
        JAXBElement<String> atElement = new ObjectFactory().createAuthenticationType(uri.toString());
        this.getAny().add(atElement);
    }

    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    public final void setKeyType(@NotNull URI keytype) throws WSTrustException {
        WSTrustVersion10 wstVer = new WSTrustVersion10();
        if (!(keytype.toString().equalsIgnoreCase(((WSTrustVersion)wstVer).getSymmetricKeyTypeURI()) || keytype.toString().equalsIgnoreCase(((WSTrustVersion)wstVer).getPublicKeyTypeURI()) || keytype.toString().equalsIgnoreCase(((WSTrustVersion)wstVer).getBearerKeyTypeURI()))) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keytype.toString(), null));
            throw new WSTrustException(LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keytype.toString(), null));
        }
        this.keyType = keytype;
        JAXBElement<String> ktElement = new ObjectFactory().createKeyType(this.keyType.toString());
        this.getAny().add(ktElement);
    }

    public URI getKeyType() {
        return this.keyType;
    }

    public final void setKeySize(@NotNull long size) {
        this.keySize = size;
        JAXBElement<Long> ksElement = new ObjectFactory().createKeySize(size);
        this.getAny().add(ksElement);
    }

    public long getKeySize() {
        return this.keySize;
    }

    public final void setSignatureAlgorithm(@NotNull URI algorithm) {
        this.signatureAlgorithm = algorithm;
        JAXBElement<String> signElement = new ObjectFactory().createSignatureAlgorithm(algorithm.toString());
        this.getAny().add(signElement);
    }

    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final void setEncryptionAlgorithm(@NotNull URI algorithm) {
        this.encryptionAlgorithm = algorithm;
        JAXBElement<String> encElement = new ObjectFactory().createEncryptionAlgorithm(algorithm.toString());
        this.getAny().add(encElement);
    }

    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public final void setCanonicalizationAlgorithm(@NotNull URI algorithm) {
        this.canonAlgorithm = algorithm;
        JAXBElement<String> canonElement = new ObjectFactory().createCanonicalizationAlgorithm(algorithm.toString());
        this.getAny().add(canonElement);
    }

    public URI getCanonicalizationAlgorithm() {
        return this.canonAlgorithm;
    }

    public final void setUseKey(UseKey useKey) {
        this.useKey = useKey;
        JAXBElement<UseKeyType> ukElement = new ObjectFactory().createUseKey((UseKeyType)((Object)useKey));
        this.getAny().add(ukElement);
    }

    public UseKey getUseKey() {
        return this.useKey;
    }

    public final void setProofEncryption(ProofEncryption proofEncryption) {
        this.proofEncryption = proofEncryption;
        JAXBElement<ProofEncryptionType> proofElement = new ObjectFactory().createProofEncryption((ProofEncryptionType)((Object)proofEncryption));
        this.getAny().add(proofElement);
    }

    public ProofEncryption getProofEncryption() {
        return this.proofEncryption;
    }

    public final void setComputedKeyAlgorithm(@NotNull URI algorithm) {
        if (algorithm != null) {
            String ckaString = algorithm.toString();
            if (!ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKHASHalgorithmURI()) && !ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKPSHA1algorithmURI())) {
                throw new RuntimeException("Invalid Computed Key Algorithm specified");
            }
            this.computedKeyAlgorithm = algorithm;
            JAXBElement<String> ckaElement = new ObjectFactory().createComputedKeyAlgorithm(ckaString);
            this.getAny().add(ckaElement);
        }
    }

    public URI getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    public final void setEncryption(Encryption enc) {
        this.encryption = enc;
        JAXBElement<EncryptionType> encElement = new ObjectFactory().createEncryption((EncryptionType)((Object)enc));
        this.getAny().add(encElement);
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public final void setSignWith(URI algorithm) {
        this.signWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createSignWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getSignWith() {
        return this.signWith;
    }

    public final void setEncryptWith(@NotNull URI algorithm) {
        this.encryptWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createEncryptWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getEncryptWith() {
        return this.encryptWith;
    }

    public void setKeyWrapAlgorithm(URI algorithm) {
        throw new UnsupportedOperationException("KeyWrapAlgorithm element in WS-Trust Standard version(1.0) is not supported");
    }

    public URI getKeyWrapAlgorithm() {
        throw new UnsupportedOperationException("KeyWrapAlgorithm element in WS-Trust Standard version(1.0) is not supported");
    }

    public final void setDelegateTo(DelegateTo to) {
        this.delegateTo = to;
        JAXBElement<DelegateToType> dtElement = new ObjectFactory().createDelegateTo((DelegateToType)((Object)to));
        this.getAny().add(dtElement);
    }

    public DelegateTo getDelegateTo() {
        return this.delegateTo;
    }

    public final void setForwardable(boolean flag) {
        this.forwardable = flag;
        JAXBElement<Boolean> forward = new ObjectFactory().createForwardable(flag);
        this.getAny().add(forward);
    }

    public boolean getForwardable() {
        return this.forwardable;
    }

    public final void setDelegatable(boolean flag) {
        this.delegatable = flag;
        JAXBElement<Boolean> del = new ObjectFactory().createDelegatable(flag);
        this.getAny().add(del);
    }

    public boolean getDelegatable() {
        return this.delegatable;
    }

    public final void setPolicy(Policy policy) {
        this.policy = policy;
        this.getAny().add(policy);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public final void setPolicyReference(PolicyReference policyRef) {
        this.policyRef = policyRef;
        this.getAny().add(policyRef);
    }

    public PolicyReference getPolicyReference() {
        return this.policyRef;
    }

    public AllowPostdating getAllowPostdating() {
        return this.apd;
    }

    public final void setAllowPostdating(AllowPostdating allowPostdating) {
        this.apd = allowPostdating;
        JAXBElement<AllowPostdatingType> allowPd = new ObjectFactory().createAllowPostdating((AllowPostdatingType)((Object)this.apd));
        this.getAny().add(allowPd);
    }

    public final void setSignChallengeResponse(SignChallengeResponse challenge) {
        this.signChallengeRes = challenge;
        JAXBElement<SignChallengeType> challengeType = new ObjectFactory().createSignChallengeResponse((SignChallengeType)((Object)challenge));
        this.getAny().add(challengeType);
    }

    public SignChallengeResponse getSignChallengeResponse() {
        return this.signChallengeRes;
    }

    public final void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        JAXBElement<AuthenticatorType> authType = new ObjectFactory().createAuthenticator((AuthenticatorType)((Object)authenticator));
        this.getAny().add(authType);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public final void setRequestedProofToken(RequestedProofToken proofToken) {
        this.requestedProofToken = proofToken;
        JAXBElement<RequestedProofTokenType> pElement = new ObjectFactory().createRequestedProofToken((RequestedProofTokenType)((Object)proofToken));
        this.getAny().add(pElement);
    }

    public RequestedProofToken getRequestedProofToken() {
        return this.requestedProofToken;
    }

    public final void setRequestedSecurityToken(RequestedSecurityToken securityToken) {
        this.requestedSecToken = securityToken;
        JAXBElement<RequestedSecurityTokenType> rstElement = new ObjectFactory().createRequestedSecurityToken((RequestedSecurityTokenType)((Object)securityToken));
        this.getAny().add(rstElement);
    }

    public RequestedSecurityToken getRequestedSecurityToken() {
        return this.requestedSecToken;
    }

    public final void setRequestedAttachedReference(RequestedAttachedReference reference) {
        this.requestedAttachedReference = reference;
        JAXBElement<RequestedReferenceType> raElement = new ObjectFactory().createRequestedAttachedReference((RequestedReferenceType)((Object)reference));
        this.getAny().add(raElement);
    }

    public RequestedAttachedReference getRequestedAttachedReference() {
        return this.requestedAttachedReference;
    }

    public final void setRequestedUnattachedReference(RequestedUnattachedReference reference) {
        this.requestedUnattachedReference = reference;
        JAXBElement<RequestedReferenceType> raElement = new ObjectFactory().createRequestedUnattachedReference((RequestedReferenceType)((Object)reference));
        this.getAny().add(raElement);
    }

    public RequestedUnattachedReference getRequestedUnattachedReference() {
        return this.requestedUnattachedReference;
    }

    public RequestSecurityTokenResponseImpl(RequestSecurityTokenResponseType rstrType) throws URISyntaxException, WSTrustException {
        this.context = rstrType.getContext();
        List<Object> list = rstrType.getAny();
        for (int i = 0; i < list.size(); ++i) {
            RequestedReferenceType rarType;
            if (list.get(i) instanceof AppliesTo) {
                this.setAppliesTo((AppliesTo)list.get(i));
                continue;
            }
            Object object = list.get(i);
            if (!(object instanceof JAXBElement)) {
                this.getAny().add(object);
                continue;
            }
            JAXBElement obj = (JAXBElement)list.get(i);
            String local = obj.getName().getLocalPart();
            if (local.equalsIgnoreCase("KeySize")) {
                this.setKeySize((Long)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("KeyType")) {
                this.setKeyType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("ComputedKeyAlgorithm")) {
                this.setComputedKeyAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("TokenType")) {
                this.setTokenType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("AuthenticationType")) {
                this.setAuthenticationType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("Lifetime")) {
                LifetimeType ltType = (LifetimeType)obj.getValue();
                this.setLifetime(new LifetimeImpl(ltType));
                continue;
            }
            if (local.equalsIgnoreCase("Entropy")) {
                EntropyType eType = (EntropyType)obj.getValue();
                this.setEntropy(new EntropyImpl(eType));
                continue;
            }
            if (local.equalsIgnoreCase("Forwardable")) {
                this.setForwardable((Boolean)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("Delegatable")) {
                this.setDelegatable((Boolean)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("SignWith")) {
                this.setSignWith(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("EncryptWith")) {
                this.setEncryptWith(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("SignatureAlgorithm")) {
                this.setSignatureAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("EncryptionAlgorithm")) {
                this.setEncryptionAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                this.setCanonicalizationAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("AllowPostdating")) {
                this.setAllowPostdating(new AllowPostdatingImpl());
                continue;
            }
            if (local.equalsIgnoreCase("SignChallenge")) {
                this.setSignChallenge(new SignChallengeImpl());
                continue;
            }
            if (local.equalsIgnoreCase("SignChallengeResponse")) {
                this.setSignChallengeResponse(new SignChallengeResponseImpl());
                continue;
            }
            if (local.equalsIgnoreCase("BinaryExchange")) {
                BinaryExchangeType bcType = (BinaryExchangeType)obj.getValue();
                this.setBinaryExchange(new BinaryExchangeImpl(bcType));
                continue;
            }
            if (local.equalsIgnoreCase("Issuer")) continue;
            if (local.equalsIgnoreCase("Authenticator")) {
                AuthenticatorType aType = (AuthenticatorType)obj.getValue();
                this.setAuthenticator(new AuthenticatorImpl(aType));
                continue;
            }
            if (local.equalsIgnoreCase("Renewing")) {
                this.setRenewable(new RenewingImpl());
                continue;
            }
            if (local.equalsIgnoreCase("ProofEncryption")) {
                ProofEncryptionType peType = (ProofEncryptionType)obj.getValue();
                this.setProofEncryption(new ProofEncryptionImpl(peType));
                continue;
            }
            if (local.equalsIgnoreCase("Policy")) {
                this.setPolicy((Policy)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("PolicyReference")) {
                this.setPolicyReference((PolicyReference)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("AppliesTo")) {
                this.setAppliesTo((AppliesTo)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("OnBehalfOf")) {
                this.obo = (OnBehalfOf)obj.getValue();
                continue;
            }
            if (local.equalsIgnoreCase("Encryption")) {
                EncryptionType encType = (EncryptionType)obj.getValue();
                this.setEncryption(new EncryptionImpl(encType));
                continue;
            }
            if (local.equalsIgnoreCase("UseKey")) {
                UseKeyType ukType = (UseKeyType)obj.getValue();
                this.setUseKey(new UseKeyImpl(ukType));
                continue;
            }
            if (local.equalsIgnoreCase("Status")) {
                StatusType sType = (StatusType)obj.getValue();
                this.setStatus(new StatusImpl(sType));
                continue;
            }
            if (local.equalsIgnoreCase("DelegateTo")) {
                DelegateToType dtType = (DelegateToType)obj.getValue();
                this.setDelegateTo(new DelegateToImpl(dtType));
                continue;
            }
            if (local.equalsIgnoreCase("RequestedProofToken")) {
                RequestedProofTokenType rptType = (RequestedProofTokenType)obj.getValue();
                this.setRequestedProofToken(new RequestedProofTokenImpl(rptType));
                continue;
            }
            if (local.equalsIgnoreCase("RequestedSecurityToken")) {
                RequestedSecurityTokenType rdstType = (RequestedSecurityTokenType)obj.getValue();
                this.setRequestedSecurityToken(new RequestedSecurityTokenImpl(rdstType));
                continue;
            }
            if (local.equalsIgnoreCase("RequestedAttachedReference")) {
                rarType = (RequestedReferenceType)obj.getValue();
                this.setRequestedAttachedReference(new RequestedAttachedReferenceImpl(rarType));
                continue;
            }
            if (local.equalsIgnoreCase("RequestedUnattachedReference")) {
                rarType = (RequestedReferenceType)obj.getValue();
                this.setRequestedUnattachedReference(new RequestedUnattachedReferenceImpl(rarType));
                continue;
            }
            if (local.equalsIgnoreCase("RequestedTokenCancelled")) {
                this.setRequestedTokenCancelled(new RequestedTokenCancelledImpl());
                continue;
            }
            this.getAny().add(obj.getValue());
        }
    }
}

