/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.tools.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.tools.argparser.ArgParser;
import org.glassfish.gmbal.tools.argparser.DefaultValue;
import org.glassfish.gmbal.tools.argparser.Help;
import org.glassfish.gmbal.tools.file.ActionFactory;
import org.glassfish.gmbal.tools.file.Block;
import org.glassfish.gmbal.tools.file.BlockParser;
import org.glassfish.gmbal.tools.file.FileWrapper;
import org.glassfish.gmbal.tools.file.Recognizer;
import org.glassfish.gmbal.tools.file.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyrightProcessor {
    private static Map<String, FileProcessing> procMap;
    private static final String COPYRIGHT_BLOCK_TAG = "CopyrightBlock";
    private static final String SUN_COPYRIGHT_TAG = "SunCopyright";
    private static final String CORRECT_COPYRIGHT_TAG = "CorrectCopyright";
    private static final String COPYRIGHT = "Copyright";
    private static final String START_YEAR = "StartYear";
    private static final String JAVA_COMMENT_START = "/*";
    private static final String JAVA_COMMENT_PREFIX = " *";
    private static final String JAVA_COMMENT_END = "*/";
    private static final boolean JAVA_AFTER_FIRST_BLOCK = false;
    private static final String JAVA_FORMAT_TAG = "JavaFormat";
    private static final String XML_COMMENT_START = "<!--";
    private static final String XML_COMMENT_PREFIX = " ";
    private static final String XML_COMMENT_END = "-->";
    private static final boolean XML_AFTER_FIRST_BLOCK = true;
    private static final String XML_FORMAT_TAG = "XmlFormat";
    private static final String JAVA_LINE_PREFIX = "// ";
    private static final boolean JAVA_LINE_AFTER_FIRST_BLOCK = false;
    private static final String JAVA_LINE_FORMAT_TAG = "JavaLineFormat";
    private static final String SCHEME_PREFIX = "; ";
    private static final boolean SCHEME_AFTER_FIRST_BLOCK = false;
    private static final String SCHEME_FORMAT_TAG = "SchemeFormat";
    private static final String SHELL_PREFIX = "# ";
    private static final boolean SHELL_AFTER_FIRST_BLOCK = true;
    private static final boolean SHELL_SCRIPT_AFTER_FIRST_BLOCK = true;
    private static final String SHELL_FORMAT_TAG = "ShellFormat";
    private static Arguments args;

    private CopyrightProcessor() {
    }

    private static void trace(String msg) {
        System.out.println(msg);
    }

    private static Block makeCopyrightLineCommentBlock(Block copyrightText, String prefix, String tag) {
        Block result = new Block(copyrightText);
        result.addPrefixToAll(prefix);
        result.addTag(tag);
        result.addTag(CORRECT_COPYRIGHT_TAG);
        return result;
    }

    private static Block makeCopyrightBlockCommentBlock(Block copyrightText, String start, String prefix, String end, String tag) {
        Block result = new Block(copyrightText);
        result.addPrefixToAll(prefix);
        result.addBeforeFirst(start);
        result.addAfterLast(end);
        result.addTag(tag);
        result.addTag(CORRECT_COPYRIGHT_TAG);
        return result;
    }

    private static String getSunCopyrightStart(String str) {
        int index = str.indexOf(COPYRIGHT);
        if (index == -1) {
            return null;
        }
        int pos = index + COPYRIGHT.length();
        char ch = str.charAt(pos);
        while (Character.isWhitespace(ch) && pos < str.length()) {
            ch = str.charAt(++pos);
        }
        int start = pos;
        ch = str.charAt(pos);
        while (Character.isDigit(ch) && pos < str.length()) {
            ch = str.charAt(++pos);
        }
        if (pos == start) {
            return null;
        }
        return str.substring(start, pos);
    }

    private static Block makeCopyrightBlock(String startYear, Block copyrightText) throws IOException {
        if (args.verbose() > 1) {
            CopyrightProcessor.trace("makeCopyrightBlock: startYear = " + startYear);
            CopyrightProcessor.trace("makeCopyrightBlock: copyrightText = " + copyrightText);
            CopyrightProcessor.trace("Contents of copyrightText block:");
            for (String str : copyrightText.contents()) {
                CopyrightProcessor.trace("\t" + str);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(START_YEAR, startYear);
        Block withStart = copyrightText.instantiateTemplate(map);
        if (args.verbose() > 1) {
            CopyrightProcessor.trace("Contents of copyrightText block withStart date:");
            for (String str : withStart.contents()) {
                CopyrightProcessor.trace("\t" + str);
            }
        }
        return withStart;
    }

    private static BlockParserCall makeBlockCommentParser(final String start, final String end) {
        return new BlockParserCall(){

            public String toString() {
                return "BlockCommentBlockParserCall[start=," + start + ",end=" + end + "]";
            }

            @Override
            public List<Block> evaluate(FileWrapper fw) {
                try {
                    return BlockParser.parseBlocks(fw, start, end);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
        };
    }

    private static BlockParserCall makeLineCommentParser(final String prefix) {
        return new BlockParserCall(){

            public String toString() {
                return "LineCommentBlockParserCall[prefix=," + prefix + "]";
            }

            @Override
            public List<Block> evaluate(FileWrapper fw) {
                try {
                    return BlockParser.parseBlocks(fw, prefix);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
        };
    }

    private static void validationError(Block block, String msg, FileWrapper fw) {
        CopyrightProcessor.trace("Copyright validation error: " + msg + " for " + fw);
        if (args.verbose() > 0 && block != null) {
            CopyrightProcessor.trace("Block=" + block);
            CopyrightProcessor.trace("Block contents:");
            for (String str : block.contents()) {
                CopyrightProcessor.trace("\"" + str + "\"");
            }
        }
    }

    private static Scanner.Action makeCopyrightBlockAction(final Block copyrightText, final BlockParserCall parserCall, final String defaultStartYear, final boolean afterFirstBlock) {
        if (args.verbose() > 0) {
            CopyrightProcessor.trace("makeCopyrightBlockAction: copyrightText = " + copyrightText);
            CopyrightProcessor.trace("makeCopyrightBlockAction: parserCall = " + parserCall);
            CopyrightProcessor.trace("makeCopyrightBlockAction: defaultStartYear = " + defaultStartYear);
            CopyrightProcessor.trace("makeCopyrightBlockAction: afterFirstBlock = " + afterFirstBlock);
        }
        return new Scanner.Action(){

            public String toString() {
                return "CopyrightBlockAction[copyrightText=" + copyrightText + ",parserCall=" + parserCall + ",defaultStartYear=" + defaultStartYear + ",afterFirstBlock=" + afterFirstBlock + "]";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate(FileWrapper fw) {
                try {
                    String startYear = defaultStartYear;
                    boolean hadAnOldSunCopyright = false;
                    List fileBlocks = (List)parserCall.evaluate(fw);
                    for (Block block : fileBlocks) {
                        String str = block.find(CopyrightProcessor.COPYRIGHT);
                        if (str == null) continue;
                        block.addTag(CopyrightProcessor.COPYRIGHT_BLOCK_TAG);
                        if (!str.contains("Sun")) continue;
                        startYear = CopyrightProcessor.getSunCopyrightStart(str);
                        block.addTag(CopyrightProcessor.SUN_COPYRIGHT_TAG);
                        hadAnOldSunCopyright = true;
                    }
                    if (args.verbose() > 1) {
                        CopyrightProcessor.trace("copyrightBlockAction: blocks in file " + fw);
                        for (Block block : fileBlocks) {
                            CopyrightProcessor.trace("\t" + block);
                            for (String str : block.contents()) {
                                CopyrightProcessor.trace("\t\t" + str);
                            }
                        }
                    }
                    Block cb = CopyrightProcessor.makeCopyrightBlock(startYear, copyrightText);
                    if (args.validate()) {
                        int count = 0;
                        for (Block block : fileBlocks) {
                            if (!afterFirstBlock && count == 0) {
                                if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock")) {
                                    if (!cb.equals(block)) {
                                        CopyrightProcessor.validationError(block, "First block has incorrect copyright text", fw);
                                    }
                                } else {
                                    CopyrightProcessor.validationError(block, "First block should be copyright but isn't", fw);
                                }
                                boolean bl = true;
                                return bl;
                            }
                            if (afterFirstBlock && count == 1) {
                                if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock")) {
                                    if (!cb.equals(block)) {
                                        CopyrightProcessor.validationError(block, "Second block has incorrect copyright text", fw);
                                    }
                                } else {
                                    CopyrightProcessor.validationError(block, "Second block should be copyright but isn't", fw);
                                }
                                boolean bl = true;
                                return bl;
                            }
                            if (count > 1) {
                                CopyrightProcessor.validationError(null, "Neither first nor second block checked", fw);
                                boolean bl = false;
                                return bl;
                            }
                            ++count;
                        }
                    } else if (fw.canWrite()) {
                        CopyrightProcessor.trace("Updating copyright/license header on file " + fw);
                        fw.delete();
                        fw.open(FileWrapper.OpenMode.WRITE);
                        boolean firstMatch = true;
                        boolean firstBlock = true;
                        for (Block block : fileBlocks) {
                            if (!hadAnOldSunCopyright && firstBlock) {
                                if (afterFirstBlock) {
                                    block.write(fw);
                                    cb.write(fw);
                                } else {
                                    cb.write(fw);
                                    block.write(fw);
                                }
                                firstBlock = false;
                                continue;
                            }
                            if (block.hasTags(CopyrightProcessor.SUN_COPYRIGHT_TAG, CopyrightProcessor.COPYRIGHT_BLOCK_TAG, "CommentBlock") && firstMatch) {
                                firstMatch = false;
                                if (!hadAnOldSunCopyright) continue;
                                cb.write(fw);
                                continue;
                            }
                            block.write(fw);
                        }
                    } else if (args.verbose() > 1) {
                        CopyrightProcessor.trace("Skipping file " + fw + " because is is not writable");
                    }
                }
                catch (IOException exc) {
                    CopyrightProcessor.trace("Exception while processing file " + fw + ": " + exc);
                    exc.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    fw.close();
                }
                return true;
            }
        };
    }

    private static void addToProcMap(FileProcessing fp) {
        procMap.put(fp.name(), fp);
    }

    private static void initializeScanners(ActionFactory af) throws IOException {
        procMap = new HashMap<String, FileProcessing>();
        Block copyrightText = BlockParser.getBlock(args.copyright());
        Block javaCopyrightText = CopyrightProcessor.makeCopyrightBlockCommentBlock(copyrightText, "/* ", " * ", " */ ", JAVA_FORMAT_TAG);
        Block xmlCopyrightText = CopyrightProcessor.makeCopyrightBlockCommentBlock(copyrightText, XML_COMMENT_START, XML_COMMENT_PREFIX, XML_COMMENT_END, XML_FORMAT_TAG);
        Block javaLineCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, JAVA_LINE_PREFIX, JAVA_LINE_FORMAT_TAG);
        Block schemeCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, SCHEME_PREFIX, SCHEME_FORMAT_TAG);
        Block shellCopyrightText = CopyrightProcessor.makeCopyrightLineCommentBlock(copyrightText, SHELL_PREFIX, SHELL_FORMAT_TAG);
        if (args.verbose() > 0) {
            CopyrightProcessor.trace("Main: copyrightText = " + copyrightText);
            CopyrightProcessor.trace("Main: javaCopyrightText = " + javaCopyrightText);
            CopyrightProcessor.trace("Main: xmlCopyrightText = " + xmlCopyrightText);
            CopyrightProcessor.trace("Main: javaLineCopyrightText = " + javaLineCopyrightText);
            CopyrightProcessor.trace("Main: schemeCopyrightText = " + schemeCopyrightText);
            CopyrightProcessor.trace("Main: shellCopyrightText = " + shellCopyrightText);
        }
        BlockParserCall javaBlockParserCall = CopyrightProcessor.makeBlockCommentParser(JAVA_COMMENT_START, JAVA_COMMENT_END);
        BlockParserCall xmlBlockParserCall = CopyrightProcessor.makeBlockCommentParser(XML_COMMENT_START, XML_COMMENT_END);
        BlockParserCall javaLineParserCall = CopyrightProcessor.makeLineCommentParser(JAVA_LINE_PREFIX);
        BlockParserCall schemeLineParserCall = CopyrightProcessor.makeLineCommentParser(SCHEME_PREFIX);
        BlockParserCall shellLineParserCall = CopyrightProcessor.makeLineCommentParser(SHELL_PREFIX);
        CopyrightProcessor.addToProcMap(new FileProcessing("JAVA", CopyrightProcessor.makeCopyrightBlockAction(javaCopyrightText, javaBlockParserCall, args.startyear(), false)).suffixes("c", "h", "java", "sjava", "idl"));
        CopyrightProcessor.addToProcMap(new FileProcessing("XML", CopyrightProcessor.makeCopyrightBlockAction(xmlCopyrightText, xmlBlockParserCall, args.startyear(), true)).suffixes("htm", "html", "xml", "dtd"));
        CopyrightProcessor.addToProcMap(new FileProcessing("SCHEME", CopyrightProcessor.makeCopyrightBlockAction(schemeCopyrightText, schemeLineParserCall, args.startyear(), false)).suffixes("mc", "mcd", "scm", "vthought"));
        CopyrightProcessor.addToProcMap(new FileProcessing("JAVA_LINE", CopyrightProcessor.makeCopyrightBlockAction(javaLineCopyrightText, javaLineParserCall, args.startyear(), false)).suffixes("tdesc", "policy", "secure"));
        CopyrightProcessor.addToProcMap(new FileProcessing("SHELL", CopyrightProcessor.makeCopyrightBlockAction(shellCopyrightText, shellLineParserCall, args.startyear(), true)).suffixes("config", "properties", "prp", "data", "txt", "text").fileNames("Makefile"));
        CopyrightProcessor.addToProcMap(new FileProcessing("SHELL_SCRIPT", CopyrightProcessor.makeCopyrightBlockAction(shellCopyrightText, shellLineParserCall, args.startyear(), true)).suffixes("ksh", "sh"));
        CopyrightProcessor.addToProcMap(new FileProcessing("IGNORE", af.getSkipAction()).suffixes("bnd", "sxc", "sxi", "sxw", "odp", "gif", "png", "jar", "zip", "jpg", "pom", "pdf", "doc", "mif", "fm", "book", "cvsignore", "hgignore", "list", "old", "orig", "rej", "swp", "swo", "class", "o", "css").fileNames("NORENAME", "errorfile"));
    }

    private static List<String> getProp(Properties props, String name, List<String> defaultValue) {
        String str = props.getProperty(name);
        if (str == null) {
            return defaultValue;
        }
        return Arrays.asList(str.split(","));
    }

    public static void main(String[] strs) {
        ArgParser<Arguments> ap = new ArgParser<Arguments>(Arguments.class);
        args = ap.parse(strs);
        if (args.verbose() > 0) {
            CopyrightProcessor.trace("Main: args:\n" + args);
        }
        try {
            ActionFactory af = new ActionFactory(args.verbose(), args.dryrun());
            CopyrightProcessor.initializeScanners(af);
            Properties props = new Properties();
            if (args.configFile() != null && args.configFile().exists()) {
                try {
                    FileInputStream is = new FileInputStream(args.configFile());
                    props.load(is);
                }
                catch (IOException exc) {
                    System.out.println("Exception " + exc + " while attempting to read configFile " + args.configFile());
                }
            }
            Recognizer recognizer = af.getRecognizerAction();
            for (Map.Entry<String, FileProcessing> entry : procMap.entrySet()) {
                String name = entry.getKey();
                FileProcessing fp = entry.getValue();
                Scanner.Action action = fp.action();
                List<String> suffixes = CopyrightProcessor.getProp(props, "cptool." + name + ".suffixes", fp.suffixes());
                List<String> fileNames = CopyrightProcessor.getProp(props, "cptool." + name + ".filenames", fp.fileNames());
                for (String str : suffixes) {
                    recognizer.addKnownSuffix(str, action);
                }
                for (String str : fileNames) {
                    recognizer.addKnownName(str, action);
                }
            }
            if (args.verbose() > 0) {
                CopyrightProcessor.trace("Main: contents of recognizer:");
                recognizer.dump();
            }
            Scanner scanner = new Scanner(args.verbose(), args.roots());
            for (String str : args.skipdirs()) {
                scanner.addDirectoryToSkip(str);
            }
            scanner.scan(recognizer);
        }
        catch (IOException exc) {
            System.out.println("Exception while processing: " + exc);
            exc.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BlockParserCall
    extends UnaryFunction<FileWrapper, List<Block>> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileProcessing {
        final String name;
        final Scanner.Action action;
        List<String> suffixes;
        List<String> fileNames;

        public FileProcessing(String name, Scanner.Action action) {
            this.name = name;
            this.action = action;
            this.suffixes = new ArrayList<String>();
            this.fileNames = new ArrayList<String>();
        }

        String name() {
            return this.name;
        }

        Scanner.Action action() {
            return this.action;
        }

        List<String> suffixes() {
            return this.suffixes;
        }

        FileProcessing suffixes(String ... args) {
            this.suffixes = Arrays.asList(args);
            return this;
        }

        List<String> fileNames() {
            return this.fileNames;
        }

        FileProcessing fileNames(String ... args) {
            this.fileNames = Arrays.asList(args);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Arguments {
        @DefaultValue(value="true")
        @Help(value="Set to true to validate copyright header; if false, generate/update/insert copyright headers as needed")
        public boolean validate();

        @DefaultValue(value="0")
        @Help(value="Set to >0 to get information about actions taken for every file.  Larger values give more detail.")
        public int verbose();

        @DefaultValue(value="true")
        @Help(value="Set to true to avoid modifying any files")
        public boolean dryrun();

        @Help(value="List of directories to process")
        @DefaultValue(value="")
        public List<File> roots();

        @Help(value="List of directory names that should be skipped")
        @DefaultValue(value="")
        public List<String> skipdirs();

        @Help(value="File containing text of copyright header.  This must not include any comment characters")
        @DefaultValue(value="")
        public FileWrapper copyright();

        @DefaultValue(value="1997")
        @Help(value="Default copyright start year, if not otherwise specified")
        public String startyear();

        @DefaultValue(value="")
        @Help(value="File containing file suffix and name configurations for recognizing different kinds of comment conventions")
        public File configFile();
    }
}

