/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLPart;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLPartDescriptorImpl;
import org.jvnet.wom.impl.WSDLPartImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Part
extends AbstractHandler {
    private WSDLContentHandlerEx runtime;
    private String expectedNS;
    private WSDLPartImpl part;
    private int state;

    public Part(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNS = expectedNamespace;
        this.state = 1;
    }

    protected Part(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        switch (this.state) {
            case 1: {
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("part")) {
                    this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
                    Attributes test = this.runtime.getCurrentAttributes();
                    this.processAttributes(test);
                    break;
                }
                super.enterElement(uri, localName, qname, atts);
            }
        }
    }

    private QName getDescriptorName(String qualifiedName) {
        String uri = this.runtime.resolveNamespacePrefix(XmlUtil.getPrefix(qualifiedName));
        String localname = XmlUtil.getLocalPart(qualifiedName);
        if (localname == null || localname.trim().equals("")) {
            return null;
        }
        return new QName(uri, localname);
    }

    private void processAttributes(Attributes test) throws SAXException {
        String qname;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        int index = test.getIndex("name");
        validattrs[index] = 1;
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:part", name), this.runtime.getLocator()));
        }
        QName descName = null;
        WSDLPart.WSDLPartDescriptor.Kind k = null;
        index = test.getIndex("element");
        if (index >= 0) {
            validattrs[index] = 1;
            qname = test.getValue(index);
            descName = this.getDescriptorName(qname);
            if (descName == null) {
                this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.invalidDescriptorName", name, "element", qname), this.runtime.getLocator()));
            }
            k = WSDLPart.WSDLPartDescriptor.Kind.ELEMENT;
        } else {
            index = test.getIndex("type");
            if (index >= 0) {
                validattrs[index] = 1;
                qname = test.getValue(index);
                descName = this.getDescriptorName(qname);
                if (descName == null) {
                    this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.invalidDescriptorName", name, "type", qname), this.runtime.getLocator()));
                }
                k = WSDLPart.WSDLPartDescriptor.Kind.TYPE;
            }
        }
        if (index == -1) {
            throw new SAXParseException(Messages.format("wsdl.missingElementOrType", name), this.runtime.getLocator());
        }
        WSDLPartDescriptorImpl descriptor = new WSDLPartDescriptorImpl(descName, k, this.runtime.document);
        this.part = new WSDLPartImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), descriptor, this.runtime.document);
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        switch (this.state) {
            case 1: {
                if (!uri.equals("http://schemas.xmlsoap.org/wsdl/") || !localName.equals("part")) break;
                this.endProcessingExtentionElement(this.part);
                this.revertToParentFromLeaveElement(this.part, this._cookie, uri, localName, qname);
                this.part.setDocumentation(this.getWSDLDocumentation());
            }
        }
    }
}

