/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprPrimaryPrefix;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public class OwExprArraySelectorSuffix
extends OwExprExpression
implements OwExprPrimaryPrefix {
    private static final String ARRAY_SNONYMOUS_SYMBOL = "0$A";
    private OwExprSymbolScope m_symbolScope;
    private OwExprExpression m_arraySelector;
    private OwExprPrimaryPrefix m_prefix;
    private OwExprPropertySymbol m_propertySymbol;

    public OwExprArraySelectorSuffix(OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p, OwExprPrimaryPrefix prefix_p, OwExprExpression arraySelector_p) {
        super(symbolTable_p, errorTable_p);
        this.m_prefix = prefix_p;
        this.m_arraySelector = arraySelector_p;
    }

    @Override
    public final OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        OwExprScope evaluationScope = this.m_symbolScope.solveScope(scope_p);
        OwExprNumericValue selectorValue = (OwExprNumericValue)this.m_arraySelector.evaluate(scope_p);
        return evaluationScope.at(selectorValue.toInt()).value();
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        if (!this.m_typeError) {
            if (this.m_propertySymbol != null) {
                boolean notFullyRegressed = true;
                while (notFullyRegressed) {
                    try {
                        OwExprExpressionType selectorType = this.m_arraySelector.type();
                        notFullyRegressed = selectorType.regressTo(OwExprType.NUMERIC);
                    }
                    catch (OwExprTypeMissmatchException e) {
                        throw new OwExprTypeMissmatchException(e.getMessage() + " in array selector. Numeric is required.", e);
                    }
                }
                return this.m_propertySymbol.getType();
            }
            throw new OwExprTypeMissmatchException("Invalid array access expression : " + this.toString());
        }
        return OwExprExpressionType.NOTYPE;
    }

    @Override
    public OwExprExpression expression() {
        if (!this.m_typeError) {
            try {
                this.regressToPorperty();
            }
            catch (OwExprTypeMissmatchException e) {
                this.m_errorTable.add(e);
                this.m_typeError = true;
            }
            this.initType();
        }
        return this;
    }

    @Override
    public OwExprFunctionSymbol regressToFunction() throws OwExprTypeMissmatchException {
        throw new OwExprTypeMissmatchException("Function arrays are not supported!");
    }

    @Override
    public OwExprPropertySymbol regressToPorperty() throws OwExprTypeMissmatchException {
        if (this.m_propertySymbol == null) {
            if (this.m_prefix != null) {
                this.m_symbolScope = this.m_prefix.regressToScope();
                OwExprSymbol prefixSymbol = this.m_symbolScope.getSymbol();
                this.m_propertySymbol = prefixSymbol.addPropertySymbol(ARRAY_SNONYMOUS_SYMBOL, OwExprType.ALL_TYPE_TYPES);
                this.m_propertySymbol.forceSymbolMatchInScope();
            } else {
                throw new OwExprTypeMissmatchException("Invalid function call!");
            }
        }
        return this.m_propertySymbol;
    }

    @Override
    public OwExprSymbolScope regressToScope() throws OwExprTypeMissmatchException {
        if (this.m_prefix != null) {
            OwExprExpression expression = this.expression();
            OwExprSymbol prefixSymbol = this.m_symbolScope.getSymbol();
            OwExprSymbol symbol = prefixSymbol.addAnonymousSymbol(ARRAY_SNONYMOUS_SYMBOL, expression.type());
            return new OwExprSymbolScope(symbol, expression);
        }
        throw new OwExprTypeMissmatchException("Invalid array access !");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.m_arraySelector.toString());
        sb.append("]");
        return this.m_prefix.toString() + sb.toString();
    }
}

