/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OwExprBinaryConversionTable {
    private static final Set NO_CONVERSION = new HashSet();
    private OwExprType[][] m_conversionTable = new OwExprType[OwExprType.ALL_TYPES.length][OwExprType.ALL_TYPES.length];
    private Map m_type1Conversions = new HashMap();
    private Map m_type2Conversions = new HashMap();

    public OwExprBinaryConversionTable() {
        for (int i = 0; i < this.m_conversionTable.length; ++i) {
            Arrays.fill(this.m_conversionTable[i], OwExprType.NOTYPE);
        }
    }

    private static void addDirectionalConversion(Map conversionsMap_p, OwExprType conversion_p, OwExprType type_p) {
        HashSet<OwExprType> conversionFromType = (HashSet<OwExprType>)conversionsMap_p.get(conversion_p);
        if (conversionFromType == null) {
            conversionFromType = new HashSet<OwExprType>();
            conversionsMap_p.put(conversion_p, conversionFromType);
        }
        conversionFromType.add(type_p);
    }

    public Set getConversionsType1(Set types_p) {
        HashSet conversions = new HashSet();
        for (OwExprType type : types_p) {
            conversions.addAll(this.getConversionsType1(type));
        }
        return conversions;
    }

    public Set getConversionsType2(Set types_p) {
        HashSet conversions = new HashSet();
        for (OwExprType type : types_p) {
            conversions.addAll(this.getConversionsType2(type));
        }
        return conversions;
    }

    public Set getConversionsType1(OwExprType type_p) {
        Set type1Conversions = (Set)this.m_type1Conversions.get(type_p);
        return type1Conversions != null ? type1Conversions : NO_CONVERSION;
    }

    public Set getConversionsType2(OwExprType type_p) {
        Set type2Conversions = (Set)this.m_type2Conversions.get(type_p);
        return type2Conversions != null ? type2Conversions : NO_CONVERSION;
    }

    public final void add(OwExprType type1_p, OwExprType[] types2_p, OwExprType conversion_p) {
        for (int i = 0; i < types2_p.length; ++i) {
            this.add(type1_p, types2_p[i], conversion_p);
        }
    }

    public final void add(OwExprType[] types1_p, OwExprType type2_p, OwExprType conversion_p) {
        for (int i = 0; i < types1_p.length; ++i) {
            this.add(types1_p[i], type2_p, conversion_p);
        }
    }

    public final void add(OwExprType type1_p, OwExprType type2_p, OwExprType conversion_p) {
        if (!conversion_p.equals(OwExprType.NOTYPE)) {
            if (!this.m_conversionTable[type1_p.m_conversionIndex][type2_p.m_conversionIndex].equals(OwExprType.NOTYPE)) {
                throw new RuntimeException("The binary conversion table only supports NOTYPE-override !");
            }
        } else {
            throw new IllegalArgumentException("The binary conversion table does not support delete-conversion-by-NOTYPE!");
        }
        this.m_conversionTable[type1_p.m_conversionIndex][type2_p.m_conversionIndex] = conversion_p;
        OwExprBinaryConversionTable.addDirectionalConversion(this.m_type1Conversions, conversion_p, type1_p);
        OwExprBinaryConversionTable.addDirectionalConversion(this.m_type2Conversions, conversion_p, type2_p);
    }

    public final OwExprType convert(OwExprType type1_p, OwExprType type2_p) {
        return this.m_conversionTable[type1_p.m_conversionIndex][type2_p.m_conversionIndex];
    }
}

