/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public class OwExprBinaryExpression
extends OwExprExpression {
    private OwExprExpression m_operand1;
    private OwExprBinaryOperator m_operator;
    private OwExprExpression m_operand2;

    public OwExprBinaryExpression(OwExprSymbolTable symTable_p, OwExprErrorTable errorTable_p, OwExprExpression operand1_p, OwExprBinaryOperator operator_p, OwExprExpression operand2_p) {
        super(symTable_p, errorTable_p);
        this.m_operand1 = operand1_p;
        this.m_operator = operator_p;
        this.m_operand2 = operand2_p;
        this.initType();
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        OwExprValue v1 = this.m_operand1.evaluate(scope_p);
        OwExprValue v2 = this.m_operand2.evaluate(scope_p);
        return this.m_operator.binaryEvaluation(scope_p, v1, v2);
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        if (this.m_typeError) {
            return OwExprExpressionType.NOTYPE;
        }
        return this.m_operator.computeExpressionType(this.m_operand1, this.m_operand2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_operand1.toString());
        sb.append(this.m_operator.toString());
        sb.append(this.m_operand2.toString());
        return sb.toString();
    }
}

