/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprUnaryOperator;
import com.wewebu.expression.language.OwExprValue;

public class OwExprBooleanValue
extends OwExprValue {
    public static final OwExprBooleanValue TRUE = new OwExprBooleanValue(true);
    public static final OwExprBooleanValue FALSE = new OwExprBooleanValue(false);
    private boolean m_boolean;

    public static final OwExprBooleanValue value(boolean bool_p) {
        return bool_p ? TRUE : FALSE;
    }

    public static final OwExprBooleanValue value(Boolean bool_p) {
        return OwExprBooleanValue.value((boolean)bool_p);
    }

    private OwExprBooleanValue(boolean bool_p) {
        super(Boolean.class);
        this.m_boolean = bool_p;
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(this, v2_p);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprBooleanValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprUnaryOperator unaryOperator_p) throws OwExprEvaluationException {
        return unaryOperator_p.evaluate(this);
    }

    public boolean getBoolean() {
        return this.m_boolean;
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprBooleanValue) {
            OwExprBooleanValue booleanObject = (OwExprBooleanValue)obj_p;
            return this.m_boolean == booleanObject.m_boolean;
        }
        return false;
    }

    public int hashCode() {
        return new Boolean(this.m_boolean).hashCode();
    }

    public String toString() {
        return "" + this.m_boolean;
    }

    @Override
    public Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        return new Boolean(this.m_boolean);
    }
}

